/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.api.certificates;

import com.google.common.base.Strings;
import io.hops.hopsworks.api.auth.key.ApiKeyRequired;
import io.hops.hopsworks.ca.api.certificates.CSRView;
import io.hops.hopsworks.ca.api.certificates.KubeCertsResource;
import io.hops.hopsworks.ca.api.filter.NoCacheResponse;
import io.hops.hopsworks.ca.controllers.CAException;
import io.hops.hopsworks.ca.controllers.CAInitializationException;
import io.hops.hopsworks.ca.controllers.CertificateNotFoundException;
import io.hops.hopsworks.ca.controllers.CertificateType;
import io.hops.hopsworks.ca.controllers.PKI;
import io.hops.hopsworks.ca.controllers.PKIUtils;
import io.hops.hopsworks.jwt.annotation.JWTRequired;
import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiScope;
import io.hops.hopsworks.restutils.RESTCodes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.naming.InvalidNameException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.operator.OperatorCreationException;

@RequestScoped
@Api(value="Kubernetes certificate service", description="Manage Kubernetes certificates")
public class KubeCertsResource {
    @EJB
    private NoCacheResponse noCacheResponse;
    @EJB
    private PKIUtils pkiUtils;
    @EJB
    private PKI pki;

    @ApiOperation(value="Sign Kubernetes certificate with KubeCA", response=CSRView.class)
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @JWTRequired(acceptedTokens={"services"}, allowedUserRoles={"AGENT"})
    @ApiKeyRequired(acceptedScopes={ApiScope.AUTH}, allowedUserRoles={"AGENT"})
    public Response signCSR(CSRView csrView) throws CAException {
        if (csrView == null || csrView.getCsr() == null || csrView.getCsr().isEmpty()) {
            throw new IllegalArgumentException("Empty CSR");
        }
        try {
            X509Certificate signedCert = this.pki.signCertificateSigningRequest(csrView.getCsr(), CertificateType.KUBE, csrView.getRegion());
            String stringifiedCert = this.pkiUtils.convertToPEM((X509Extension)signedCert);
            Pair chainOfTrust = this.pki.getChainOfTrust(this.pkiUtils.getResponsibleCA(CertificateType.KUBE));
            CSRView signedCsr = new CSRView(stringifiedCert, (String)chainOfTrust.getLeft(), (String)chainOfTrust.getRight());
            1 csrViewGenericEntity = new /* Unavailable Anonymous Inner Class!! */;
            return this.noCacheResponse.getNoCacheResponseBuilder(Response.Status.OK).entity((Object)csrViewGenericEntity).build();
        }
        catch (CAInitializationException | IOException | GeneralSecurityException | OperatorCreationException ex) {
            throw this.pkiUtils.csrSigningExceptionConvertToCAException(ex, CertificateType.KUBE);
        }
    }

    @ApiOperation(value="Revoke KubeCA certificates")
    @DELETE
    @JWTRequired(acceptedTokens={"services"}, allowedUserRoles={"AGENT"})
    @ApiKeyRequired(acceptedScopes={ApiScope.AUTH}, allowedUserRoles={"AGENT"})
    public Response revokeCertificate(@ApiParam(value="Identifier of the Certificate to revoke", required=true) @QueryParam(value="certId") String certId, @ApiParam(value="Flag whether certId is a full RFC4514 Distinguished Name string") @QueryParam(value="exact") Boolean exact) throws CAException {
        if (Strings.isNullOrEmpty((String)certId)) {
            throw new IllegalArgumentException("Empty certificate identifier");
        }
        ArrayList<X500Name> subjectsToRevoke = new ArrayList<X500Name>();
        try {
            if (!Boolean.TRUE.equals(exact)) {
                X500Name certificateName = this.pkiUtils.parseCertificateSubjectName(certId, CertificateType.KUBE);
                List subjects = this.pkiUtils.findAllValidSubjectsWithPartialMatch(certificateName.toString());
                subjects.forEach(s -> subjectsToRevoke.add(new X500Name(s)));
            } else {
                subjectsToRevoke.add(new X500Name(certId));
            }
            if (subjectsToRevoke.isEmpty()) {
                throw new CertificateNotFoundException("Could not find a VALID certificate with ID: " + certId + " Is exact X509 Name: " + exact);
            }
            for (X500Name n : subjectsToRevoke) {
                this.pki.revokeCertificate(n, CertificateType.KUBE);
            }
            return Response.ok().build();
        }
        catch (CAInitializationException | GeneralSecurityException | InvalidNameException ex) {
            throw this.pkiUtils.certificateRevocationExceptionConvertToCAException(ex, CertificateType.KUBE);
        }
    }

    @ApiOperation(value="Get KubeCA certificate", response=CSRView.class)
    @GET
    @Produces(value={"application/json"})
    @JWTRequired(acceptedTokens={"services"}, allowedUserRoles={"AGENT"})
    @ApiKeyRequired(acceptedScopes={ApiScope.AUTH}, allowedUserRoles={"AGENT"})
    public Response getCACert() throws CAException {
        try {
            Pair chainOfTrust = this.pki.getChainOfTrust(this.pkiUtils.getResponsibleCA(CertificateType.KUBE));
            CSRView csrView = new CSRView((String)chainOfTrust.getLeft(), (String)chainOfTrust.getRight());
            2 csrViewGenericEntity = new /* Unavailable Anonymous Inner Class!! */;
            return this.noCacheResponse.getNoCacheResponseBuilder(Response.Status.OK).entity((Object)csrViewGenericEntity).build();
        }
        catch (CAInitializationException | IOException | GeneralSecurityException ex) {
            throw new CAException(RESTCodes.CAErrorCode.CA_INITIALIZATION_ERROR, Level.SEVERE, CertificateType.KUBE, "Failed to get chain of trust", "Failed to get chain of trust for KUBE certificates", ex);
        }
    }
}

