/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.api.certificates;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@ApiModel(value="Represents a certificate signing request")
public class CSRView {
    private String privateKey;
    private String csr;
    private String signedCert;
    private String intermediateCaCert;
    private String rootCaCert;
    private String keyStore;
    private String trustStore;
    private String password;
    private String region;

    public CSRView() {
    }

    public CSRView(String csr, String signedCert, String rootCaCert, String intermediateCaCert) {
        this.csr = csr;
        this.signedCert = signedCert;
        this.intermediateCaCert = intermediateCaCert;
        this.rootCaCert = rootCaCert;
    }

    public CSRView(String signedCert, String rootCaCert, String intermediateCaCert) {
        this.signedCert = signedCert;
        this.intermediateCaCert = intermediateCaCert;
        this.rootCaCert = rootCaCert;
    }

    public CSRView(String rootCaCert, String intermediateCaCert) {
        this.intermediateCaCert = intermediateCaCert;
        this.rootCaCert = rootCaCert;
    }

    @ApiModelProperty(value="PKCS8 encoded private key used to create Java keystore")
    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @ApiModelProperty(value="String containing the certificate signing request", required=true)
    public String getCsr() {
        return this.csr;
    }

    public void setCsr(String csr) {
        this.csr = csr;
    }

    @ApiModelProperty(value="String containing the certificate signed by the Intermediate CA", readOnly=true)
    public String getSignedCert() {
        return this.signedCert;
    }

    public void setSignedCert(String signedCert) {
        this.signedCert = signedCert;
    }

    @ApiModelProperty(value="String containing the certificate of the Intermediate CA", readOnly=true)
    public String getIntermediateCaCert() {
        return this.intermediateCaCert;
    }

    public void setIntermediateCaCert(String intermediateCaCert) {
        this.intermediateCaCert = intermediateCaCert;
    }

    @ApiModelProperty(value="String containing the certificate of the Root CA", readOnly=true)
    public String getRootCaCert() {
        return this.rootCaCert;
    }

    public void setRootCaCert(String rootCaCert) {
        this.rootCaCert = rootCaCert;
    }

    @ApiModelProperty(value="Base64 encoded keystore containing signed certificate and intermediate CA locked by password")
    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    @ApiModelProperty(value="Base64 encoded trustore containing Hopsworks root CA certificate locked by password")
    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    @ApiModelProperty(value="Randomly generated password to protect keystore and truststore")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ApiModelProperty(value="Consul region to inject in the SAN Domain names")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }
}

