/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.api.certificates;

import io.hops.hopsworks.ca.api.filter.NoCacheResponse;
import io.hops.hopsworks.ca.controllers.CAException;
import io.hops.hopsworks.ca.controllers.CAInitializationException;
import io.hops.hopsworks.ca.controllers.CertificateType;
import io.hops.hopsworks.ca.controllers.PKI;
import io.hops.hopsworks.persistence.entity.pki.CAType;
import io.hops.hopsworks.restutils.RESTCodes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@ApplicationScoped
@Api(value="Resource to download HopsCA Certificate Revocation Lists")
public class CRLResource {
    @EJB
    private PKI pki;
    @EJB
    private NoCacheResponse noCacheResponse;

    @Path(value="/intermediate")
    @GET
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Endpoint to download HopsCA intermediate CA Certificate Revocation List")
    public Response fetchCRL() throws CAException {
        try {
            String crl = this.pki.getCertificateRevocationListPEM(CAType.INTERMEDIATE);
            return this.noCacheResponse.getNoCacheResponseBuilder(Response.Status.OK).entity((Object)crl).build();
        }
        catch (CAInitializationException | IOException | GeneralSecurityException ex) {
            throw new CAException(RESTCodes.CAErrorCode.CERTIFICATE_REVOCATION_LIST_READ, Level.SEVERE, CertificateType.APP, "Failed to read CRL", ex.getMessage(), ex);
        }
    }
}

