/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.org.xbill.DNS;

import com.logicalclocks.shaded.org.xbill.DNS.Compression;
import com.logicalclocks.shaded.org.xbill.DNS.DNSInput;
import com.logicalclocks.shaded.org.xbill.DNS.DNSOutput;
import com.logicalclocks.shaded.org.xbill.DNS.Name;
import com.logicalclocks.shaded.org.xbill.DNS.Record;
import com.logicalclocks.shaded.org.xbill.DNS.TextParseException;
import com.logicalclocks.shaded.org.xbill.DNS.Tokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

abstract class TXTBase
extends Record {
    protected List<byte[]> strings;

    protected TXTBase() {
    }

    protected TXTBase(Name name, int type, int dclass, long ttl) {
        super(name, type, dclass, ttl);
    }

    protected TXTBase(Name name, int type, int dclass, long ttl, List<String> strings) {
        super(name, type, dclass, ttl);
        if (strings == null) {
            throw new IllegalArgumentException("strings must not be null");
        }
        this.strings = new ArrayList<byte[]>(strings.size());
        Iterator<String> it = strings.iterator();
        try {
            while (it.hasNext()) {
                String s2 = it.next();
                this.strings.add(TXTBase.byteArrayFromString(s2));
            }
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected TXTBase(Name name, int type, int dclass, long ttl, String string) {
        this(name, type, dclass, ttl, Collections.singletonList(string));
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.strings = new ArrayList<byte[]>(2);
        while (in.remaining() > 0) {
            byte[] b = in.readCountedString();
            this.strings.add(b);
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        Tokenizer.Token t;
        this.strings = new ArrayList<byte[]>(2);
        while ((t = st.get()).isString()) {
            try {
                this.strings.add(TXTBase.byteArrayFromString(t.value));
            }
            catch (TextParseException e) {
                throw st.exception(e.getMessage());
            }
        }
        st.unget();
    }

    @Override
    String rrToString() {
        StringBuilder sb = new StringBuilder();
        Iterator<byte[]> it = this.strings.iterator();
        while (it.hasNext()) {
            byte[] array = it.next();
            sb.append(TXTBase.byteArrayToString(array, true));
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public List<String> getStrings() {
        ArrayList<String> list = new ArrayList<String>(this.strings.size());
        for (byte[] string : this.strings) {
            list.add(TXTBase.byteArrayToString(string, false));
        }
        return list;
    }

    public List<byte[]> getStringsAsByteArrays() {
        return this.strings;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        for (byte[] b : this.strings) {
            out.writeCountedString(b);
        }
    }
}

