/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.org.xbill.DNS;

import com.logicalclocks.shaded.org.xbill.DNS.Name;
import com.logicalclocks.shaded.org.xbill.DNS.config.AndroidResolverConfigProvider;
import com.logicalclocks.shaded.org.xbill.DNS.config.InitializationException;
import com.logicalclocks.shaded.org.xbill.DNS.config.JndiContextResolverConfigProvider;
import com.logicalclocks.shaded.org.xbill.DNS.config.PropertyResolverConfigProvider;
import com.logicalclocks.shaded.org.xbill.DNS.config.ResolvConfResolverConfigProvider;
import com.logicalclocks.shaded.org.xbill.DNS.config.ResolverConfigProvider;
import com.logicalclocks.shaded.org.xbill.DNS.config.SunJvmResolverConfigProvider;
import com.logicalclocks.shaded.org.xbill.DNS.config.WindowsResolverConfigProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResolverConfig {
    private static final Logger log = LoggerFactory.getLogger(ResolverConfig.class);
    private List<InetSocketAddress> servers = new ArrayList<InetSocketAddress>(2);
    private List<Name> searchlist = new ArrayList<Name>(0);
    private int ndots = 1;
    private static ResolverConfig currentConfig;
    private static List<ResolverConfigProvider> configProviders;

    public static synchronized ResolverConfig getCurrentConfig() {
        return currentConfig;
    }

    public static synchronized void setConfigProviders(List<ResolverConfigProvider> providers) {
        configProviders = new ArrayList<ResolverConfigProvider>(providers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        ResolverConfig newConfig = new ResolverConfig();
        Class<ResolverConfig> clazz = ResolverConfig.class;
        synchronized (ResolverConfig.class) {
            currentConfig = newConfig;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public ResolverConfig() {
        for (ResolverConfigProvider provider : configProviders) {
            if (!provider.isEnabled()) continue;
            try {
                List<Name> lsearchPaths;
                provider.initialize();
                if (this.servers.isEmpty()) {
                    this.servers.addAll(provider.servers());
                }
                if (this.searchlist.isEmpty() && !(lsearchPaths = provider.searchPaths()).isEmpty()) {
                    this.searchlist.addAll(lsearchPaths);
                    this.ndots = provider.ndots();
                }
                if (this.servers.isEmpty() || this.searchlist.isEmpty()) continue;
                return;
            }
            catch (InitializationException e) {
                log.warn("Failed to initialize provider", (Throwable)e);
            }
        }
        if (this.servers.isEmpty()) {
            this.servers.add(new InetSocketAddress(InetAddress.getLoopbackAddress(), 53));
        }
    }

    public List<InetSocketAddress> servers() {
        return this.servers;
    }

    public InetSocketAddress server() {
        return this.servers.get(0);
    }

    public List<Name> searchPath() {
        return this.searchlist;
    }

    public int ndots() {
        return this.ndots;
    }

    static {
        configProviders = new ArrayList<ResolverConfigProvider>(8);
        configProviders.add(new PropertyResolverConfigProvider());
        configProviders.add(new ResolvConfResolverConfigProvider());
        configProviders.add(new WindowsResolverConfigProvider());
        configProviders.add(new AndroidResolverConfigProvider());
        configProviders.add(new JndiContextResolverConfigProvider());
        configProviders.add(new SunJvmResolverConfigProvider());
        ResolverConfig.refresh();
    }
}

