/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.org.xbill.DNS;

import com.logicalclocks.shaded.org.xbill.DNS.Compression;
import com.logicalclocks.shaded.org.xbill.DNS.DNSInput;
import com.logicalclocks.shaded.org.xbill.DNS.DNSOutput;
import com.logicalclocks.shaded.org.xbill.DNS.Name;
import com.logicalclocks.shaded.org.xbill.DNS.Record;
import com.logicalclocks.shaded.org.xbill.DNS.TextParseException;
import com.logicalclocks.shaded.org.xbill.DNS.Tokenizer;
import java.io.IOException;

public class NAPTRRecord
extends Record {
    private int order;
    private int preference;
    private byte[] flags;
    private byte[] service;
    private byte[] regexp;
    private Name replacement;

    NAPTRRecord() {
    }

    public NAPTRRecord(Name name, int dclass, long ttl, int order, int preference, String flags, String service, String regexp, Name replacement) {
        super(name, 35, dclass, ttl);
        this.order = NAPTRRecord.checkU16("order", order);
        this.preference = NAPTRRecord.checkU16("preference", preference);
        try {
            this.flags = NAPTRRecord.byteArrayFromString(flags);
            this.service = NAPTRRecord.byteArrayFromString(service);
            this.regexp = NAPTRRecord.byteArrayFromString(regexp);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.replacement = NAPTRRecord.checkName("replacement", replacement);
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.order = in.readU16();
        this.preference = in.readU16();
        this.flags = in.readCountedString();
        this.service = in.readCountedString();
        this.regexp = in.readCountedString();
        this.replacement = new Name(in);
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.order = st.getUInt16();
        this.preference = st.getUInt16();
        try {
            this.flags = NAPTRRecord.byteArrayFromString(st.getString());
            this.service = NAPTRRecord.byteArrayFromString(st.getString());
            this.regexp = NAPTRRecord.byteArrayFromString(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
        this.replacement = st.getName(origin);
    }

    @Override
    String rrToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.order);
        sb.append(" ");
        sb.append(this.preference);
        sb.append(" ");
        sb.append(NAPTRRecord.byteArrayToString(this.flags, true));
        sb.append(" ");
        sb.append(NAPTRRecord.byteArrayToString(this.service, true));
        sb.append(" ");
        sb.append(NAPTRRecord.byteArrayToString(this.regexp, true));
        sb.append(" ");
        sb.append(this.replacement);
        return sb.toString();
    }

    public int getOrder() {
        return this.order;
    }

    public int getPreference() {
        return this.preference;
    }

    public String getFlags() {
        return NAPTRRecord.byteArrayToString(this.flags, false);
    }

    public String getService() {
        return NAPTRRecord.byteArrayToString(this.service, false);
    }

    public String getRegexp() {
        return NAPTRRecord.byteArrayToString(this.regexp, false);
    }

    public Name getReplacement() {
        return this.replacement;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU16(this.order);
        out.writeU16(this.preference);
        out.writeCountedString(this.flags);
        out.writeCountedString(this.service);
        out.writeCountedString(this.regexp);
        this.replacement.toWire(out, null, canonical);
    }

    @Override
    public Name getAdditionalName() {
        return this.replacement;
    }
}

