/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul.util.failover;

import com.logicalclocks.shaded.com.google.common.net.HostAndPort;
import com.logicalclocks.shaded.com.orbitz.consul.ConsulException;
import com.logicalclocks.shaded.com.orbitz.consul.util.failover.strategy.BlacklistingConsulFailoverStrategy;
import com.logicalclocks.shaded.com.orbitz.consul.util.failover.strategy.ConsulFailoverStrategy;
import com.logicalclocks.shaded.okhttp3.Interceptor;
import com.logicalclocks.shaded.okhttp3.Request;
import com.logicalclocks.shaded.okhttp3.Response;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulFailoverInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulFailoverInterceptor.class);
    private ConsulFailoverStrategy strategy;

    public ConsulFailoverInterceptor(Collection<HostAndPort> targets, long timeout) {
        this(new BlacklistingConsulFailoverStrategy(targets, timeout));
    }

    public ConsulFailoverInterceptor(ConsulFailoverStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        if (this.strategy.isRequestViable(originalRequest)) {
            Optional<Request> nextRequest;
            Request previousRequest = originalRequest;
            Response previousResponse = null;
            while ((nextRequest = this.strategy.computeNextStage(previousRequest, previousResponse)).isPresent()) {
                try {
                    Request next;
                    previousRequest = next = nextRequest.get();
                    return chain.proceed(next);
                }
                catch (Exception ex) {
                    LOGGER.debug("Failed to connect to {}", (Object)nextRequest.get().url(), (Object)ex);
                    this.strategy.markRequestFailed(nextRequest.get());
                }
            }
            throw new ConsulException("Unable to successfully determine a viable host for communication.");
        }
        throw new ConsulException("Consul failover strategy has determined that there are no viable hosts remaining.");
    }
}

