/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul.option;

import com.logicalclocks.shaded.com.google.common.base.MoreObjects;
import com.logicalclocks.shaded.com.google.common.collect.ImmutableList;
import com.logicalclocks.shaded.com.google.common.primitives.Booleans;
import com.logicalclocks.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.logicalclocks.shaded.com.orbitz.consul.option.ConsistencyMode;
import com.logicalclocks.shaded.com.orbitz.consul.option.QueryOptions;
import com.logicalclocks.shaded.org.immutables.value.Generated;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="QueryOptions", generator="Immutables")
@Immutable
public final class ImmutableQueryOptions
extends QueryOptions {
    @Nullable
    private final String wait;
    @Nullable
    private final String token;
    @Nullable
    private final String hash;
    @Nullable
    private final BigInteger index;
    @Nullable
    private final String near;
    @Nullable
    private final String datacenter;
    private final ImmutableList<String> nodeMeta;
    private final ImmutableList<String> tag;
    private final ConsistencyMode consistencyMode;
    private final transient boolean isBlocking;
    private final transient boolean hasToken;
    private final transient List<String> nodeMetaQuery;
    private final transient List<String> tagsQuery;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableQueryOptions(Builder builder) {
        this.wait = builder.wait;
        this.token = builder.token;
        this.hash = builder.hash;
        this.index = builder.index;
        this.near = builder.near;
        this.datacenter = builder.datacenter;
        this.nodeMeta = builder.nodeMeta.build();
        this.tag = builder.tag.build();
        if (builder.consistencyMode != null) {
            this.initShim.consistencyMode(builder.consistencyMode);
        }
        this.consistencyMode = this.initShim.getConsistencyMode();
        this.isBlocking = this.initShim.isBlocking();
        this.hasToken = this.initShim.hasToken();
        this.nodeMetaQuery = this.initShim.getNodeMetaQuery();
        this.tagsQuery = this.initShim.getTagsQuery();
        this.initShim = null;
    }

    private ImmutableQueryOptions(@Nullable String wait, @Nullable String token, @Nullable String hash, @Nullable BigInteger index, @Nullable String near, @Nullable String datacenter, ImmutableList<String> nodeMeta, ImmutableList<String> tag, ConsistencyMode consistencyMode) {
        this.wait = wait;
        this.token = token;
        this.hash = hash;
        this.index = index;
        this.near = near;
        this.datacenter = datacenter;
        this.nodeMeta = nodeMeta;
        this.tag = tag;
        this.initShim.consistencyMode(consistencyMode);
        this.consistencyMode = this.initShim.getConsistencyMode();
        this.isBlocking = this.initShim.isBlocking();
        this.hasToken = this.initShim.hasToken();
        this.nodeMetaQuery = this.initShim.getNodeMetaQuery();
        this.tagsQuery = this.initShim.getTagsQuery();
        this.initShim = null;
    }

    @Override
    public Optional<String> getWait() {
        return Optional.ofNullable(this.wait);
    }

    @Override
    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    @Override
    public Optional<String> getHash() {
        return Optional.ofNullable(this.hash);
    }

    @Override
    public Optional<BigInteger> getIndex() {
        return Optional.ofNullable(this.index);
    }

    @Override
    public Optional<String> getNear() {
        return Optional.ofNullable(this.near);
    }

    @Override
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    public ImmutableList<String> getNodeMeta() {
        return this.nodeMeta;
    }

    public ImmutableList<String> getTag() {
        return this.tag;
    }

    @Override
    public ConsistencyMode getConsistencyMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getConsistencyMode() : this.consistencyMode;
    }

    @Override
    public boolean isBlocking() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isBlocking() : this.isBlocking;
    }

    @Override
    public boolean hasToken() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasToken() : this.hasToken;
    }

    @Override
    public List<String> getNodeMetaQuery() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getNodeMetaQuery() : this.nodeMetaQuery;
    }

    @Override
    public List<String> getTagsQuery() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTagsQuery() : this.tagsQuery;
    }

    public final ImmutableQueryOptions withWait(String value) {
        String newValue = Objects.requireNonNull(value, "wait");
        if (Objects.equals(this.wait, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(newValue, this.token, this.hash, this.index, this.near, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withWait(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.wait, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(value, this.token, this.hash, this.index, this.near, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (Objects.equals(this.token, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, newValue, this.hash, this.index, this.near, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withToken(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, value, this.hash, this.index, this.near, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (Objects.equals(this.hash, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, newValue, this.index, this.near, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withHash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, value, this.index, this.near, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withIndex(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "index");
        if (Objects.equals(this.index, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.hash, newValue, this.near, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withIndex(Optional<? extends BigInteger> optional) {
        BigInteger value = optional.orElse(null);
        if (Objects.equals(this.index, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.hash, value, this.near, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNear(String value) {
        String newValue = Objects.requireNonNull(value, "near");
        if (Objects.equals(this.near, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.hash, this.index, newValue, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNear(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.near, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.hash, this.index, value, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.hash, this.index, this.near, newValue, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.hash, this.index, this.near, value, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNodeMeta(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.hash, this.index, this.near, this.datacenter, newValue, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNodeMeta(Iterable<String> elements) {
        if (this.nodeMeta == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.hash, this.index, this.near, this.datacenter, newValue, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withTag(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.nodeMeta, newValue, this.consistencyMode));
    }

    public final ImmutableQueryOptions withTag(Iterable<String> elements) {
        if (this.tag == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.nodeMeta, newValue, this.consistencyMode));
    }

    public final ImmutableQueryOptions withConsistencyMode(ConsistencyMode value) {
        if (this.consistencyMode == value) {
            return this;
        }
        ConsistencyMode newValue = Objects.requireNonNull(value, "consistencyMode");
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.nodeMeta, this.tag, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryOptions && this.equalTo((ImmutableQueryOptions)another);
    }

    private boolean equalTo(ImmutableQueryOptions another) {
        return Objects.equals(this.wait, another.wait) && Objects.equals(this.token, another.token) && Objects.equals(this.hash, another.hash) && Objects.equals(this.index, another.index) && Objects.equals(this.near, another.near) && Objects.equals(this.datacenter, another.datacenter) && this.nodeMeta.equals(another.nodeMeta) && this.tag.equals(another.tag) && this.consistencyMode.equals(another.consistencyMode) && this.isBlocking == another.isBlocking && this.hasToken == another.hasToken && this.nodeMetaQuery.equals(another.nodeMetaQuery) && this.tagsQuery.equals(another.tagsQuery);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.wait);
        h2 += (h2 << 5) + Objects.hashCode(this.token);
        h2 += (h2 << 5) + Objects.hashCode(this.hash);
        h2 += (h2 << 5) + Objects.hashCode(this.index);
        h2 += (h2 << 5) + Objects.hashCode(this.near);
        h2 += (h2 << 5) + Objects.hashCode(this.datacenter);
        h2 += (h2 << 5) + this.nodeMeta.hashCode();
        h2 += (h2 << 5) + this.tag.hashCode();
        h2 += (h2 << 5) + this.consistencyMode.hashCode();
        h2 += (h2 << 5) + Booleans.hashCode(this.isBlocking);
        h2 += (h2 << 5) + Booleans.hashCode(this.hasToken);
        h2 += (h2 << 5) + this.nodeMetaQuery.hashCode();
        h2 += (h2 << 5) + this.tagsQuery.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("QueryOptions").omitNullValues().add("wait", this.wait).add("token", this.token).add("hash", this.hash).add("index", this.index).add("near", this.near).add("datacenter", this.datacenter).add("nodeMeta", this.nodeMeta).add("tag", this.tag).add("consistencyMode", this.consistencyMode).add("isBlocking", this.isBlocking).add("hasToken", this.hasToken).add("nodeMetaQuery", this.nodeMetaQuery).add("tagsQuery", this.tagsQuery).toString();
    }

    private static ImmutableQueryOptions validate(ImmutableQueryOptions instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableQueryOptions copyOf(QueryOptions instance) {
        if (instance instanceof ImmutableQueryOptions) {
            return (ImmutableQueryOptions)instance;
        }
        return ImmutableQueryOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QueryOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String wait;
        @Nullable
        private String token;
        @Nullable
        private String hash;
        @Nullable
        private BigInteger index;
        @Nullable
        private String near;
        @Nullable
        private String datacenter;
        private ImmutableList.Builder<String> nodeMeta = ImmutableList.builder();
        private ImmutableList.Builder<String> tag = ImmutableList.builder();
        @Nullable
        private ConsistencyMode consistencyMode;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(QueryOptions instance) {
            Optional<String> datacenterOptional;
            Optional<String> nearOptional;
            Optional<BigInteger> indexOptional;
            Optional<String> hashOptional;
            Optional<String> tokenOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> waitOptional = instance.getWait();
            if (waitOptional.isPresent()) {
                this.wait(waitOptional);
            }
            if ((tokenOptional = instance.getToken()).isPresent()) {
                this.token(tokenOptional);
            }
            if ((hashOptional = instance.getHash()).isPresent()) {
                this.hash(hashOptional);
            }
            if ((indexOptional = instance.getIndex()).isPresent()) {
                this.index(indexOptional);
            }
            if ((nearOptional = instance.getNear()).isPresent()) {
                this.near(nearOptional);
            }
            if ((datacenterOptional = instance.getDatacenter()).isPresent()) {
                this.datacenter(datacenterOptional);
            }
            this.addAllNodeMeta(instance.getNodeMeta());
            this.addAllTag(instance.getTag());
            this.consistencyMode(instance.getConsistencyMode());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wait(String wait) {
            this.wait = Objects.requireNonNull(wait, "wait");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wait(Optional<String> wait) {
            this.wait = wait.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(Optional<String> token) {
            this.token = token.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hash(Optional<String> hash) {
            this.hash = hash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder index(BigInteger index) {
            this.index = Objects.requireNonNull(index, "index");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder index(Optional<? extends BigInteger> index) {
            this.index = index.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder near(String near) {
            this.near = Objects.requireNonNull(near, "near");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder near(Optional<String> near) {
            this.near = near.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodeMeta(String element) {
            this.nodeMeta.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodeMeta(String ... elements) {
            this.nodeMeta.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nodeMeta(Iterable<String> elements) {
            this.nodeMeta = ImmutableList.builder();
            return this.addAllNodeMeta(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNodeMeta(Iterable<String> elements) {
            this.nodeMeta.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTag(String element) {
            this.tag.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTag(String ... elements) {
            this.tag.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tag(Iterable<String> elements) {
            this.tag = ImmutableList.builder();
            return this.addAllTag(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTag(Iterable<String> elements) {
            this.tag.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder consistencyMode(ConsistencyMode consistencyMode) {
            this.consistencyMode = Objects.requireNonNull(consistencyMode, "consistencyMode");
            return this;
        }

        public ImmutableQueryOptions build() {
            return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this));
        }
    }

    @Generated(from="QueryOptions", generator="Immutables")
    private final class InitShim {
        private byte consistencyModeBuildStage = 0;
        private ConsistencyMode consistencyMode;
        private byte isBlockingBuildStage = 0;
        private boolean isBlocking;
        private byte hasTokenBuildStage = 0;
        private boolean hasToken;
        private byte nodeMetaQueryBuildStage = 0;
        private List<String> nodeMetaQuery;
        private byte tagsQueryBuildStage = 0;
        private List<String> tagsQuery;

        private InitShim() {
        }

        ConsistencyMode getConsistencyMode() {
            if (this.consistencyModeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.consistencyModeBuildStage == 0) {
                this.consistencyModeBuildStage = (byte)-1;
                this.consistencyMode = Objects.requireNonNull(ImmutableQueryOptions.super.getConsistencyMode(), "consistencyMode");
                this.consistencyModeBuildStage = 1;
            }
            return this.consistencyMode;
        }

        void consistencyMode(ConsistencyMode consistencyMode) {
            this.consistencyMode = consistencyMode;
            this.consistencyModeBuildStage = 1;
        }

        boolean isBlocking() {
            if (this.isBlockingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isBlockingBuildStage == 0) {
                this.isBlockingBuildStage = (byte)-1;
                this.isBlocking = ImmutableQueryOptions.super.isBlocking();
                this.isBlockingBuildStage = 1;
            }
            return this.isBlocking;
        }

        boolean hasToken() {
            if (this.hasTokenBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTokenBuildStage == 0) {
                this.hasTokenBuildStage = (byte)-1;
                this.hasToken = ImmutableQueryOptions.super.hasToken();
                this.hasTokenBuildStage = 1;
            }
            return this.hasToken;
        }

        List<String> getNodeMetaQuery() {
            if (this.nodeMetaQueryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeMetaQueryBuildStage == 0) {
                this.nodeMetaQueryBuildStage = (byte)-1;
                this.nodeMetaQuery = Objects.requireNonNull(ImmutableQueryOptions.super.getNodeMetaQuery(), "nodeMetaQuery");
                this.nodeMetaQueryBuildStage = 1;
            }
            return this.nodeMetaQuery;
        }

        List<String> getTagsQuery() {
            if (this.tagsQueryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tagsQueryBuildStage == 0) {
                this.tagsQueryBuildStage = (byte)-1;
                this.tagsQuery = Objects.requireNonNull(ImmutableQueryOptions.super.getTagsQuery(), "tagsQuery");
                this.tagsQueryBuildStage = 1;
            }
            return this.tagsQuery;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.consistencyModeBuildStage == -1) {
                attributes.add("consistencyMode");
            }
            if (this.isBlockingBuildStage == -1) {
                attributes.add("isBlocking");
            }
            if (this.hasTokenBuildStage == -1) {
                attributes.add("hasToken");
            }
            if (this.nodeMetaQueryBuildStage == -1) {
                attributes.add("nodeMetaQuery");
            }
            if (this.tagsQueryBuildStage == -1) {
                attributes.add("tagsQuery");
            }
            return "Cannot build QueryOptions, attribute initializers form cycle " + attributes;
        }
    }
}

