/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul.model.health;

import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.logicalclocks.shaded.com.google.common.base.MoreObjects;
import com.logicalclocks.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.logicalclocks.shaded.com.orbitz.consul.model.catalog.TaggedAddresses;
import com.logicalclocks.shaded.com.orbitz.consul.model.health.Node;
import com.logicalclocks.shaded.org.immutables.value.Generated;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Node", generator="Immutables")
@Immutable
public final class ImmutableNode
extends Node {
    private final String node;
    private final String address;
    @Nullable
    private final String datacenter;
    @Nullable
    private final TaggedAddresses taggedAddresses;
    @Nullable
    private final Map<String, String> nodeMeta;

    private ImmutableNode(String node, String address, @Nullable String datacenter, @Nullable TaggedAddresses taggedAddresses, @Nullable Map<String, String> nodeMeta) {
        this.node = node;
        this.address = address;
        this.datacenter = datacenter;
        this.taggedAddresses = taggedAddresses;
        this.nodeMeta = nodeMeta;
    }

    @Override
    @JsonProperty(value="Node")
    public String getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Address")
    public String getAddress() {
        return this.address;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    @JsonProperty(value="TaggedAddresses")
    public Optional<TaggedAddresses> getTaggedAddresses() {
        return Optional.ofNullable(this.taggedAddresses);
    }

    @Override
    @JsonProperty(value="Meta")
    public Optional<Map<String, String>> getNodeMeta() {
        return Optional.ofNullable(this.nodeMeta);
    }

    public final ImmutableNode withNode(String value) {
        String newValue = Objects.requireNonNull(value, "node");
        if (this.node.equals(newValue)) {
            return this;
        }
        return new ImmutableNode(newValue, this.address, this.datacenter, this.taggedAddresses, this.nodeMeta);
    }

    public final ImmutableNode withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (this.address.equals(newValue)) {
            return this;
        }
        return new ImmutableNode(this.node, newValue, this.datacenter, this.taggedAddresses, this.nodeMeta);
    }

    public final ImmutableNode withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableNode(this.node, this.address, newValue, this.taggedAddresses, this.nodeMeta);
    }

    public final ImmutableNode withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableNode(this.node, this.address, value, this.taggedAddresses, this.nodeMeta);
    }

    public final ImmutableNode withTaggedAddresses(TaggedAddresses value) {
        TaggedAddresses newValue = Objects.requireNonNull(value, "taggedAddresses");
        if (this.taggedAddresses == newValue) {
            return this;
        }
        return new ImmutableNode(this.node, this.address, this.datacenter, newValue, this.nodeMeta);
    }

    public final ImmutableNode withTaggedAddresses(Optional<? extends TaggedAddresses> optional) {
        TaggedAddresses value = optional.orElse(null);
        if (this.taggedAddresses == value) {
            return this;
        }
        return new ImmutableNode(this.node, this.address, this.datacenter, value, this.nodeMeta);
    }

    public final ImmutableNode withNodeMeta(Map<String, String> value) {
        Map<String, String> newValue = Objects.requireNonNull(value, "nodeMeta");
        if (this.nodeMeta == newValue) {
            return this;
        }
        return new ImmutableNode(this.node, this.address, this.datacenter, this.taggedAddresses, newValue);
    }

    public final ImmutableNode withNodeMeta(Optional<? extends Map<String, String>> optional) {
        Map value = optional.orElse(null);
        if (this.nodeMeta == value) {
            return this;
        }
        return new ImmutableNode(this.node, this.address, this.datacenter, this.taggedAddresses, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNode && this.equalTo((ImmutableNode)another);
    }

    private boolean equalTo(ImmutableNode another) {
        return this.node.equals(another.node) && this.address.equals(another.address) && Objects.equals(this.datacenter, another.datacenter) && Objects.equals(this.taggedAddresses, another.taggedAddresses) && Objects.equals(this.nodeMeta, another.nodeMeta);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.node.hashCode();
        h2 += (h2 << 5) + this.address.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.datacenter);
        h2 += (h2 << 5) + Objects.hashCode(this.taggedAddresses);
        h2 += (h2 << 5) + Objects.hashCode(this.nodeMeta);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Node").omitNullValues().add("node", this.node).add("address", this.address).add("datacenter", this.datacenter).add("taggedAddresses", this.taggedAddresses).add("nodeMeta", this.nodeMeta).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNode fromJson(Json json) {
        Builder builder = ImmutableNode.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.datacenter != null) {
            builder.datacenter(json.datacenter);
        }
        if (json.taggedAddresses != null) {
            builder.taggedAddresses(json.taggedAddresses);
        }
        if (json.nodeMeta != null) {
            builder.nodeMeta(json.nodeMeta);
        }
        return builder.build();
    }

    public static ImmutableNode copyOf(Node instance) {
        if (instance instanceof ImmutableNode) {
            return (ImmutableNode)instance;
        }
        return ImmutableNode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Node", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_ADDRESS = 2L;
        private long initBits = 3L;
        @Nullable
        private String node;
        @Nullable
        private String address;
        @Nullable
        private String datacenter;
        @Nullable
        private TaggedAddresses taggedAddresses;
        @Nullable
        private Map<String, String> nodeMeta;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Node instance) {
            Optional<Map<String, String>> nodeMetaOptional;
            Optional<TaggedAddresses> taggedAddressesOptional;
            Objects.requireNonNull(instance, "instance");
            this.node(instance.getNode());
            this.address(instance.getAddress());
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            if ((taggedAddressesOptional = instance.getTaggedAddresses()).isPresent()) {
                this.taggedAddresses(taggedAddressesOptional);
            }
            if ((nodeMetaOptional = instance.getNodeMeta()).isPresent()) {
                this.nodeMeta(nodeMetaOptional);
            }
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder node(String node) {
            this.node = Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Address")
        @CanIgnoreReturnValue
        public final Builder address(String address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            return this;
        }

        @JsonProperty(value="Datacenter")
        @CanIgnoreReturnValue
        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder taggedAddresses(TaggedAddresses taggedAddresses) {
            this.taggedAddresses = Objects.requireNonNull(taggedAddresses, "taggedAddresses");
            return this;
        }

        @JsonProperty(value="TaggedAddresses")
        @CanIgnoreReturnValue
        public final Builder taggedAddresses(Optional<? extends TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nodeMeta(Map<String, String> nodeMeta) {
            this.nodeMeta = Objects.requireNonNull(nodeMeta, "nodeMeta");
            return this;
        }

        @JsonProperty(value="Meta")
        @CanIgnoreReturnValue
        public final Builder nodeMeta(Optional<? extends Map<String, String>> nodeMeta) {
            this.nodeMeta = nodeMeta.orElse(null);
            return this;
        }

        public ImmutableNode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNode(this.node, this.address, this.datacenter, this.taggedAddresses, this.nodeMeta);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("address");
            }
            return "Cannot build Node, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Node", generator="Immutables")
    static final class Json
    extends Node {
        @Nullable
        String node;
        @Nullable
        String address;
        @Nullable
        Optional<String> datacenter = Optional.empty();
        @Nullable
        Optional<TaggedAddresses> taggedAddresses = Optional.empty();
        @Nullable
        Optional<Map<String, String>> nodeMeta = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(Optional<String> datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="TaggedAddresses")
        public void setTaggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses;
        }

        @JsonProperty(value="Meta")
        public void setNodeMeta(Optional<Map<String, String>> nodeMeta) {
            this.nodeMeta = nodeMeta;
        }

        @Override
        public String getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDatacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TaggedAddresses> getTaggedAddresses() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Map<String, String>> getNodeMeta() {
            throw new UnsupportedOperationException();
        }
    }
}

