/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul.model.agent;

import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.logicalclocks.shaded.com.google.common.base.MoreObjects;
import com.logicalclocks.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.logicalclocks.shaded.com.orbitz.consul.model.agent.Telemetry;
import com.logicalclocks.shaded.org.immutables.value.Generated;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Telemetry", generator="Immutables")
@Immutable
public final class ImmutableTelemetry
extends Telemetry {
    private final String statsiteAddr;
    private final String statsdAddr;
    private final String statsitePrefix;
    private final Boolean disableHostname;
    private final String dogStatsdAddr;
    @Nullable
    private final List<String> dogStatsdTags;

    private ImmutableTelemetry(String statsiteAddr, String statsdAddr, String statsitePrefix, Boolean disableHostname, String dogStatsdAddr, @Nullable List<String> dogStatsdTags) {
        this.statsiteAddr = statsiteAddr;
        this.statsdAddr = statsdAddr;
        this.statsitePrefix = statsitePrefix;
        this.disableHostname = disableHostname;
        this.dogStatsdAddr = dogStatsdAddr;
        this.dogStatsdTags = dogStatsdTags;
    }

    @Override
    @JsonProperty(value="StatsiteAddr")
    public String getStatsiteAddr() {
        return this.statsiteAddr;
    }

    @Override
    @JsonProperty(value="StatsdAddr")
    public String getStatsdAddr() {
        return this.statsdAddr;
    }

    @Override
    @JsonProperty(value="StatsitePrefix")
    public String getStatsitePrefix() {
        return this.statsitePrefix;
    }

    @Override
    @JsonProperty(value="DisableHostname")
    public Boolean getDisableHostname() {
        return this.disableHostname;
    }

    @Override
    @JsonProperty(value="DogStatsdAddr")
    public String getDogStatsdAddr() {
        return this.dogStatsdAddr;
    }

    @Override
    @JsonProperty(value="DogStatsdTags")
    public Optional<List<String>> getDogStatsdTags() {
        return Optional.ofNullable(this.dogStatsdTags);
    }

    public final ImmutableTelemetry withStatsiteAddr(String value) {
        String newValue = Objects.requireNonNull(value, "statsiteAddr");
        if (this.statsiteAddr.equals(newValue)) {
            return this;
        }
        return new ImmutableTelemetry(newValue, this.statsdAddr, this.statsitePrefix, this.disableHostname, this.dogStatsdAddr, this.dogStatsdTags);
    }

    public final ImmutableTelemetry withStatsdAddr(String value) {
        String newValue = Objects.requireNonNull(value, "statsdAddr");
        if (this.statsdAddr.equals(newValue)) {
            return this;
        }
        return new ImmutableTelemetry(this.statsiteAddr, newValue, this.statsitePrefix, this.disableHostname, this.dogStatsdAddr, this.dogStatsdTags);
    }

    public final ImmutableTelemetry withStatsitePrefix(String value) {
        String newValue = Objects.requireNonNull(value, "statsitePrefix");
        if (this.statsitePrefix.equals(newValue)) {
            return this;
        }
        return new ImmutableTelemetry(this.statsiteAddr, this.statsdAddr, newValue, this.disableHostname, this.dogStatsdAddr, this.dogStatsdTags);
    }

    public final ImmutableTelemetry withDisableHostname(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "disableHostname");
        if (this.disableHostname.equals(newValue)) {
            return this;
        }
        return new ImmutableTelemetry(this.statsiteAddr, this.statsdAddr, this.statsitePrefix, newValue, this.dogStatsdAddr, this.dogStatsdTags);
    }

    public final ImmutableTelemetry withDogStatsdAddr(String value) {
        String newValue = Objects.requireNonNull(value, "dogStatsdAddr");
        if (this.dogStatsdAddr.equals(newValue)) {
            return this;
        }
        return new ImmutableTelemetry(this.statsiteAddr, this.statsdAddr, this.statsitePrefix, this.disableHostname, newValue, this.dogStatsdTags);
    }

    public final ImmutableTelemetry withDogStatsdTags(List<String> value) {
        List<String> newValue = Objects.requireNonNull(value, "dogStatsdTags");
        if (this.dogStatsdTags == newValue) {
            return this;
        }
        return new ImmutableTelemetry(this.statsiteAddr, this.statsdAddr, this.statsitePrefix, this.disableHostname, this.dogStatsdAddr, newValue);
    }

    public final ImmutableTelemetry withDogStatsdTags(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.dogStatsdTags == value) {
            return this;
        }
        return new ImmutableTelemetry(this.statsiteAddr, this.statsdAddr, this.statsitePrefix, this.disableHostname, this.dogStatsdAddr, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTelemetry && this.equalTo((ImmutableTelemetry)another);
    }

    private boolean equalTo(ImmutableTelemetry another) {
        return this.statsiteAddr.equals(another.statsiteAddr) && this.statsdAddr.equals(another.statsdAddr) && this.statsitePrefix.equals(another.statsitePrefix) && this.disableHostname.equals(another.disableHostname) && this.dogStatsdAddr.equals(another.dogStatsdAddr) && Objects.equals(this.dogStatsdTags, another.dogStatsdTags);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.statsiteAddr.hashCode();
        h2 += (h2 << 5) + this.statsdAddr.hashCode();
        h2 += (h2 << 5) + this.statsitePrefix.hashCode();
        h2 += (h2 << 5) + this.disableHostname.hashCode();
        h2 += (h2 << 5) + this.dogStatsdAddr.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.dogStatsdTags);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Telemetry").omitNullValues().add("statsiteAddr", this.statsiteAddr).add("statsdAddr", this.statsdAddr).add("statsitePrefix", this.statsitePrefix).add("disableHostname", this.disableHostname).add("dogStatsdAddr", this.dogStatsdAddr).add("dogStatsdTags", this.dogStatsdTags).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTelemetry fromJson(Json json) {
        Builder builder = ImmutableTelemetry.builder();
        if (json.statsiteAddr != null) {
            builder.statsiteAddr(json.statsiteAddr);
        }
        if (json.statsdAddr != null) {
            builder.statsdAddr(json.statsdAddr);
        }
        if (json.statsitePrefix != null) {
            builder.statsitePrefix(json.statsitePrefix);
        }
        if (json.disableHostname != null) {
            builder.disableHostname(json.disableHostname);
        }
        if (json.dogStatsdAddr != null) {
            builder.dogStatsdAddr(json.dogStatsdAddr);
        }
        if (json.dogStatsdTags != null) {
            builder.dogStatsdTags(json.dogStatsdTags);
        }
        return builder.build();
    }

    public static ImmutableTelemetry copyOf(Telemetry instance) {
        if (instance instanceof ImmutableTelemetry) {
            return (ImmutableTelemetry)instance;
        }
        return ImmutableTelemetry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Telemetry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STATSITE_ADDR = 1L;
        private static final long INIT_BIT_STATSD_ADDR = 2L;
        private static final long INIT_BIT_STATSITE_PREFIX = 4L;
        private static final long INIT_BIT_DISABLE_HOSTNAME = 8L;
        private static final long INIT_BIT_DOG_STATSD_ADDR = 16L;
        private long initBits = 31L;
        @Nullable
        private String statsiteAddr;
        @Nullable
        private String statsdAddr;
        @Nullable
        private String statsitePrefix;
        @Nullable
        private Boolean disableHostname;
        @Nullable
        private String dogStatsdAddr;
        @Nullable
        private List<String> dogStatsdTags;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Telemetry instance) {
            Objects.requireNonNull(instance, "instance");
            this.statsiteAddr(instance.getStatsiteAddr());
            this.statsdAddr(instance.getStatsdAddr());
            this.statsitePrefix(instance.getStatsitePrefix());
            this.disableHostname(instance.getDisableHostname());
            this.dogStatsdAddr(instance.getDogStatsdAddr());
            Optional<List<String>> dogStatsdTagsOptional = instance.getDogStatsdTags();
            if (dogStatsdTagsOptional.isPresent()) {
                this.dogStatsdTags(dogStatsdTagsOptional);
            }
            return this;
        }

        @JsonProperty(value="StatsiteAddr")
        @CanIgnoreReturnValue
        public final Builder statsiteAddr(String statsiteAddr) {
            this.statsiteAddr = Objects.requireNonNull(statsiteAddr, "statsiteAddr");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="StatsdAddr")
        @CanIgnoreReturnValue
        public final Builder statsdAddr(String statsdAddr) {
            this.statsdAddr = Objects.requireNonNull(statsdAddr, "statsdAddr");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="StatsitePrefix")
        @CanIgnoreReturnValue
        public final Builder statsitePrefix(String statsitePrefix) {
            this.statsitePrefix = Objects.requireNonNull(statsitePrefix, "statsitePrefix");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="DisableHostname")
        @CanIgnoreReturnValue
        public final Builder disableHostname(Boolean disableHostname) {
            this.disableHostname = Objects.requireNonNull(disableHostname, "disableHostname");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="DogStatsdAddr")
        @CanIgnoreReturnValue
        public final Builder dogStatsdAddr(String dogStatsdAddr) {
            this.dogStatsdAddr = Objects.requireNonNull(dogStatsdAddr, "dogStatsdAddr");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dogStatsdTags(List<String> dogStatsdTags) {
            this.dogStatsdTags = Objects.requireNonNull(dogStatsdTags, "dogStatsdTags");
            return this;
        }

        @JsonProperty(value="DogStatsdTags")
        @CanIgnoreReturnValue
        public final Builder dogStatsdTags(Optional<? extends List<String>> dogStatsdTags) {
            this.dogStatsdTags = dogStatsdTags.orElse(null);
            return this;
        }

        public ImmutableTelemetry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTelemetry(this.statsiteAddr, this.statsdAddr, this.statsitePrefix, this.disableHostname, this.dogStatsdAddr, this.dogStatsdTags);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("statsiteAddr");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("statsdAddr");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("statsitePrefix");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("disableHostname");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("dogStatsdAddr");
            }
            return "Cannot build Telemetry, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Telemetry", generator="Immutables")
    static final class Json
    extends Telemetry {
        @Nullable
        String statsiteAddr;
        @Nullable
        String statsdAddr;
        @Nullable
        String statsitePrefix;
        @Nullable
        Boolean disableHostname;
        @Nullable
        String dogStatsdAddr;
        @Nullable
        Optional<List<String>> dogStatsdTags = Optional.empty();

        Json() {
        }

        @JsonProperty(value="StatsiteAddr")
        public void setStatsiteAddr(String statsiteAddr) {
            this.statsiteAddr = statsiteAddr;
        }

        @JsonProperty(value="StatsdAddr")
        public void setStatsdAddr(String statsdAddr) {
            this.statsdAddr = statsdAddr;
        }

        @JsonProperty(value="StatsitePrefix")
        public void setStatsitePrefix(String statsitePrefix) {
            this.statsitePrefix = statsitePrefix;
        }

        @JsonProperty(value="DisableHostname")
        public void setDisableHostname(Boolean disableHostname) {
            this.disableHostname = disableHostname;
        }

        @JsonProperty(value="DogStatsdAddr")
        public void setDogStatsdAddr(String dogStatsdAddr) {
            this.dogStatsdAddr = dogStatsdAddr;
        }

        @JsonProperty(value="DogStatsdTags")
        public void setDogStatsdTags(Optional<List<String>> dogStatsdTags) {
            this.dogStatsdTags = dogStatsdTags;
        }

        @Override
        public String getStatsiteAddr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStatsdAddr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStatsitePrefix() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getDisableHostname() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDogStatsdAddr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> getDogStatsdTags() {
            throw new UnsupportedOperationException();
        }
    }
}

