/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul.model.agent;

import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.logicalclocks.shaded.com.google.common.base.Preconditions;
import com.logicalclocks.shaded.com.google.common.collect.ImmutableList;
import com.logicalclocks.shaded.com.orbitz.consul.model.agent.ImmutableCheck;
import com.logicalclocks.shaded.org.immutables.value.Value;
import java.util.List;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(as=ImmutableCheck.class)
@JsonDeserialize(as=ImmutableCheck.class)
@Value.Immutable
public abstract class Check {
    @JsonProperty(value="ID")
    public abstract String getId();

    @JsonProperty(value="Name")
    public abstract String getName();

    @JsonProperty(value="Notes")
    public abstract Optional<String> getNotes();

    @JsonProperty(value="Output")
    public abstract Optional<String> getOutput();

    @JsonProperty(value="Args")
    public abstract Optional<List<String>> getArgs();

    @JsonProperty(value="Interval")
    public abstract Optional<String> getInterval();

    @JsonProperty(value="TTL")
    public abstract Optional<String> getTtl();

    @JsonProperty(value="HTTP")
    public abstract Optional<String> getHttp();

    @JsonProperty(value="TCP")
    public abstract Optional<String> getTcp();

    @JsonProperty(value="GRPC")
    public abstract Optional<String> getGrpc();

    @JsonProperty(value="GRPCUseTLS")
    public abstract Optional<Boolean> getGrpcUseTls();

    @JsonProperty(value="ServiceID")
    public abstract Optional<String> getServiceId();

    @JsonProperty(value="ServiceTags")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public abstract List<String> getServiceTags();

    @JsonProperty(value="DeregisterCriticalServiceAfter")
    public abstract Optional<String> getDeregisterCriticalServiceAfter();

    @Value.Check
    protected void validate() {
        Preconditions.checkState(this.getHttp().isPresent() || this.getTtl().isPresent() || this.getArgs().isPresent() || this.getTcp().isPresent() || this.getGrpc().isPresent(), "Check must specify either http, tcp, ttl, grpc or args");
        if (this.getHttp().isPresent() || this.getArgs().isPresent() || this.getTcp().isPresent() || this.getGrpc().isPresent()) {
            Preconditions.checkState(this.getInterval().isPresent(), "Interval must be set if check type is http, tcp, grpc or args");
        }
    }
}

