/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul.cache;

import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.shaded.com.orbitz.consul.cache.ImmutableServiceHealthKey;
import com.logicalclocks.shaded.com.orbitz.consul.model.health.ServiceHealth;
import com.logicalclocks.shaded.org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
public abstract class ServiceHealthKey {
    public abstract String getServiceId();

    public abstract String getHost();

    public abstract Integer getPort();

    public static ServiceHealthKey fromServiceHealth(ServiceHealth serviceHealth) {
        return ServiceHealthKey.of(serviceHealth.getService().getId(), serviceHealth.getNode().getAddress(), serviceHealth.getService().getPort());
    }

    public static ServiceHealthKey of(String serviceId, String host, int port) {
        return ImmutableServiceHealthKey.builder().serviceId(serviceId).host(host).port(port).build();
    }
}

