/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul.cache;

import com.logicalclocks.shaded.com.google.common.annotations.VisibleForTesting;
import com.logicalclocks.shaded.com.google.common.base.Preconditions;
import com.logicalclocks.shaded.com.google.common.primitives.Ints;
import com.logicalclocks.shaded.com.orbitz.consul.KeyValueClient;
import com.logicalclocks.shaded.com.orbitz.consul.async.ConsulResponseCallback;
import com.logicalclocks.shaded.com.orbitz.consul.cache.CacheDescriptor;
import com.logicalclocks.shaded.com.orbitz.consul.cache.ConsulCache;
import com.logicalclocks.shaded.com.orbitz.consul.config.CacheConfig;
import com.logicalclocks.shaded.com.orbitz.consul.model.kv.Value;
import com.logicalclocks.shaded.com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public class KVCache
extends ConsulCache<String, Value> {
    private KVCache(KeyValueClient kvClient, String rootPath, String keyPath, int watchSeconds, QueryOptions queryOptions, ConsulCache.Scheduler callbackScheduler) {
        super(KVCache.getKeyExtractorFunction(keyPath), (BigInteger index, ConsulResponseCallback<List<V>> callback) -> {
            QueryOptions params = KVCache.watchParams(index, watchSeconds, queryOptions);
            kvClient.getValues(keyPath, params, callback);
        }, kvClient.getConfig().getCacheConfig(), kvClient.getEventHandler(), new CacheDescriptor("keyvalue", rootPath), callbackScheduler);
    }

    @VisibleForTesting
    static Function<Value, String> getKeyExtractorFunction(String rootPath) {
        return input -> {
            Preconditions.checkNotNull(input, "Input to key extractor is null");
            Preconditions.checkNotNull(input.getKey(), "Input to key extractor has no key");
            if (rootPath.equals(input.getKey())) {
                return "";
            }
            int lastSlashIndex = rootPath.lastIndexOf("/");
            if (lastSlashIndex >= 0) {
                return input.getKey().substring(lastSlashIndex + 1);
            }
            return input.getKey();
        };
    }

    public static KVCache newCache(KeyValueClient kvClient, String rootPath, int watchSeconds, QueryOptions queryOptions, ScheduledExecutorService callbackExecutorService) {
        ConsulCache.Scheduler scheduler = KVCache.createExternal(callbackExecutorService);
        return new KVCache(kvClient, rootPath, KVCache.prepareRootPath(rootPath), watchSeconds, queryOptions, scheduler);
    }

    public static KVCache newCache(KeyValueClient kvClient, String rootPath, int watchSeconds, QueryOptions queryOptions) {
        return new KVCache(kvClient, rootPath, KVCache.prepareRootPath(rootPath), watchSeconds, queryOptions, KVCache.createDefault());
    }

    @VisibleForTesting
    static String prepareRootPath(String rootPath) {
        return rootPath.startsWith("/") ? rootPath.substring(1) : rootPath;
    }

    public static KVCache newCache(KeyValueClient kvClient, String rootPath, int watchSeconds) {
        return KVCache.newCache(kvClient, rootPath, watchSeconds, QueryOptions.BLANK);
    }

    public static KVCache newCache(KeyValueClient kvClient, String rootPath) {
        CacheConfig cacheConfig = kvClient.getConfig().getCacheConfig();
        int watchSeconds = Ints.checkedCast(cacheConfig.getWatchDuration().getSeconds());
        return KVCache.newCache(kvClient, rootPath, watchSeconds);
    }
}

