/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul;

import com.logicalclocks.shaded.com.google.common.collect.ImmutableMap;
import com.logicalclocks.shaded.com.orbitz.consul.BaseClient;
import com.logicalclocks.shaded.com.orbitz.consul.config.ClientConfig;
import com.logicalclocks.shaded.com.orbitz.consul.model.operator.RaftConfiguration;
import com.logicalclocks.shaded.com.orbitz.consul.monitoring.ClientEventCallback;
import com.logicalclocks.shaded.retrofit2.Call;
import com.logicalclocks.shaded.retrofit2.Retrofit;
import com.logicalclocks.shaded.retrofit2.http.DELETE;
import com.logicalclocks.shaded.retrofit2.http.GET;
import com.logicalclocks.shaded.retrofit2.http.Query;
import com.logicalclocks.shaded.retrofit2.http.QueryMap;
import java.util.Map;

public class OperatorClient
extends BaseClient {
    private static String CLIENT_NAME = "operator";
    private final Api api;

    OperatorClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = retrofit.create(Api.class);
    }

    public RaftConfiguration getRaftConfiguration() {
        return this.http.extract(this.api.getConfiguration(ImmutableMap.of()), new Integer[0]);
    }

    public RaftConfiguration getRaftConfiguration(String datacenter) {
        return this.http.extract(this.api.getConfiguration(ImmutableMap.of("dc", datacenter)), new Integer[0]);
    }

    public RaftConfiguration getStaleRaftConfiguration(String datacenter) {
        return this.http.extract(this.api.getConfiguration(ImmutableMap.of("dc", datacenter, "stale", "true")), new Integer[0]);
    }

    public RaftConfiguration getStaleRaftConfiguration() {
        return this.http.extract(this.api.getConfiguration(ImmutableMap.of("stale", "true")), new Integer[0]);
    }

    public void deletePeer(String address) {
        this.http.handle(this.api.deletePeer(address, ImmutableMap.of()), new Integer[0]);
    }

    public void deletePeer(String address, String datacenter) {
        this.http.handle(this.api.deletePeer(address, ImmutableMap.of("dc", datacenter)), new Integer[0]);
    }

    static interface Api {
        @GET(value="operator/raft/configuration")
        public Call<RaftConfiguration> getConfiguration(@QueryMap Map<String, String> var1);

        @DELETE(value="operator/raft/peer")
        public Call<Void> deletePeer(@Query(value="address") String var1, @QueryMap Map<String, String> var2);
    }
}

