/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.fasterxml.jackson.datatype.guava.deser;

import com.logicalclocks.shaded.com.fasterxml.jackson.core.JsonParser;
import com.logicalclocks.shaded.com.fasterxml.jackson.core.JsonToken;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.BeanProperty;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.JavaType;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import com.logicalclocks.shaded.com.fasterxml.jackson.datatype.guava.deser.util.RangeFactory;
import com.logicalclocks.shaded.com.google.common.base.Preconditions;
import com.logicalclocks.shaded.com.google.common.collect.BoundType;
import com.logicalclocks.shaded.com.google.common.collect.Range;
import java.io.IOException;
import java.util.Arrays;

public class RangeDeserializer
extends StdDeserializer<Range<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _rangeType;
    protected final JsonDeserializer<Object> _endpointDeserializer;
    private BoundType _defaultBoundType;

    @Deprecated
    public RangeDeserializer(JavaType rangeType) {
        this(null, rangeType);
    }

    public RangeDeserializer(BoundType defaultBoundType, JavaType rangeType) {
        this(rangeType, null);
        this._defaultBoundType = defaultBoundType;
    }

    public RangeDeserializer(JavaType rangeType, JsonDeserializer<?> endpointDeser) {
        super(rangeType);
        this._rangeType = rangeType;
        this._endpointDeserializer = endpointDeser;
    }

    public RangeDeserializer(JavaType rangeType, JsonDeserializer<?> endpointDeser, BoundType defaultBoundType) {
        super(rangeType);
        this._rangeType = rangeType;
        this._endpointDeserializer = endpointDeser;
        this._defaultBoundType = defaultBoundType;
    }

    @Override
    public JavaType getValueType() {
        return this._rangeType;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        if (this._endpointDeserializer == null) {
            JavaType endpointType = this._rangeType.containedType(0);
            if (endpointType == null) {
                endpointType = TypeFactory.unknownType();
            }
            JsonDeserializer<Object> deser = ctxt.findContextualValueDeserializer(endpointType, property);
            return new RangeDeserializer(this._rangeType, deser, this._defaultBoundType);
        }
        return this;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    @Override
    public Range<?> deserialize(JsonParser p, DeserializationContext context) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        }
        Comparable<?> lowerEndpoint = null;
        Comparable<?> upperEndpoint = null;
        BoundType lowerBoundType = this._defaultBoundType;
        BoundType upperBoundType = this._defaultBoundType;
        while (t != JsonToken.END_OBJECT) {
            this.expect(context, JsonToken.FIELD_NAME, t);
            String fieldName = p.getCurrentName();
            try {
                if (fieldName.equals("lowerEndpoint")) {
                    p.nextToken();
                    lowerEndpoint = this.deserializeEndpoint(context, p);
                } else if (fieldName.equals("upperEndpoint")) {
                    p.nextToken();
                    upperEndpoint = this.deserializeEndpoint(context, p);
                } else if (fieldName.equals("lowerBoundType")) {
                    p.nextToken();
                    lowerBoundType = this.deserializeBoundType(context, p);
                } else if (fieldName.equals("upperBoundType")) {
                    p.nextToken();
                    upperBoundType = this.deserializeBoundType(context, p);
                } else {
                    context.handleUnknownProperty(p, this, Range.class, fieldName);
                }
            }
            catch (IllegalStateException e) {
                throw JsonMappingException.from(p, e.getMessage());
            }
            t = p.nextToken();
        }
        try {
            if (lowerEndpoint != null && upperEndpoint != null) {
                Preconditions.checkState(lowerEndpoint.getClass() == upperEndpoint.getClass(), "Endpoint types are not the same - 'lowerEndpoint' deserialized to [%s], and 'upperEndpoint' deserialized to [%s].", new Object[]{lowerEndpoint.getClass().getName(), upperEndpoint.getClass().getName()});
                Preconditions.checkState(lowerBoundType != null, "'lowerEndpoint' field found, but not 'lowerBoundType'");
                Preconditions.checkState(upperBoundType != null, "'upperEndpoint' field found, but not 'upperBoundType'");
                return RangeFactory.range(lowerEndpoint, lowerBoundType, upperEndpoint, upperBoundType);
            }
            if (lowerEndpoint != null) {
                Preconditions.checkState(lowerBoundType != null, "'lowerEndpoint' field found, but not 'lowerBoundType'");
                return RangeFactory.downTo(lowerEndpoint, lowerBoundType);
            }
            if (upperEndpoint != null) {
                Preconditions.checkState(upperBoundType != null, "'upperEndpoint' field found, but not 'upperBoundType'");
                return RangeFactory.upTo(upperEndpoint, upperBoundType);
            }
            return RangeFactory.all();
        }
        catch (IllegalStateException e) {
            throw JsonMappingException.from(p, e.getMessage());
        }
    }

    private BoundType deserializeBoundType(DeserializationContext context, JsonParser p) throws IOException {
        this.expect(context, JsonToken.VALUE_STRING, p.getCurrentToken());
        String name = p.getText();
        try {
            return BoundType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return (BoundType)((Object)context.handleWeirdStringValue(BoundType.class, name, "not a valid BoundType name (should be one oF: %s)", Arrays.asList(BoundType.values())));
        }
    }

    private Comparable<?> deserializeEndpoint(DeserializationContext context, JsonParser p) throws IOException {
        Object obj = this._endpointDeserializer.deserialize(p, context);
        if (!(obj instanceof Comparable)) {
            context.reportBadDefinition(this._rangeType, String.format("Field [%s] deserialized to [%s], which does not implement Comparable.", p.getCurrentName(), obj.getClass().getName()));
        }
        return (Comparable)obj;
    }

    private void expect(DeserializationContext context, JsonToken expected, JsonToken actual) throws JsonMappingException {
        if (actual != expected) {
            context.reportInputMismatch(this, String.format("Problem deserializing %s: expecting %s, found %s", new Object[]{this.handledType().getName(), expected, actual}), new Object[0]);
        }
    }
}

