/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.metadata.common.FinderType;
import io.hops.transaction.EntityManager;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.context.EntityContextStat;
import io.hops.transaction.handler.RequestHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionsStats {
    private static Log log = LogFactory.getLog(TransactionsStats.class);
    private static TransactionsStats instance = null;
    private boolean enabled = false;
    private int WRITER_ROUND;
    private BufferedWriter statsLogWriter;
    private BufferedWriter csvFileWriter;
    private BufferedWriter memcacheCSVFileWriter;
    private List<TransactionStat> transactionStats = new LinkedList<TransactionStat>();
    private File statsDir;
    private Thread writerThread;
    private List<ResolvingCacheStat> resolvingCacheStats = new LinkedList<ResolvingCacheStat>();
    private boolean detailedStats;

    private TransactionsStats() {
    }

    public static TransactionsStats getInstance() {
        if (instance == null) {
            instance = new TransactionsStats();
        }
        return instance;
    }

    public void setConfiguration(boolean enableOrDisable, String statsDir, int writerRound, boolean detailed) throws IOException {
        if (enableOrDisable) {
            this.enabled = true;
            this.statsDir = new File(statsDir);
            this.WRITER_ROUND = writerRound;
            if (!this.statsDir.exists()) {
                this.statsDir.mkdirs();
            }
            BaseEntityContext.enableStats();
            this.writerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (TransactionsStats.this.enabled) {
                        try {
                            Thread.sleep((long)TransactionsStats.this.WRITER_ROUND * 1000L);
                        }
                        catch (InterruptedException e) {
                            log.warn((Object)e);
                            Thread.currentThread().interrupt();
                        }
                        try {
                            TransactionsStats.this.dump();
                        }
                        catch (IOException e) {
                            log.warn((Object)e);
                        }
                    }
                }
            });
            this.writerThread.start();
            this.detailedStats = detailed;
        } else {
            this.enabled = false;
            BaseEntityContext.disableStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionStat collectStats(RequestHandler.OperationType operationType, Exception ignoredException) throws IOException {
        Collection<EntityContextStat> contextStats;
        if (this.enabled && (!(contextStats = EntityManager.collectSnapshotStat()).isEmpty() || ignoredException != null)) {
            TransactionStat stat = new TransactionStat(operationType, contextStats, ignoredException);
            List<TransactionStat> list = this.transactionStats;
            synchronized (list) {
                this.transactionStats.add(stat);
            }
            return stat;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushResolvingCacheStats(ResolvingCacheStat stat) {
        if (this.enabled) {
            List<ResolvingCacheStat> list = this.resolvingCacheStats;
            synchronized (list) {
                this.resolvingCacheStats.add(stat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() throws IOException {
        if (this.enabled) {
            List<Object> list = this.transactionStats;
            synchronized (list) {
                if (!this.transactionStats.isEmpty()) {
                    this.dumpDetailed();
                    this.dumpCSVLike();
                    this.clear();
                }
            }
            list = this.resolvingCacheStats;
            synchronized (list) {
                if (!this.resolvingCacheStats.isEmpty()) {
                    this.dumpResolvingCacheStats();
                    this.memcacheCSVFileWriter.flush();
                    this.resolvingCacheStats.clear();
                }
            }
        }
    }

    public void close() throws IOException {
        if (this.enabled) {
            this.enabled = false;
            this.writerThread.interrupt();
            if (this.statsLogWriter != null) {
                this.statsLogWriter.close();
            }
            if (this.csvFileWriter != null) {
                this.csvFileWriter.close();
            }
            if (this.memcacheCSVFileWriter != null) {
                this.memcacheCSVFileWriter.close();
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void clear() throws IOException {
        if (this.statsLogWriter != null) {
            this.statsLogWriter.flush();
        }
        if (this.csvFileWriter != null) {
            this.csvFileWriter.flush();
        }
        this.transactionStats.clear();
    }

    private void dumpResolvingCacheStats() throws IOException {
        boolean fileExists = this.getResolvingCacheCSVFile().exists();
        BufferedWriter writer = this.getResolvingCSVFileWriter();
        if (!fileExists) {
            writer.write(ResolvingCacheStat.getHeader());
            writer.newLine();
        }
        for (ResolvingCacheStat stat : this.resolvingCacheStats) {
            writer.write(stat.toString());
            writer.newLine();
        }
    }

    private void dumpCSVLike() throws IOException {
        boolean fileExists = this.getCSVFile().exists();
        BufferedWriter writer = this.getCSVFileWriter();
        if (!fileExists) {
            writer.write(TransactionStat.getHeader());
            writer.newLine();
        }
        for (TransactionStat stat : this.transactionStats) {
            writer.write(stat.toString());
            writer.newLine();
        }
    }

    private void dumpDetailed() throws IOException {
        if (this.detailedStats) {
            BufferedWriter writer = this.getStatsLogWriter();
            for (TransactionStat stat : this.transactionStats) {
                writer.write("Transaction: " + stat.name.toString());
                writer.newLine();
                this.dump(writer, stat);
                writer.newLine();
                writer.newLine();
            }
        }
    }

    private EntityContextStat.StatsAggregator dump(BufferedWriter writer, TransactionStat transactionStat) throws IOException {
        if (transactionStat.ignoredException != null) {
            writer.write(transactionStat.ignoredException.toString());
            writer.newLine();
            writer.newLine();
        }
        EntityContextStat.StatsAggregator txAggStat = new EntityContextStat.StatsAggregator();
        for (EntityContextStat contextStat : transactionStat.stats) {
            writer.write(contextStat.toString());
            txAggStat.update(contextStat.getStatsAggregator());
        }
        writer.write(txAggStat.toCSFString("Tx."));
        writer.newLine();
        return txAggStat;
    }

    private BufferedWriter getCSVFileWriter() throws IOException {
        if (this.csvFileWriter == null) {
            this.csvFileWriter = new BufferedWriter(new FileWriter(this.getCSVFile(), true));
        }
        return this.csvFileWriter;
    }

    private BufferedWriter getStatsLogWriter() throws IOException {
        if (this.statsLogWriter == null) {
            this.statsLogWriter = new BufferedWriter(new FileWriter(this.getStatsFile(), true));
        }
        return this.statsLogWriter;
    }

    private BufferedWriter getResolvingCSVFileWriter() throws IOException {
        if (this.memcacheCSVFileWriter == null) {
            this.memcacheCSVFileWriter = new BufferedWriter(new FileWriter(this.getResolvingCacheCSVFile(), true));
        }
        return this.memcacheCSVFileWriter;
    }

    private File getStatsFile() {
        return new File(this.statsDir, "hops-stats.log");
    }

    private File getCSVFile() {
        return new File(this.statsDir, "hops-stats.csv");
    }

    private File getResolvingCacheCSVFile() {
        return new File(this.statsDir, "hops-resolving-cache-stats.csv");
    }

    public static class ResolvingCacheStat {
        private Op operation;
        private long elapsed;
        private int roundTrips;

        public ResolvingCacheStat(Op operation, long elapsed, int roundTrips) {
            this.operation = operation;
            this.elapsed = elapsed;
            this.roundTrips = roundTrips;
        }

        static String getHeader() {
            return "Operation, Elapsed, RoundTrips";
        }

        public String toString() {
            return this.operation.toString() + "," + this.elapsed + "," + this.roundTrips;
        }

        public static enum Op {
            GET,
            SET;

        }
    }

    public static class TransactionStat {
        private RequestHandler.OperationType name;
        private Collection<EntityContextStat> stats;
        private Exception ignoredException;
        private long acquireTime;
        private long processingTime;
        private long commitTime;

        TransactionStat(RequestHandler.OperationType name, Collection<EntityContextStat> stats, Exception ignoredException) {
            this.name = name;
            this.stats = stats;
            this.ignoredException = ignoredException;
        }

        public void setTimes(long acquire, long processing, long commit) {
            this.acquireTime = acquire;
            this.processingTime = processing;
            this.commitTime = commit;
        }

        static String getHeader() {
            String header = "Tx,";
            for (FinderType.Annotation annotation : FinderType.Annotation.values()) {
                String ann = annotation.toString();
                header = header + ann + "_hits," + ann + "_hitsRows," + ann + "_misses," + ann + "_missesRows,";
            }
            header = header + "Hits,HitsRows,Misses,MissesRows,New,Modified,Deleted,Acquire,Processing,Commit,TotalTime";
            return header;
        }

        public String toString() {
            String tx = this.name.toString() + ",";
            EntityContextStat.StatsAggregator txStatsAggregator = new EntityContextStat.StatsAggregator();
            for (EntityContextStat contextStat : this.stats) {
                txStatsAggregator.update(contextStat.getStatsAggregator());
            }
            for (FinderType.Annotation annotation : FinderType.Annotation.values()) {
                EntityContextStat.HitMissCounter hitMissCounter = txStatsAggregator.getCounter(annotation);
                tx = tx + hitMissCounter.hits + "," + hitMissCounter.hitsRowsCount + "," + hitMissCounter.misses + "," + hitMissCounter.missesRowsCount + ",";
            }
            tx = tx + txStatsAggregator.hitMissCounter.hits + "," + txStatsAggregator.hitMissCounter.hitsRowsCount + "," + txStatsAggregator.hitMissCounter.misses + "," + txStatsAggregator.hitMissCounter.missesRowsCount + ",";
            tx = tx + txStatsAggregator.newRows + "," + txStatsAggregator.modifiedRows + "," + txStatsAggregator.deletedRows + ",";
            tx = tx + this.acquireTime + "," + this.processingTime + "," + this.commitTime + "," + (this.acquireTime + this.processingTime + this.commitTime);
            return tx;
        }
    }
}

