/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.metadata.common.FinderType;
import java.util.Map;

public class QuotaUpdate {
    private int id;
    private long inodeId;
    private long namespaceDelta;
    private long storageSpaceDelta;
    private Map<StorageType, Long> typeSpaces;

    public QuotaUpdate(int id, long inodeId, long namespaceDelta, long diskspaceDelta, Map<StorageType, Long> typeSpaces) {
        this.id = id;
        this.inodeId = inodeId;
        this.namespaceDelta = namespaceDelta;
        this.storageSpaceDelta = diskspaceDelta;
        this.typeSpaces = typeSpaces;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getInodeId() {
        return this.inodeId;
    }

    public void setInodeId(long inodeId) {
        this.inodeId = inodeId;
    }

    public long getNamespaceDelta() {
        return this.namespaceDelta;
    }

    public void setNamespaceDelta(int namespaceDelta) {
        this.namespaceDelta = namespaceDelta;
    }

    public long getStorageSpaceDelta() {
        return this.storageSpaceDelta;
    }

    public void setStorageSpaceDelta(long diskspaceDelta) {
        this.storageSpaceDelta = diskspaceDelta;
    }

    public Map<StorageType, Long> getTypeSpaces() {
        return this.typeSpaces;
    }

    public void setTypeSpaces(Map<StorageType, Long> typeSpaces) {
        this.typeSpaces = typeSpaces;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (StorageType type : this.typeSpaces.keySet()) {
            sb.append(", ").append((Object)type).append(" = ").append(this.typeSpaces.get((Object)type));
        }
        return "QuotaUpdate{id = " + this.id + ", inodeId = " + this.inodeId + ", namespaceDelta = " + this.namespaceDelta + ", diskspaceDelta = " + this.storageSpaceDelta + " " + sb + '}';
    }

    public static enum Finder implements FinderType<QuotaUpdate>
    {
        ByINodeId,
        ByKey;


        @Override
        public Class getType() {
            return QuotaUpdate.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            return FinderType.Annotation.PrunedIndexScan;
        }
    }

    public static enum StorageType {
        DISK,
        SSD,
        RAID5,
        ARCHIVE,
        DB,
        PROVIDED,
        CLOUD;

    }
}

