/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.common.entity;

import io.hops.metadata.common.entity.Variable;
import java.nio.ByteBuffer;
import java.util.Objects;

public class LongVariable
extends Variable {
    private Long value = new Long(0L);

    public LongVariable(Variable.Finder type, long value) {
        this(type);
        this.value = value;
    }

    public LongVariable(Variable.Finder type) {
        super(type);
    }

    public LongVariable(long value) {
        this(Variable.Finder.GenericLong, value);
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public void setValue(byte[] val) {
        if (val == null) {
            return;
        }
        if (val.length != this.getLength()) {
            if (val.length == 4) {
                ByteBuffer buf = ByteBuffer.wrap(val);
                this.value = new Long(buf.getInt());
            }
            return;
        }
        ByteBuffer buf = ByteBuffer.wrap(val);
        this.value = buf.getLong();
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buf = ByteBuffer.allocate(this.getLength());
        buf.putLong(this.value);
        return buf.array();
    }

    @Override
    public int getLength() {
        return 8;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongVariable that = (LongVariable)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

