/*
 * Decompiled with CFR 0.152.
 */
package io.hops.leaderElection;

import io.hops.leaderElection.LeaderElectionRole;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.metadata.election.entity.LeDescriptor;
import io.hops.metadata.election.entity.LeDescriptorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LEContext {
    protected LeaderElectionRole.Role role;
    protected long last_hb_time;
    protected long leader;
    protected long time_period;
    protected List<HashMap<Long, LeDescriptor>> history;
    protected long id;
    protected boolean init_phase;
    protected int max_missed_hb_threshold;
    protected String rpc_addresses;
    protected String http_address;
    protected SortedActiveNodeList memberShip;
    protected long time_period_increment;
    protected boolean nextTimeTakeStrongerLocks;
    protected List<LeDescriptor> removedNodes;
    protected byte locationDomainId;

    private LEContext() {
    }

    public LEContext(LEContext context, LeDescriptorFactory leFactory) {
        this.role = context.role;
        this.last_hb_time = context.last_hb_time;
        this.leader = context.leader;
        this.time_period = context.time_period;
        this.id = context.id;
        this.init_phase = context.init_phase;
        this.max_missed_hb_threshold = context.max_missed_hb_threshold;
        this.rpc_addresses = context.rpc_addresses;
        this.http_address = context.http_address;
        this.time_period_increment = context.time_period_increment;
        this.nextTimeTakeStrongerLocks = context.nextTimeTakeStrongerLocks;
        this.locationDomainId = context.locationDomainId;
        this.history = new ArrayList<HashMap<Long, LeDescriptor>>();
        if (!context.history.isEmpty()) {
            for (HashMap<Long, LeDescriptor> map : context.history) {
                HashMap<Long, LeDescriptor> newMap = new HashMap<Long, LeDescriptor>();
                for (LeDescriptor process : map.values()) {
                    LeDescriptor processClone = leFactory.cloneDescriptor(process);
                    newMap.put(processClone.getId(), processClone);
                }
                this.history.add(newMap);
            }
        }
        this.memberShip = context.memberShip;
        this.removedNodes = context.removedNodes;
    }

    public static LEContext initialContext() {
        LEContext context = new LEContext();
        context.role = LeaderElectionRole.Role.NON_LEADER;
        context.last_hb_time = 0L;
        context.leader = -1L;
        context.time_period = 0L;
        context.history = new ArrayList<HashMap<Long, LeDescriptor>>();
        context.id = -1L;
        context.init_phase = false;
        context.max_missed_hb_threshold = 2;
        context.memberShip = null;
        context.http_address = null;
        context.rpc_addresses = null;
        context.time_period_increment = 0L;
        context.nextTimeTakeStrongerLocks = false;
        context.removedNodes = new ArrayList<LeDescriptor>();
        return context;
    }
}

