/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RemovedBlock
extends Block {
    static final Log LOG = LogFactory.getLog(RemovedBlock.class);
    boolean deleteCloudCopy = true;

    public RemovedBlock(long blkid, long len, long generationStamp, String cloudBucket, boolean deleteCloudCopy) {
        super(blkid, len, generationStamp, cloudBucket);
        this.deleteCloudCopy = deleteCloudCopy;
    }

    public boolean isDeleteCloudCopy() {
        return this.deleteCloudCopy;
    }

    public void setDeleteCloudCopy(boolean deleteCloudCopy) {
        this.deleteCloudCopy = deleteCloudCopy;
    }

    @Override
    public int compareTo(Block b) {
        if (b instanceof RemovedBlock) {
            int ret = Long.compare(this.getBlockId(), b.getBlockId());
            if (ret != 0) {
                return ret;
            }
            return Long.compare(this.getGenerationStamp(), b.getGenerationStamp());
        }
        return super.compareTo(b);
    }

    @Override
    public String toString() {
        return super.toString() + "_" + (this.deleteCloudCopy ? "DeleteFromCloud" : "DeleteFromCache") + "_" + (this.isProvidedBlock() ? "ProvidedBlock" : "NonProvidedBlock");
    }
}

