/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hdfs.protocol.Block;

public class CloudBlock
implements Comparable<CloudBlock> {
    private boolean metaObjectFound;
    private boolean blockObjectFound;
    private long lastModified;
    private Block block;

    public CloudBlock() {
        this.block = null;
        this.metaObjectFound = false;
        this.blockObjectFound = false;
        this.lastModified = -1L;
    }

    public CloudBlock(Block block, long lastModified) {
        Preconditions.checkNotNull((Object)block);
        this.metaObjectFound = true;
        this.blockObjectFound = true;
        this.block = block;
        this.lastModified = lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setMetaObjectFound(boolean metaObjectFound) {
        this.metaObjectFound = metaObjectFound;
    }

    public void setBlockObjectFound(boolean blockObjectFound) {
        this.blockObjectFound = blockObjectFound;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean isPartiallyListed() {
        return !this.metaObjectFound || !this.blockObjectFound;
    }

    public String toString() {
        return this.block.toString() + " meta file exists: " + this.metaObjectFound + " block file exists: " + this.blockObjectFound;
    }

    @Override
    public int compareTo(CloudBlock o) {
        return Long.compare(this.block.getBlockId(), o.getBlock().getBlockId());
    }
}

