/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Private
public class DelegationTokenFetcher {
    private static final String WEBSERVICE = "webservice";
    private static final String CANCEL = "cancel";
    private static final String HELP = "help";
    private static final String HELP_SHORT = "h";
    private static final Log LOG = LogFactory.getLog(DelegationTokenFetcher.class);
    private static final String PRINT = "print";
    private static final String RENEW = "renew";
    private static final String RENEWER = "renewer";

    public static void main(String[] args) throws Exception {
        int commandCount;
        final HdfsConfiguration conf = new HdfsConfiguration();
        Options fetcherOptions = new Options();
        fetcherOptions.addOption(WEBSERVICE, true, "HTTP url to reach the NameNode at").addOption(RENEWER, true, "Name of the delegation token renewer").addOption(CANCEL, false, "cancel the token").addOption(RENEW, false, "renew the token").addOption(PRINT, false, "print the token").addOption(HELP_SHORT, HELP, false, "print out help information");
        GenericOptionsParser parser = new GenericOptionsParser((Configuration)conf, fetcherOptions, args);
        CommandLine cmd = parser.getCommandLine();
        final String webUrl = cmd.hasOption(WEBSERVICE) ? cmd.getOptionValue(WEBSERVICE) : null;
        final String renewer = cmd.hasOption(RENEWER) ? cmd.getOptionValue(RENEWER) : null;
        final boolean cancel = cmd.hasOption(CANCEL);
        final boolean renew = cmd.hasOption(RENEW);
        final boolean print = cmd.hasOption(PRINT);
        boolean help = cmd.hasOption(HELP);
        String[] remaining = parser.getRemainingArgs();
        if (help) {
            DelegationTokenFetcher.printUsage(System.out);
            System.exit(0);
        }
        if ((commandCount = (cancel ? 1 : 0) + (renew ? 1 : 0) + (print ? 1 : 0)) > 1) {
            System.err.println("ERROR: Only specify cancel, renew or print.");
            DelegationTokenFetcher.printUsage(System.err);
        }
        if (remaining.length != 1 || remaining[0].charAt(0) == '-') {
            System.err.println("ERROR: Must specify exacltly one token file");
            DelegationTokenFetcher.printUsage(System.err);
        }
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        final Path tokenFile = new Path(local.getWorkingDirectory(), remaining[0]);
        UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (print) {
                    DelegationTokenFetcher.printTokens(conf, tokenFile);
                } else if (cancel) {
                    DelegationTokenFetcher.cancelTokens(conf, tokenFile);
                } else if (renew) {
                    DelegationTokenFetcher.renewTokens(conf, tokenFile);
                } else {
                    FileSystem fs = DelegationTokenFetcher.getFileSystem(conf, webUrl);
                    DelegationTokenFetcher.saveDelegationToken(conf, fs, renewer, tokenFile);
                }
                return null;
            }
        });
    }

    private static FileSystem getFileSystem(Configuration conf, String url) throws IOException {
        if (url == null) {
            return FileSystem.get((Configuration)conf);
        }
        URI fsUri = URI.create(url.replaceFirst("^http://", "webhdfs://").replaceFirst("^https://", "swebhdfs://"));
        return FileSystem.get((URI)fsUri, (Configuration)conf);
    }

    @VisibleForTesting
    static void cancelTokens(Configuration conf, Path tokenFile) throws IOException, InterruptedException {
        for (Token<?> token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
            if (!token.isManaged()) continue;
            token.cancel(conf);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Cancelled token for " + token.getService()));
        }
    }

    @VisibleForTesting
    static void renewTokens(Configuration conf, Path tokenFile) throws IOException, InterruptedException {
        for (Token<?> token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
            if (!token.isManaged()) continue;
            long result = token.renew(conf);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Renewed token for " + token.getService() + " until: " + new Date(result)));
        }
    }

    @VisibleForTesting
    static void saveDelegationToken(Configuration conf, FileSystem fs, String renewer, Path tokenFile) throws IOException {
        Token token = fs.getDelegationToken(renewer);
        Credentials cred = new Credentials();
        cred.addToken(token.getKind(), token);
        cred.writeTokenStorageFile(tokenFile, conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetched token " + fs.getUri() + " for " + token.getService() + " into " + tokenFile));
        }
    }

    private static void printTokens(Configuration conf, Path tokenFile) throws IOException {
        DelegationTokenIdentifier id = new DelegationTokenSecretManager(0L, 0L, 0L, 0L, null).createIdentifier();
        for (Token<?> token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(token.getIdentifier()));
            id.readFields((DataInput)in);
            System.out.println("Token (" + id + ") for " + token.getService());
        }
    }

    private static void printUsage(PrintStream err) {
        err.println("fetchdt retrieves delegation tokens from the NameNode");
        err.println();
        err.println("fetchdt <opts> <token file>");
        err.println("Options:");
        err.println("  --webservice <url>  Url to contact NN on (starts with http:// or https://)");
        err.println("  --renewer <name>    Name of the delegation token renewer");
        err.println("  --cancel            Cancel the delegation token");
        err.println("  --renew             Renew the delegation token.  Delegation token must have been fetched using the --renewer <name> option.");
        err.println("  --print             Print the delegation token");
        err.println();
        GenericOptionsParser.printGenericCommandUsage((PrintStream)err);
        ExitUtil.terminate((int)1);
    }

    private static Collection<Token<?>> readTokens(Path file, Configuration conf) throws IOException {
        Credentials creds = Credentials.readTokenStorageFile((Path)file, (Configuration)conf);
        return creds.getAllTokens();
    }
}

