/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import com.google.common.base.Joiner;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.RemovedBlock;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockDeletionCommand
extends DatanodeCommand {
    RemovedBlock[] deletedBlocks;
    String blockPoolId;

    public BlockDeletionCommand(String poolId, RemovedBlock[] blocks) {
        super(2);
        this.deletedBlocks = blocks;
        this.blockPoolId = poolId;
    }

    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    public RemovedBlock[] getDeletedBlocks() {
        return this.deletedBlocks;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BlockDeletionCommand(\n  ");
        Joiner.on((String)"\n  ").appendTo(sb, (Object[])this.deletedBlocks);
        sb.append("\n)");
        return sb.toString();
    }
}

