/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;

public class ConfiguredFailoverProxyProvider<T>
extends AbstractNNFailoverProxyProvider<T> {
    private static final Log LOG = LogFactory.getLog(ConfiguredFailoverProxyProvider.class);
    private final Configuration conf;
    private final List<AddressRpcProxyPair<T>> proxies = new ArrayList<AddressRpcProxyPair<T>>();
    private final UserGroupInformation ugi;
    private final Class<T> xface;
    private int currentProxyIndex = 0;

    public ConfiguredFailoverProxyProvider(Configuration conf, URI uri, Class<T> xface) {
        Preconditions.checkArgument((boolean)xface.isAssignableFrom(NamenodeProtocols.class), (Object)"Interface class %s is not a valid NameNode protocol!");
        this.xface = xface;
        this.conf = new Configuration(conf);
        int maxRetries = this.conf.getInt("dfs.client.failover.connection.retries", 0);
        this.conf.setInt("ipc.client.connect.max.retries", maxRetries);
        int maxRetriesOnSocketTimeouts = this.conf.getInt("dfs.client.failover.connection.retries.on.timeouts", 0);
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", maxRetriesOnSocketTimeouts);
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
            Map<String, Map<String, InetSocketAddress>> map = DFSUtil.getHaNnRpcAddresses(conf);
            Map<String, InetSocketAddress> addressesInNN = map.get(uri.getHost());
            if (addressesInNN == null || addressesInNN.size() == 0) {
                throw new RuntimeException("Could not find any configured addresses for URI " + uri);
            }
            Collection<InetSocketAddress> addressesOfNns = addressesInNN.values();
            for (InetSocketAddress address : addressesOfNns) {
                this.proxies.add(new AddressRpcProxyPair(address));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<T> getInterface() {
        return this.xface;
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        AddressRpcProxyPair<T> current = this.proxies.get(this.currentProxyIndex);
        if (current.namenode == null) {
            try {
                current.namenode = NameNodeProxies.createNonHAProxy(this.conf, current.address, this.xface, this.ugi, false, this.fallbackToSimpleAuth).getProxy();
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to create RPC proxy to NameNode", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        throw new UnsupportedOperationException("fix me");
    }

    public synchronized void performFailover(T currentProxy) {
        this.currentProxyIndex = (this.currentProxyIndex + 1) % this.proxies.size();
    }

    public synchronized void close() throws IOException {
        for (AddressRpcProxyPair<T> proxy : this.proxies) {
            if (proxy.namenode == null) continue;
            if (proxy.namenode instanceof Closeable) {
                ((Closeable)proxy.namenode).close();
                continue;
            }
            RPC.stopProxy(proxy.namenode);
        }
    }

    private static class AddressRpcProxyPair<T> {
        public InetSocketAddress address;
        public T namenode;

        public AddressRpcProxyPair(InetSocketAddress address) {
            this.address = address;
        }
    }
}

