/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.metadata.hdfs.entity.ProjectedINode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.namenode.AbstractFileTree;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;

public class FSSTOHelper {
    public static final Log LOG = LogFactory.getLog(FSSTOHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyAllPendingQuotaInSubTree(FSNamesystem fsn, AbstractFileTree.FileTree fileTree) throws IOException {
        for (int i = fileTree.getHeight(); i > 0; --i) {
            try {
                Iterator<Long> itr;
                Collection<ProjectedINode> dirs = fileTree.getDirsByLevel(i);
                ArrayList<Long> dirIDs = new ArrayList<Long>();
                for (ProjectedINode dir : dirs) {
                    dirIDs.add(dir.getId());
                }
                Iterator<Long> iterator = itr = dirIDs.iterator();
                synchronized (iterator) {
                    fsn.getQuotaUpdateManager().addPrioritizedUpdates(itr);
                    itr.wait();
                    continue;
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Operation failed due to an Interrupt");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyAllPendingQuotaForDirectory(FSNamesystem fsn, long inodeID) throws IOException {
        try {
            Iterator<Long> itr;
            ArrayList<Long> dstInode = new ArrayList<Long>();
            dstInode.add(inodeID);
            Iterator<Long> iterator = itr = dstInode.iterator();
            synchronized (iterator) {
                fsn.getQuotaUpdateManager().addPrioritizedUpdates(itr);
                itr.wait();
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Operation failed due to an Interrupt");
        }
    }
}

