/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkClientException;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.client.builder.ExecutorFactory;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.DeleteVersionRequest;
import com.amazonaws.services.s3.model.GetBucketLocationRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.SSEAlgorithm;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.ServerSideEncryptionByDefault;
import com.amazonaws.services.s3.model.ServerSideEncryptionConfiguration;
import com.amazonaws.services.s3.model.ServerSideEncryptionRule;
import com.amazonaws.services.s3.model.SetBucketEncryptionRequest;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import io.hops.metadata.hdfs.BlockIDAndGSTuple;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.CloudBlock;
import org.apache.hadoop.hdfs.server.common.CloudHelper;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.ActiveMultipartUploads;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.BlockMovedToColdStorageException;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudObject;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudPersistenceProvider;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudS3Encryption;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.PartRef;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.S3ActiveMultipartUploads;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.S3PartRef;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.S3UploadID;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.UploadID;

public class CloudPersistenceProviderS3Impl
implements CloudPersistenceProvider {
    @VisibleForTesting
    public static final Log LOG = LogFactory.getLog(CloudPersistenceProviderS3Impl.class);
    private final Configuration conf;
    private final AmazonS3 s3Client;
    private Regions region;
    private final int prefixSize;
    private TransferManager transfers;
    private final int bucketDeletionThreads;
    private long partSize;
    private int maxThreads;
    private long multiPartThreshold;
    private final boolean sseEnabled;
    private final boolean versioningEnabled;
    private final boolean sseBucketKeyEnable;
    private final String sseType;
    private final String sseKeyARN;
    private String endPoint;
    private String signingRegion;
    private final Boolean bucketOwnerFullControll;
    private final boolean bypassGovernanceRetention;

    public CloudPersistenceProviderS3Impl(Configuration conf) {
        this.conf = conf;
        this.endPoint = conf.get("dfs.cloud.aws.endpoint", "");
        this.signingRegion = conf.get("dfs.cloud.aws.signing.region", "us-east-1");
        this.region = null;
        if (this.endPoint.compareToIgnoreCase("") == 0) {
            this.region = Regions.fromName((String)conf.get("dfs.cloud.aws.s3.region", "eu-north-1"));
        }
        this.bucketDeletionThreads = conf.getInt("dfs.nn.max.threads.for.formatting.cloud.buckets", 30);
        this.prefixSize = conf.getInt("dfs.cloud.prefix.size", 500);
        this.maxThreads = conf.getInt("dfs.dn.cloud.max.upload.threads", 20);
        if (this.maxThreads < 2) {
            LOG.warn((Object)"dfs.dn.cloud.max.upload.threads must be at least 2: forcing to 2.");
            this.maxThreads = 2;
        }
        this.versioningEnabled = conf.getBoolean("s3.bucket.enable.versioning", false);
        this.sseEnabled = conf.getBoolean("dfs.cloud.aws.server.side.encryption.enable", false);
        this.sseBucketKeyEnable = conf.getBoolean("dfs.cloud.aws.server.side.encryption.bucket.key.enable", DFSConfigKeys.DFS_CLOUD_AWS_SERVER_SIDE_ENCRYPTION_BUCKET_KEY_ENABLE_DEFAULT.booleanValue());
        this.sseKeyARN = conf.get("dfs.cloud.aws.server.side.encryption.key.arn", "");
        this.sseType = conf.get("dfs.cloud.aws.server.side.encryption.type", "SSE-KMS");
        if (this.sseType.compareToIgnoreCase(CloudS3Encryption.SSE_KMS.toString()) != 0 && this.sseType.compareToIgnoreCase(CloudS3Encryption.SSE_S3.toString()) != 0) {
            throw new IllegalArgumentException("Invalid Amazon S3 Encryption type");
        }
        this.bucketOwnerFullControll = conf.getBoolean("dfs.cloud.aws.amz.acl.bucket.owner.full.control.enable", DFSConfigKeys.DFS_CLOUD_AWS_AMZ_ACL_BUCKET_OWNER_FULL_CONTROL_ENABLE_DEFAULT.booleanValue());
        this.bypassGovernanceRetention = conf.getBoolean("dfs.cloud.aws.s3.bypass-governance-retention", false);
        this.s3Client = this.connect();
        this.initTransferManager();
    }

    private AmazonS3 connect() {
        LOG.info((Object)("HopsFS-Cloud. Connecting to S3. Region " + this.region));
        ClientConfiguration s3conf = new ClientConfiguration();
        int retryCount = this.conf.getInt("dfs.cloud.failed.ops.retry.count", 5);
        RetryPolicy retryPolicy = new RetryPolicy(PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION, PredefinedRetryPolicies.DEFAULT_BACKOFF_STRATEGY, retryCount, true);
        s3conf.setRetryPolicy(retryPolicy);
        s3conf.setMaxErrorRetry(retryCount);
        s3conf.setMaxConnections(this.maxThreads);
        LOG.info((Object)("Max retry " + s3conf.getMaxErrorRetry()));
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(s3conf);
        if (this.region != null) {
            LOG.info((Object)("HopsFS-Cloud. Using AWS region: " + this.region.toString()));
            builder.withRegion(this.region);
        } else {
            LOG.info((Object)("HopsFS-Cloud. Using AWS endpoint: " + this.endPoint + ". Signing Region: " + this.signingRegion));
            AwsClientBuilder.EndpointConfiguration epc = new AwsClientBuilder.EndpointConfiguration(this.endPoint, this.signingRegion);
            builder.withEndpointConfiguration(epc);
            builder.setPathStyleAccessEnabled(Boolean.valueOf(true));
        }
        return (AmazonS3)builder.build();
    }

    public void initTransferManager() {
        this.partSize = this.conf.getLong("dfs.cloud.multipart.size", 0x1000000L);
        if (this.partSize < 0x500000L) {
            LOG.error((Object)"dfs.cloud.multipart.size must be at least 5 MB");
            this.partSize = 0x500000L;
        }
        this.multiPartThreshold = this.conf.getLong("dfs.cloud.multipart.threshold", 0x2000000L);
        if (this.multiPartThreshold < 0x500000L) {
            LOG.error((Object)"dfs.cloud.multipart.threshold must be at least 5 MB");
            this.multiPartThreshold = 0x500000L;
        }
        this.transfers = TransferManagerBuilder.standard().withS3Client(this.s3Client).withExecutorFactory(new ExecutorFactory(){

            public ExecutorService newExecutor() {
                return Executors.newFixedThreadPool(CloudPersistenceProviderS3Impl.this.maxThreads);
            }
        }).withMultipartUploadThreshold(Long.valueOf(this.multiPartThreshold)).withMinimumUploadPartSize(Long.valueOf(this.partSize)).withMultipartCopyThreshold(Long.valueOf(this.multiPartThreshold)).withMultipartCopyPartSize(Long.valueOf(this.partSize)).build();
    }

    private void createS3Bucket(String bucketName) {
        if (!this.s3Client.doesBucketExistV2(bucketName)) {
            this.s3Client.createBucket(bucketName);
            String bucketLocation = this.s3Client.getBucketLocation(new GetBucketLocationRequest(bucketName));
            LOG.info((Object)("HopsFS-Cloud. New bucket created. Name: " + bucketName + " Location: " + bucketLocation));
        } else {
            LOG.info((Object)("HopsFS-Cloud. Bucket already exists. Bucket Name: " + bucketName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllBuckets(String prefix) throws IOException, ExecutionException, InterruptedException {
        ExecutorService tPool = Executors.newFixedThreadPool(this.bucketDeletionThreads);
        try {
            List buckets = this.s3Client.listBuckets();
            LOG.info((Object)("HopsFS-Cloud. Deleting all of the buckets with prefix \"" + prefix + "\" for this user. Number of deletion threads " + this.bucketDeletionThreads));
            for (Bucket b : buckets) {
                if (!b.getName().startsWith(prefix.toLowerCase())) continue;
                this.emptyBucket(b.getName(), false, tPool);
                this.deleteBucket(b.getName());
            }
        }
        finally {
            tPool.shutdown();
        }
    }

    @Override
    public boolean existsCID(String bucket) throws IOException {
        if (!this.s3Client.doesBucketExistV2(bucket)) {
            return false;
        }
        return this.objectExists(bucket, "HOPSFS_CID");
    }

    @Override
    public void setCID(String bucket, String cid) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            if (!this.s3Client.doesBucketExistV2(bucket)) {
                throw new IOException("Bucket " + bucket + " does not exist");
            }
            ObjectMetadata objMetadata = new ObjectMetadata();
            objMetadata.setContentType("plain/text");
            ByteArrayInputStream cidStream = new ByteArrayInputStream(cid.getBytes());
            PutObjectRequest putReq = new PutObjectRequest(bucket, "HOPSFS_CID", (InputStream)cidStream, objMetadata);
            this.setUploadHeaders(putReq, objMetadata);
            putReq.setMetadata(objMetadata);
            Upload upload = this.transfers.upload(putReq);
            upload.waitForUploadResult();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.toString());
        }
        catch (AmazonServiceException e) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in setCID, CID: " + cid + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        catch (SdkClientException e) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in setCID, CID: " + cid + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud.  set CID. Bucket: " + bucket + " Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
    }

    @Override
    public String getCID(String bucket) throws IOException {
        long startTime = System.currentTimeMillis();
        String cid = null;
        try {
            if (!this.s3Client.doesBucketExistV2(bucket)) {
                throw new IOException("Bucket " + bucket + " does not exist");
            }
            S3Object object = this.s3Client.getObject(new GetObjectRequest(bucket, "HOPSFS_CID"));
            S3ObjectInputStream objectData = object.getObjectContent();
            cid = new BufferedReader(new InputStreamReader((InputStream)objectData)).lines().collect(Collectors.joining("\n"));
            objectData.close();
        }
        catch (AmazonServiceException e) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in getCID. Bucket: " + bucket + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        catch (SdkClientException e) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in getCID. Bucket: " + bucket + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud.  get CID.  Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
        return cid;
    }

    @Override
    public boolean isEmpty(String bucket) throws IOException {
        VersionListing versionList;
        if (!this.s3Client.doesBucketExistV2(bucket)) {
            throw new IOException("Bucket " + bucket + " does not exist");
        }
        ListObjectsV2Request req = new ListObjectsV2Request().withBucketName(bucket);
        ListObjectsV2Result listResult = this.s3Client.listObjectsV2(req);
        if (listResult.getObjectSummaries().size() > 0) {
            return false;
        }
        return !this.versioningEnabled || (versionList = this.s3Client.listVersions(new ListVersionsRequest().withBucketName(bucket))).getVersionSummaries().size() <= 0;
    }

    @Override
    public boolean bucketExists(String bucket) throws IOException {
        return this.s3Client.doesBucketExistV2(bucket);
    }

    @Override
    public void format(List<String> buckets) {
        ExecutorService tPool = Executors.newFixedThreadPool(this.bucketDeletionThreads);
        try {
            String msg = "HopsFS-Cloud. Deleting all of the buckets used by HopsFS. Number of deletion threads " + this.bucketDeletionThreads;
            LOG.info((Object)msg);
            System.out.println(msg);
            for (String bucket : buckets) {
                if (this.versioningEnabled && !this.isVersioningSupported(bucket)) {
                    throw new IOException("Cannot format file system. Versioning is enabled. However the bucket does not support versioning");
                }
                this.emptyBucket(bucket, true, tPool);
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOG.warn((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            tPool.shutdown();
        }
    }

    @Override
    public void createBucket(String bucket) {
        this.createS3Bucket(bucket);
        this.enableVersioning(bucket);
        this.enableBucketEncryption(bucket);
    }

    public void deleteBucket(String bucket) {
        this.s3Client.deleteBucket(bucket);
    }

    @Override
    public void checkAllBuckets(List<String> buckets) throws IOException {
        int retry = 300;
        for (String bucket : buckets) {
            boolean exists = false;
            for (int j = 0; j < 300; ++j) {
                if (!this.s3Client.doesBucketExistV2(bucket)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                exists = true;
                break;
            }
            if (!exists) {
                throw new IllegalStateException("S3 Bucket " + bucket + " needed for the file system does not exists");
            }
            UUID uuid = UUID.randomUUID();
            try {
                File objFile = new File("/tmp/" + UUID.randomUUID());
                FileWriter fw = new FileWriter(objFile);
                fw.write("test string");
                fw.close();
                HashMap<String, String> metadata = new HashMap<String, String>();
                this.uploadObject(bucket, uuid.toString(), objFile, metadata);
                this.objectExists(bucket, uuid.toString());
                this.deleteObject(bucket, uuid.toString());
                objFile.delete();
                LOG.info((Object)("HopsFS-Cloud. Checked bucket: " + bucket));
            }
            catch (Exception e) {
                throw new IllegalStateException("Write test for S3 bucket: " + bucket + " failed. " + e);
            }
        }
    }

    private void emptyBucket(final String bucketName, boolean onlyDeleteHopsFSData, ExecutorService tPool) throws ExecutionException, InterruptedException, IOException {
        final AtomicInteger deletedBlocks = new AtomicInteger(0);
        try {
            ListObjectsV2Result listResult;
            if (!this.s3Client.doesBucketExistV2(bucketName)) {
                throw new IOException("Cannot format file system. The bucket does not exist");
            }
            System.out.println("HopsFS-Cloud. Deleting bucket: " + bucketName);
            ListObjectsV2Request req = new ListObjectsV2Request().withBucketName(bucketName);
            do {
                listResult = this.s3Client.listObjectsV2(req);
                ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
                for (S3ObjectSummary s3ObjectSummary : listResult.getObjectSummaries()) {
                    final String objectkey = s3ObjectSummary.getKey();
                    if (onlyDeleteHopsFSData && !objectkey.startsWith("hopsfs-blocks-set-")) continue;
                    Callable<Object> callable = new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            CloudPersistenceProviderS3Impl.this.s3Client.deleteObject(bucketName, objectkey);
                            String msg = "\rDeleted Blocks: " + deletedBlocks.incrementAndGet();
                            System.out.print(msg);
                            return null;
                        }
                    };
                    futures.add(tPool.submit(callable));
                }
                for (Future future : futures) {
                    future.get();
                }
                req.setContinuationToken(listResult.getNextContinuationToken());
            } while (listResult.isTruncated());
            VersionListing versionList = this.s3Client.listVersions(new ListVersionsRequest().withBucketName(bucketName));
            while (true) {
                Iterator versionIter = versionList.getVersionSummaries().iterator();
                ArrayList<Future<Object>> arrayList = new ArrayList<Future<Object>>();
                while (versionIter.hasNext()) {
                    final S3VersionSummary vs = (S3VersionSummary)versionIter.next();
                    if (onlyDeleteHopsFSData && !vs.getKey().startsWith("hopsfs-blocks-set-")) continue;
                    Callable<Object> callable = new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            CloudPersistenceProviderS3Impl.this.s3Client.deleteVersion(CloudPersistenceProviderS3Impl.this.createDeleteVersionRequest(bucketName, vs));
                            String msg = "\rDeleted Versioned Blocks: " + deletedBlocks.incrementAndGet();
                            System.out.print(msg);
                            return null;
                        }
                    };
                    arrayList.add(tPool.submit(callable));
                }
                for (Future future : arrayList) {
                    future.get();
                }
                if (!versionList.isTruncated()) break;
                versionList = this.s3Client.listNextBatchOfVersions(versionList);
            }
            if (this.objectExists(bucketName, "HOPSFS_CID")) {
                this.s3Client.deleteObject(bucketName, "HOPSFS_CID");
            }
            System.out.println("");
        }
        catch (AmazonServiceException up) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in emptyAndDeleteS3Bucket. Bucket: " + bucketName + "Error: " + up.getMessage()));
            up.printStackTrace();
            throw up;
        }
        catch (SdkClientException up) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in emptyAndDeleteS3Bucket. Bucket: " + bucketName + "Error: " + up.getMessage()));
            up.printStackTrace();
            throw up;
        }
    }

    private DeleteVersionRequest createDeleteVersionRequest(String bucket, S3VersionSummary versionSummary) {
        DeleteVersionRequest dvr = new DeleteVersionRequest(bucket, versionSummary.getKey(), versionSummary.getVersionId());
        if (this.bypassGovernanceRetention) {
            dvr.setBypassGovernanceRetention(true);
        }
        return dvr;
    }

    @Override
    public void uploadObject(String bucket, String objectKey, File object, Map<String, String> metadata) throws IOException {
        try {
            LOG.info((Object)("HopsFS-Cloud. Put Object. Bucket: " + bucket + " Object Key: " + objectKey + "  Object Size: " + objectKey.length()));
            long startTime = System.currentTimeMillis();
            PutObjectRequest putReq = new PutObjectRequest(bucket, objectKey, object);
            ObjectMetadata objMetadata = new ObjectMetadata();
            objMetadata.setContentType("plain/text");
            objMetadata.setUserMetadata(metadata);
            this.setUploadHeaders(putReq, objMetadata);
            putReq.setMetadata(objMetadata);
            Upload upload = this.transfers.upload(putReq);
            upload.waitForUploadResult();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Put Object. Bucket: " + bucket + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.toString());
        }
        catch (AmazonServiceException e) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in uploadObject. Bucket: " + bucket + " Key: " + objectKey + " File: " + object.getAbsolutePath() + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        catch (SdkClientException e) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in uploadObject. Bucket: " + bucket + " Key: " + objectKey + " File: " + object.getAbsolutePath() + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public int getPrefixSize() {
        return this.prefixSize;
    }

    @Override
    public boolean objectExists(String bucket, String objectKey) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            boolean exists = this.s3Client.doesObjectExist(bucket, objectKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Object Exists?. Bucket: " + bucket + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
            return exists;
        }
        catch (AmazonServiceException e) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in objectExists. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        catch (SdkClientException e) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException : in objectExists. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    private ObjectMetadata getS3ObjectMetadata(String bucket, String objectKey) throws IOException {
        try {
            GetObjectMetadataRequest req = new GetObjectMetadataRequest(bucket, objectKey);
            ObjectMetadata s3metadata = this.s3Client.getObjectMetadata(req);
            return s3metadata;
        }
        catch (AmazonServiceException e) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in getS3ObjectMetadata. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        catch (SdkClientException e) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in getS3ObjectMetadata. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public Map<String, String> getUserMetaData(String bucket, String objectKey) throws IOException {
        long startTime = System.currentTimeMillis();
        ObjectMetadata s3metadata = this.getS3ObjectMetadata(bucket, objectKey);
        Map metadata = s3metadata.getUserMetadata();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud. Get Object Metadata. Bucket: " + bucket + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
        return metadata;
    }

    @Override
    public long getObjectSize(String bucket, String objectKey) throws IOException {
        long startTime = System.currentTimeMillis();
        ObjectMetadata s3metadata = this.getS3ObjectMetadata(bucket, objectKey);
        long size = s3metadata.getContentLength();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud. Get Object Size. Bucket: " + bucket + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
        return size;
    }

    @Override
    public void downloadObject(String bucket, String objectKey, File path) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            if (path.exists()) {
                path.delete();
            } else if (!path.getParentFile().exists()) {
                path.getParentFile().mkdirs();
            }
            Random rand = new Random(System.currentTimeMillis());
            File tmpFile = new File(path.getAbsolutePath() + "." + rand.nextLong() + ".downloading");
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            Download down = this.transfers.download(bucket, objectKey, tmpFile);
            down.waitForCompletion();
            tmpFile.renameTo(path);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Download Object. Bucket: " + bucket + " Object Key: " + objectKey + " Download Path: " + path + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (AmazonServiceException e) {
            if (e instanceof AmazonS3Exception) {
                if (e.getMessage().contains("The operation is not valid for the object's storage class")) {
                    String sc = (String)((AmazonS3Exception)e).getAdditionalDetails().get("StorageClass");
                    String message = "Unable to read block " + objectKey + ".";
                    if (sc != null) {
                        message = message + " The block has moved to storage: " + sc + ". Please restore the block to read the file";
                    }
                    throw new BlockMovedToColdStorageException(message);
                }
                LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in downloadObject. Bucket: " + bucket + " ObjKey: " + objectKey + " File: " + path.getAbsolutePath() + " Error: " + e.getMessage()));
            }
            throw new IOException(e);
        }
        catch (SdkClientException e) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in downloadObject Bucket: " + bucket + " ObjKey: " + objectKey + " File: " + path.getAbsolutePath() + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.toString());
        }
    }

    @Override
    @VisibleForTesting
    public Map<BlockIDAndGSTuple, CloudBlock> getAll(String prefix, List<String> buckets) throws IOException {
        long startTime = System.currentTimeMillis();
        HashMap<BlockIDAndGSTuple, CloudBlock> blocks = new HashMap<BlockIDAndGSTuple, CloudBlock>();
        for (String bucket : buckets) {
            this.listBucket(bucket, prefix, blocks);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud. Get all blocks. Buckets: " + Arrays.toString(buckets.toArray()) + " Prefix: " + prefix + " Total Blocks: " + blocks.size() + " Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
        return blocks;
    }

    @Override
    public List<String> getAllHopsFSDirectories(List<String> buckets) throws IOException {
        ArrayList<String> dirs = new ArrayList<String>();
        for (String bucket : buckets) {
            ListObjectsV2Result result;
            ListObjectsV2Request req = new ListObjectsV2Request().withBucketName(bucket).withDelimiter("/").withPrefix("hopsfs-blocks-set-");
            do {
                result = this.s3Client.listObjectsV2(req);
                for (String dir : result.getCommonPrefixes()) {
                    if (dir.contains("hopsfs-blocks-set-")) {
                        dirs.add(dir);
                        continue;
                    }
                    LOG.info((Object)("HopsFS-Cloud. Ignoring " + dir + " directory. It is not HopsFS directory"));
                }
                String token = result.getNextContinuationToken();
                req.setContinuationToken(token);
            } while (result.isTruncated());
        }
        return dirs;
    }

    @Override
    public void deleteObject(String bucket, String objectKey) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            this.s3Client.deleteObject(bucket, objectKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Delete object. Bucket: " + bucket + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (AmazonServiceException up) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in deleteObject. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
        catch (SdkClientException up) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in deleteObject. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
    }

    @Override
    public void shutdown() {
        this.s3Client.shutdown();
        if (this.transfers != null) {
            this.transfers.shutdownNow(true);
            this.transfers = null;
        }
    }

    private void listBucket(String bucketName, String prefix, Map<BlockIDAndGSTuple, CloudBlock> result) throws IOException {
        HashMap<BlockIDAndGSTuple, CloudObject> blockObjs = new HashMap<BlockIDAndGSTuple, CloudObject>();
        HashMap<BlockIDAndGSTuple, CloudObject> metaObjs = new HashMap<BlockIDAndGSTuple, CloudObject>();
        try {
            ListObjectsV2Result listResult;
            if (!this.s3Client.doesBucketExistV2(bucketName)) {
                return;
            }
            assert (prefix != null);
            ListObjectsV2Request req = new ListObjectsV2Request().withBucketName(bucketName).withPrefix(prefix);
            do {
                listResult = this.s3Client.listObjectsV2(req);
                for (S3ObjectSummary s3Object : listResult.getObjectSummaries()) {
                    String key = s3Object.getKey();
                    CloudObject co = new CloudObject();
                    co.setBucket(s3Object.getBucketName());
                    co.setKey(s3Object.getKey());
                    co.setSize(s3Object.getSize());
                    co.setLastModifiedTime(s3Object.getLastModified().getTime());
                    BlockIDAndGSTuple idAndGS = CloudHelper.getIDAndGSFromKey(key);
                    if (idAndGS != null && CloudHelper.isBlockFilename(key)) {
                        blockObjs.put(idAndGS, co);
                        continue;
                    }
                    if (idAndGS != null || CloudHelper.isMetaFilename(key)) {
                        metaObjs.put(idAndGS, co);
                        continue;
                    }
                    LOG.warn((Object)("HopsFS-Cloud. File system objects are tampered. The " + key + " is not HopsFS object."));
                }
                req.setContinuationToken(listResult.getNextContinuationToken());
            } while (listResult.isTruncated());
        }
        catch (AmazonServiceException up) {
            LOG.error((Object)("HopsFS-Cloud. Unable to list bucket: " + bucketName + " prefix: \"" + prefix + "\" AmazonServiceException " + (Object)((Object)up)));
            throw new IOException(up);
        }
        catch (SdkClientException up) {
            LOG.error((Object)("HopsFS-Cloud. Unable to list bucket: " + bucketName + " prefix: \"" + prefix + "\" SdkClientException " + (Object)((Object)up)));
            throw new IOException(up);
        }
        CloudPersistenceProviderS3Impl.mergeMetaAndBlockObjects(metaObjs, blockObjs, result);
    }

    public static void mergeMetaAndBlockObjects(Map<BlockIDAndGSTuple, CloudObject> metaObjs, Map<BlockIDAndGSTuple, CloudObject> blockObjs, Map<BlockIDAndGSTuple, CloudBlock> res) {
        Set<BlockIDAndGSTuple> blockKeySet = blockObjs.keySet();
        Set<BlockIDAndGSTuple> metaKeySet = metaObjs.keySet();
        Sets.SetView symDiff = Sets.symmetricDifference(blockKeySet, metaKeySet);
        Sets.SetView intersection = Sets.intersection(blockKeySet, metaKeySet);
        for (BlockIDAndGSTuple cloudBlockObjectKey : intersection) {
            CloudObject blockObj = blockObjs.get(cloudBlockObjectKey);
            CloudObject metaObj = metaObjs.get(cloudBlockObjectKey);
            long blockSize = blockObj.getSize();
            long genStamp = cloudBlockObjectKey.getGs();
            Block block = new Block(cloudBlockObjectKey.getBlockID(), blockSize, genStamp, blockObj.getBucketName());
            CloudBlock cb = new CloudBlock(block, blockObj.getLastModified());
            res.put(cloudBlockObjectKey, cb);
        }
        for (BlockIDAndGSTuple cloudObjectKey : symDiff) {
            String keyFound = "";
            String bucket = "";
            CloudBlock cb = new CloudBlock();
            CloudObject blockObj = blockObjs.get(cloudObjectKey);
            CloudObject metaObj = metaObjs.get(cloudObjectKey);
            if (blockObj != null) {
                cb.setBlockObjectFound(true);
                cb.setLastModified(blockObj.getLastModified());
                bucket = blockObj.getBucketName();
            } else if (metaObj != null) {
                cb.setMetaObjectFound(true);
                cb.setLastModified(metaObj.getLastModified());
                bucket = metaObj.getBucketName();
            }
            Block block = new Block();
            block.setBlockIdNoPersistance(cloudObjectKey.getBlockID());
            block.setGenerationStampNoPersistance(cloudObjectKey.getGs());
            block.setCloudBucketNoPersistance(bucket);
            cb.setBlock(block);
            res.put(cloudObjectKey, cb);
        }
    }

    @Override
    @VisibleForTesting
    public void renameObject(String srcBucket, String dstBucket, String srcKey, String dstKey) throws IOException {
        try {
            this.copyObject(srcBucket, dstBucket, srcKey, dstKey, null);
            long startTime = System.currentTimeMillis();
            this.deleteObject(srcBucket, srcKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Deleting after rename object. Src Bucket: " + srcBucket + " Dst Bucket: " + dstBucket + " Src Object Key: " + srcKey + " Dst Object Key: " + dstKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (AmazonServiceException up) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in renameObject  Src Bucket: " + srcBucket + " Dst Bucket: " + dstBucket + " SrcKey: " + srcKey + " DstKey: " + dstKey + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
        catch (SdkClientException up) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in renameObject  Src Bucket: " + srcBucket + " Dst Bucket: " + dstBucket + " SrcKey: " + srcKey + " DstKey: " + dstKey + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
    }

    @Override
    public void copyObject(String srcBucket, String dstBucket, String srcKey, String dstKey, Map<String, String> newObjMetadata) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            CopyObjectRequest req = new CopyObjectRequest(srcBucket, srcKey, dstBucket, dstKey);
            ObjectMetadata objectMetadata = new ObjectMetadata();
            this.setUploadHeaders(req, objectMetadata);
            if (newObjMetadata != null) {
                objectMetadata.setUserMetadata(newObjMetadata);
            }
            req.setNewObjectMetadata(objectMetadata);
            CopyObjectResult res = this.s3Client.copyObject(req);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Copy object. Src Bucket: " + srcBucket + " Dst Bucket: " + dstBucket + " Src Object Key: " + srcKey + " Dst Object Key: " + dstKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (AmazonServiceException up) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in copyObject. Src Bucket: " + srcBucket + " Dst Bucket: " + dstBucket + " SrcKey: " + srcKey + " DstKey: " + dstKey + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
        catch (SdkClientException up) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in copyObject. Src Bucket: " + srcBucket + " Dst Bucket: " + dstBucket + " SrcKey: " + srcKey + " DstKey: " + dstKey + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
    }

    @Override
    public long getPartSize() {
        return this.partSize;
    }

    @Override
    public int getXferThreads() {
        return this.maxThreads;
    }

    @Override
    public UploadID startMultipartUpload(String bucket, String objectKey, Map<String, String> metadata) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(bucket, objectKey);
            ObjectMetadata objMetadata = new ObjectMetadata();
            objMetadata.setContentType("plain/text");
            objMetadata.setUserMetadata(metadata);
            this.setUploadHeaders(initRequest, objMetadata);
            initRequest.setObjectMetadata(objMetadata);
            InitiateMultipartUploadResult initResponse = this.s3Client.initiateMultipartUpload(initRequest);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Start multipart upload. Bucket: " + bucket + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
            return new S3UploadID(initResponse.getUploadId());
        }
        catch (AmazonServiceException up) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in startMultipartUpload. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
        catch (SdkClientException up) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in startMultipartUpload. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
    }

    @Override
    public PartRef uploadPart(String bucket, String objectKey, UploadID uploadID, int partNo, File file, long startPos, long endPos) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(bucket).withKey(objectKey).withUploadId(((S3UploadID)uploadID).getS3MultipartID()).withPartNumber(partNo).withFileOffset(startPos).withFile(file).withPartSize(endPos - startPos);
            UploadPartResult uploadResult = this.s3Client.uploadPart(uploadRequest);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Upload part. Bucket: " + bucket + " Object Key: " + objectKey + " PartNo: " + partNo + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
            return new S3PartRef(uploadResult.getPartETag());
        }
        catch (AmazonServiceException up) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in uploadPart. Bucket: " + bucket + " ObjKey: " + objectKey + " UploadID: " + uploadID.toString() + " Part No:" + partNo + " File: " + file.getAbsolutePath() + " Start Pos: " + startPos + " End Pos: " + endPos + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
        catch (SdkClientException up) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in uploadPart. Bucket: " + bucket + " ObjKey: " + objectKey + " UploadID: " + uploadID.toString() + " Part No:" + partNo + " File: " + file.getAbsolutePath() + " Start Pos: " + startPos + " End Pos: " + endPos + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
    }

    @Override
    public void finalizeMultipartUpload(String bucket, String objectKey, UploadID uploadID, List<PartRef> refs) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            ArrayList<PartETag> partETags = new ArrayList<PartETag>();
            for (PartRef ref : refs) {
                partETags.add(((S3PartRef)ref).getPartETag());
            }
            CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(bucket, objectKey, ((S3UploadID)uploadID).getS3MultipartID(), partETags);
            this.s3Client.completeMultipartUpload(compRequest);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Finalize multipart upload. Bucket: " + bucket + " Object Key: " + objectKey + " Total Parts: " + partETags.size() + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (AmazonServiceException up) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in finalizeMultipartUpload. Bucket: " + bucket + " ObjKey: " + objectKey + " UploadID: " + uploadID.toString() + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
        catch (SdkClientException up) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in finalizeMultipartUpload. Bucket: " + bucket + " ObjKey: " + objectKey + " UploadID: " + uploadID.toString() + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
    }

    @Override
    public void abortMultipartUpload(String bucket, String objectKey, UploadID uploadID) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            AbortMultipartUploadRequest req = new AbortMultipartUploadRequest(bucket, objectKey, ((S3UploadID)uploadID).getS3MultipartID());
            this.s3Client.abortMultipartUpload(req);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Aborted multipart upload. Bucket: " + bucket + " Object Key: " + objectKey + " UploadID: " + ((S3UploadID)uploadID).getS3MultipartID() + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (AmazonServiceException up) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in abortMultipartUpload. Bucket: " + bucket + " ObjKey: " + objectKey + " UploadID: " + uploadID.toString() + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
        catch (SdkClientException up) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in abortMultipartUpload. Bucket: " + bucket + " ObjKey: " + objectKey + " UploadID: " + uploadID.toString() + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
    }

    @Override
    public List<ActiveMultipartUploads> listMultipartUploads(List<String> buckets, String prefix) throws IOException {
        ArrayList<ActiveMultipartUploads> uploads = new ArrayList<ActiveMultipartUploads>();
        long startTime = System.currentTimeMillis();
        for (String bucket : buckets) {
            uploads.addAll(this.listMultipartUploadsForBucket(bucket, prefix));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud. List multipart. Active Uploads " + uploads.size() + " Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
        return uploads;
    }

    @Override
    public boolean restoreDeletedBlock(String bucket, String objectKey) throws IOException {
        ListVersionsRequest req = new ListVersionsRequest();
        req.setPrefix(objectKey);
        req.setBucketName(bucket);
        try {
            VersionListing versions = this.s3Client.listVersions(req);
            for (S3VersionSummary versionSummary : versions.getVersionSummaries()) {
                if (versionSummary.isDeleteMarker()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("HopsFS-Cloud. Recovering Block ID: " + versionSummary.getKey() + "  Deleting Version: " + versionSummary.getVersionId()));
                    }
                    this.s3Client.deleteVersion(this.createDeleteVersionRequest(bucket, versionSummary));
                    continue;
                }
                return true;
            }
        }
        catch (AmazonServiceException up) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in restoreDeletedBlock. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
        catch (SdkClientException up) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in restoreDeletedBlock. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
        return false;
    }

    @Override
    public boolean isVersioningSupported(String bucket) throws IOException {
        if (!this.versioningEnabled) {
            return false;
        }
        try {
            BucketVersioningConfiguration conf = this.s3Client.getBucketVersioningConfiguration(bucket);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Versioning Status: " + conf.getStatus()));
            }
            if (conf.getStatus().compareTo("Enabled") == 0) {
                LOG.debug((Object)"HopsFS-Cloud. Versioning is enabled");
                return true;
            }
            return false;
        }
        catch (AmazonServiceException up) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in isVersioningSupported. Bucket: " + bucket + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
        catch (SdkClientException up) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in isVersioningSupported. Bucket: " + bucket + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
    }

    public List<S3VersionSummary> listAllVersions(String bucket, String objectKey) throws IOException {
        ArrayList<S3VersionSummary> versions = new ArrayList<S3VersionSummary>();
        ListVersionsRequest listVersionsRequest = new ListVersionsRequest();
        listVersionsRequest.setBucketName(bucket);
        listVersionsRequest.setPrefix(objectKey);
        VersionListing versionList = this.s3Client.listVersions(listVersionsRequest);
        while (true) {
            Iterator versionIter = versionList.getVersionSummaries().iterator();
            ArrayList futures = new ArrayList();
            while (versionIter.hasNext()) {
                S3VersionSummary vs = (S3VersionSummary)versionIter.next();
                versions.add(vs);
            }
            if (!versionList.isTruncated()) break;
            versionList = this.s3Client.listNextBatchOfVersions(versionList);
        }
        return versions;
    }

    @Override
    public void deleteAllVersions(String bucket, String objectKey) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            List<S3VersionSummary> versions = this.listAllVersions(bucket, objectKey);
            for (S3VersionSummary version : versions) {
                this.s3Client.deleteVersion(this.createDeleteVersionRequest(bucket, version));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("HopsFS-Cloud. Deleted version " + version.getVersionId() + " of Object: " + objectKey));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Deleted all versions  of Object: " + objectKey + " Time: " + (System.currentTimeMillis() - startTime) + " ms"));
            }
        }
        catch (AmazonServiceException up) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in deleteAllVersions. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
        catch (SdkClientException up) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in deleteAllVersions. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
    }

    @Override
    public void deleteOldVersions(String bucket, String objectKey) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            List<S3VersionSummary> versions = this.listAllVersions(bucket, objectKey);
            for (S3VersionSummary version : versions) {
                if (version.isLatest()) continue;
                this.s3Client.deleteVersion(this.createDeleteVersionRequest(bucket, version));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("HopsFS-Cloud. Deleted version " + version.getVersionId() + " of Object: " + objectKey));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Deleted all old versions  of Object: " + objectKey + " Time: " + (System.currentTimeMillis() - startTime) + " ms"));
            }
        }
        catch (AmazonServiceException up) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in deleteOldVersions. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
        catch (SdkClientException up) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in deleteOldVersions. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
    }

    private List<ActiveMultipartUploads> listMultipartUploadsForBucket(String bucket, String prefix) throws IOException {
        ArrayList<ActiveMultipartUploads> uploads = new ArrayList<ActiveMultipartUploads>();
        try {
            ListMultipartUploadsRequest request;
            ListMultipartUploadsRequest req = new ListMultipartUploadsRequest(bucket);
            req.setPrefix(prefix);
            MultipartUploadListing uploadListing = this.s3Client.listMultipartUploads(req);
            do {
                for (MultipartUpload upload : uploadListing.getMultipartUploads()) {
                    uploads.add(new S3ActiveMultipartUploads(bucket, upload.getKey(), upload.getInitiated().getTime(), new S3UploadID(upload.getUploadId())));
                }
            } while ((uploadListing = this.s3Client.listMultipartUploads(request = new ListMultipartUploadsRequest(bucket).withUploadIdMarker(uploadListing.getNextUploadIdMarker()).withKeyMarker(uploadListing.getNextKeyMarker()))).isTruncated());
        }
        catch (AmazonServiceException up) {
            LOG.info((Object)("HopsFS-Cloud: AmazonServiceException in listMultipartUploadsForBucket. Bucket: " + bucket + " Prefix: " + prefix + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
        catch (SdkClientException up) {
            LOG.info((Object)("HopsFS-Cloud: SdkClientException in listMultipartUploadsForBucket. Bucket: " + bucket + " Prefix: " + prefix + " Error: " + up.getMessage()));
            throw new IOException(up);
        }
        return uploads;
    }

    public void enableVersioning(String bucket) {
        if (this.versioningEnabled) {
            BucketVersioningConfiguration configuration = new BucketVersioningConfiguration().withStatus("Enabled");
            LOG.info((Object)("HopsFS-Cloud. Enabling Versioning for the bucket: " + bucket));
            SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest = new SetBucketVersioningConfigurationRequest(bucket, configuration);
            this.s3Client.setBucketVersioningConfiguration(setBucketVersioningConfigurationRequest);
        }
    }

    public void enableBucketEncryption(String bucket) {
        if (this.sseEnabled) {
            if (this.sseType.compareToIgnoreCase(CloudS3Encryption.SSE_S3.toString()) == 0 || this.sseType.compareToIgnoreCase(CloudS3Encryption.SSE_KMS.toString()) == 0) {
                ServerSideEncryptionByDefault serverSideEncryptionByDefault = new ServerSideEncryptionByDefault();
                ServerSideEncryptionRule rule = new ServerSideEncryptionRule().withApplyServerSideEncryptionByDefault(serverSideEncryptionByDefault);
                if (this.sseType.compareToIgnoreCase(CloudS3Encryption.SSE_S3.toString()) == 0) {
                    serverSideEncryptionByDefault.withSSEAlgorithm(SSEAlgorithm.AES256);
                } else {
                    serverSideEncryptionByDefault.withSSEAlgorithm(SSEAlgorithm.KMS);
                    rule.withBucketKeyEnabled(Boolean.valueOf(this.sseBucketKeyEnable));
                }
                ServerSideEncryptionConfiguration serverSideEncryptionConfiguration = new ServerSideEncryptionConfiguration().withRules(Collections.singleton(rule));
                SetBucketEncryptionRequest setBucketEncryptionRequest = new SetBucketEncryptionRequest().withServerSideEncryptionConfiguration(serverSideEncryptionConfiguration).withBucketName(bucket);
                this.s3Client.setBucketEncryption(setBucketEncryptionRequest);
            } else {
                throw new IllegalArgumentException("Encryption type (" + this.sseType + ") supported.");
            }
        }
    }

    @Override
    public Object getCloudClient() {
        return this.s3Client;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setUploadHeaders(Object req, ObjectMetadata metadata) throws IOException {
        if (this.sseEnabled) {
            if (this.sseType.compareToIgnoreCase(CloudS3Encryption.SSE_S3.toString()) == 0) {
                metadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
            } else {
                if (this.sseType.compareToIgnoreCase(CloudS3Encryption.SSE_KMS.toString()) != 0) throw new IOException("Encryption type (" + this.sseType + ") supported.");
                if (req instanceof InitiateMultipartUploadRequest) {
                    ((InitiateMultipartUploadRequest)req).withSSEAwsKeyManagementParams(this.getSSEAwsKeyManagementParams());
                    ((InitiateMultipartUploadRequest)req).setBucketKeyEnabled(Boolean.valueOf(this.sseBucketKeyEnable));
                } else if (req instanceof CopyObjectRequest) {
                    ((CopyObjectRequest)req).withSSEAwsKeyManagementParams(this.getSSEAwsKeyManagementParams());
                    ((CopyObjectRequest)req).setBucketKeyEnabled(Boolean.valueOf(this.sseBucketKeyEnable));
                } else {
                    if (!(req instanceof PutObjectRequest)) throw new UnsupportedOperationException("Implement me");
                    ((PutObjectRequest)req).withSSEAwsKeyManagementParams(this.getSSEAwsKeyManagementParams());
                    ((PutObjectRequest)req).setBucketKeyEnabled(Boolean.valueOf(this.sseBucketKeyEnable));
                }
            }
        }
        if (!this.bucketOwnerFullControll.booleanValue()) return;
        if (req instanceof InitiateMultipartUploadRequest) {
            ((InitiateMultipartUploadRequest)req).setCannedACL(CannedAccessControlList.BucketOwnerFullControl);
            return;
        } else if (req instanceof CopyObjectRequest) {
            ((CopyObjectRequest)req).setCannedAccessControlList(CannedAccessControlList.BucketOwnerFullControl);
            return;
        } else {
            if (!(req instanceof PutObjectRequest)) throw new UnsupportedOperationException("Implement me");
            ((PutObjectRequest)req).setCannedAcl(CannedAccessControlList.BucketOwnerFullControl);
        }
    }

    private SSEAwsKeyManagementParams getSSEAwsKeyManagementParams() {
        if (this.sseKeyARN.isEmpty()) {
            return new SSEAwsKeyManagementParams();
        }
        return new SSEAwsKeyManagementParams(this.sseKeyARN);
    }
}

