/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud;

import com.lc.repackaged.com.google.api.gax.paging.Page;
import com.lc.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.lc.repackaged.com.google.cloud.storage.Blob;
import com.lc.repackaged.com.google.cloud.storage.BlobId;
import com.lc.repackaged.com.google.cloud.storage.BlobInfo;
import com.lc.repackaged.com.google.cloud.storage.Bucket;
import com.lc.repackaged.com.google.cloud.storage.BucketInfo;
import com.lc.repackaged.com.google.cloud.storage.Storage;
import com.lc.repackaged.com.google.cloud.storage.StorageException;
import com.lc.repackaged.com.google.cloud.storage.StorageOptions;
import com.lc.repackaged.com.google.common.annotations.VisibleForTesting;
import io.hops.metadata.hdfs.BlockIDAndGSTuple;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.CloudBlock;
import org.apache.hadoop.hdfs.server.common.CloudHelper;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.ActiveMultipartUploads;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudObject;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudPersistenceProvider;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudPersistenceProviderS3Impl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.GCSActiveMultipartUploads;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.GCSPartRef;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.PartRef;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.UploadID;

public class CloudPersistenceProviderGCSImpl
implements CloudPersistenceProvider {
    public static final Log LOG = LogFactory.getLog(CloudPersistenceProviderGCSImpl.class);
    private Storage storage;
    private final Configuration conf;
    private final int numBucketDeletionThreads;
    private final int prefixSize;
    private int numTransferThreads;
    private long partSize;
    private final String bucketLocation;
    private final boolean versioningEnabled;
    private final boolean requesterPays;
    private final String requesterPaysProject;

    public CloudPersistenceProviderGCSImpl(Configuration conf) {
        this.numBucketDeletionThreads = conf.getInt("dfs.nn.max.threads.for.formatting.cloud.buckets", 30);
        this.prefixSize = conf.getInt("dfs.cloud.prefix.size", 500);
        this.numTransferThreads = conf.getInt("dfs.dn.cloud.max.upload.threads", 20);
        if (this.numTransferThreads < 2) {
            LOG.warn((Object)"dfs.dn.cloud.max.upload.threads must be at least 2: forcing to 2.");
            this.numTransferThreads = 2;
        }
        this.partSize = conf.getLong("dfs.cloud.multipart.size", 0x1000000L);
        if (this.partSize < 0x500000L) {
            LOG.error((Object)"dfs.cloud.multipart.size must be at least 5 MB");
            this.partSize = 0x500000L;
        }
        this.bucketLocation = conf.get("dfs.cloud.gcs.bucket.location", "EUROPE-WEST2");
        this.versioningEnabled = conf.getBoolean("gcs.bucket.enable.versioning", false);
        this.requesterPays = conf.getBoolean("dfs.cloud.gcs.bucket.requester.pays", false);
        this.requesterPaysProject = conf.get("dfs.cloud.gcs.bucket.requester.pays.project", "hopsfs");
        if (this.requesterPays && (this.requesterPaysProject == "" || this.requesterPaysProject == null)) {
            throw new IllegalArgumentException("Requster pays option is set. Please specify project name for google cloud.");
        }
        this.conf = conf;
        this.connect();
    }

    private void connect() {
        int retryCount = this.conf.getInt("dfs.cloud.failed.ops.retry.count", 5);
        RetrySettings retrySettings = RetrySettings.newBuilder().setMaxAttempts(retryCount).build();
        ((StorageOptions.Builder)StorageOptions.newBuilder().setRetrySettings(retrySettings)).build();
        this.storage = (Storage)StorageOptions.getDefaultInstance().getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllBuckets(String prefix) throws IOException, ExecutionException, InterruptedException {
        long startTime = System.currentTimeMillis();
        ExecutorService tPool = Executors.newFixedThreadPool(this.numBucketDeletionThreads);
        List<Bucket> buckets = this.listAllBuckets();
        LOG.info((Object)("HopsFS-Cloud. Deleting all of the buckets with prefix \"" + prefix + "\" for this user. Number of deletion threads " + this.numBucketDeletionThreads));
        try {
            for (Bucket b : buckets) {
                if (!b.getName().startsWith(prefix.toLowerCase())) continue;
                this.emptyBucket(b.getName(), false, tPool);
                this.deleteBucket(b.getName());
            }
        }
        finally {
            tPool.shutdown();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud. Deleted all buckets.  Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
    }

    @Override
    public boolean existsCID(String bucket) throws IOException {
        if (!this.bucketExists(bucket)) {
            return false;
        }
        return this.objectExists(bucket, "HOPSFS_CID");
    }

    @Override
    public void setCID(String bucket, String cid) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            if (!this.bucketExists(bucket)) {
                throw new IOException("Bucket " + bucket + " does not exist");
            }
            BlobId blobId = BlobId.of((String)bucket, (String)"HOPSFS_CID");
            BlobInfo objectInfo = BlobInfo.newBuilder((BlobId)blobId).build();
            this.storage.create(objectInfo, cid.getBytes(), this.getBlobTargetOptions(new Storage.BlobTargetOption[0]));
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in setCID, CID: " + cid + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud.  set CID. Bucket: " + bucket + " Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
    }

    @Override
    public String getCID(String bucket) throws IOException {
        long startTime = System.currentTimeMillis();
        String cid = null;
        try {
            if (!this.bucketExists(bucket)) {
                throw new IOException("Bucket " + bucket + " does not exist");
            }
            BlobId blobId = BlobId.of((String)bucket, (String)"HOPSFS_CID");
            byte[] cidBytes = this.storage.readAllBytes(blobId, this.getStorageBlobSourceOptions(new Storage.BlobSourceOption[0]));
            cid = new String(cidBytes);
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in getCID. Bucket: " + bucket + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud.  get CID.  Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
        return cid;
    }

    @Override
    public boolean isEmpty(String bucket) throws IOException {
        if (!this.bucketExists(bucket)) {
            throw new IOException("Bucket " + bucket + " does not exist");
        }
        Page blobs = this.storage.list(bucket, this.getBlobListOptions(new Storage.BlobListOption[0]));
        if (blobs.iterateAll().iterator().hasNext()) {
            return false;
        }
        return !this.versioningEnabled || !(blobs = this.storage.list(bucket, this.getBlobListOptions(Storage.BlobListOption.versions((boolean)true)))).iterateAll().iterator().hasNext();
    }

    private List<Bucket> listAllBuckets() {
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        Page bucketPage = this.storage.list(this.getBucketListOption(new Storage.BucketListOption[0]));
        while (true) {
            for (Bucket bucket : bucketPage.iterateAll()) {
                buckets.add(bucket);
            }
            if (!bucketPage.hasNextPage()) break;
            bucketPage = bucketPage.getNextPage();
        }
        return buckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(List<String> buckets) throws IOException {
        System.out.println("HopsFS-Cloud. Deleting all of the buckets used by HopsFS.");
        ExecutorService tPool = Executors.newFixedThreadPool(this.numBucketDeletionThreads);
        try {
            for (String bucket : buckets) {
                if (this.versioningEnabled && !this.isVersioningSupported(bucket)) {
                    throw new IOException("Cannot format file system. Versioning is enabled. However the bucket does not support versioning");
                }
                this.emptyBucket(bucket, true, tPool);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn((Object)e);
        }
        finally {
            tPool.shutdown();
        }
    }

    private void deleteBucket(String bucketName) throws IOException {
        LOG.info((Object)("HopsFS-Cloud. Deleting bucket " + bucketName));
        boolean deleted = this.storage.delete(bucketName, this.getBucketSourceOptions(new Storage.BucketSourceOption[0]));
        if (!deleted) {
            throw new IOException("Unable to delete the bucket: " + bucketName + " Bucket Not Found");
        }
    }

    private void emptyBucket(String bucketName, boolean onlyDeleteHopsFSData, ExecutorService tPool) throws IOException, ExecutionException, InterruptedException {
        final AtomicInteger deletedBlocks = new AtomicInteger(0);
        if (!this.bucketExists(bucketName)) {
            throw new IOException("Cannot format file system. The bucket does not exist");
        }
        try {
            ArrayList<Future<Object>> futures;
            Page blobs = this.storage.list(bucketName, this.getBlobListOptions(new Storage.BlobListOption[0]));
            while (true) {
                Blob blob22;
                futures = new ArrayList<Future<Object>>();
                for (final Blob blob22 : blobs.iterateAll()) {
                    if (onlyDeleteHopsFSData && !blob22.getName().startsWith("hopsfs-blocks-set-")) continue;
                    Callable<Object> callable = new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            blob22.delete(CloudPersistenceProviderGCSImpl.this.getBlobSourceOptions(new Blob.BlobSourceOption[0]));
                            String msg = "\rDeleted Blocks: " + deletedBlocks.incrementAndGet();
                            System.out.print(msg);
                            return null;
                        }
                    };
                    futures.add(tPool.submit(callable));
                }
                blob22 = futures.iterator();
                while (blob22.hasNext()) {
                    Future future = (Future)blob22.next();
                    future.get();
                }
                if (!blobs.hasNextPage()) break;
                blobs = blobs.getNextPage();
            }
            blobs = this.storage.list(bucketName, this.getBlobListOptions(Storage.BlobListOption.versions((boolean)true)));
            while (true) {
                futures = new ArrayList();
                for (final Blob blob : blobs.iterateAll()) {
                    if (onlyDeleteHopsFSData && !blob.getName().startsWith("hopsfs-blocks-set-")) continue;
                    Callable<Object> callable = new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            blob.delete(CloudPersistenceProviderGCSImpl.this.getBlobSourceOptions(new Blob.BlobSourceOption[0]));
                            String msg = "\rDeleted Block versions: " + deletedBlocks.incrementAndGet();
                            System.out.print(msg);
                            return null;
                        }
                    };
                    futures.add(tPool.submit(callable));
                }
                for (Future future : futures) {
                    future.get();
                }
                if (!blobs.hasNextPage()) break;
                blobs = blobs.getNextPage();
            }
            if (this.objectExists(bucketName, "HOPSFS_CID")) {
                BlobId blobId = BlobId.of((String)bucketName, (String)"HOPSFS_CID");
                this.storage.delete(blobId, this.getStorageBlobSourceOptions(new Storage.BlobSourceOption[0]));
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in emptyAndDeleteBucket. Error:  Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public boolean bucketExists(String bucketName) throws IOException {
        try {
            Bucket bucket = this.storage.get(bucketName, this.getBucketGetOptions(new Storage.BucketGetOption[0]));
            if (bucket == null) {
                return false;
            }
            return bucket.exists(new Bucket.BucketSourceOption[0]);
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in bucketExists, Bucket: " + bucketName + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public void createBucket(String bucketName) throws IOException {
        try {
            if (!this.bucketExists(bucketName)) {
                BucketInfo.Builder bucketInfoBuilder = BucketInfo.newBuilder((String)bucketName).setLocation(this.bucketLocation);
                if (this.requesterPays) {
                    bucketInfoBuilder.setRequesterPays(Boolean.valueOf(this.requesterPays));
                }
                BucketInfo bucketInfo = bucketInfoBuilder.build();
                this.storage.create(bucketInfo, this.getBucketTargetOptions(new Storage.BucketTargetOption[0]));
                this.enableVersioning(bucketName);
            } else {
                LOG.info((Object)("HopsFS-Cloud. Bucket already exists. Bucket Name: " + bucketName));
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in createBucket, Bucket: " + bucketName + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    public void enableVersioning(String bucketName) {
        if (this.versioningEnabled) {
            Bucket bucket = this.storage.get(bucketName, this.getBucketGetOptions(new Storage.BucketGetOption[0]));
            bucket.toBuilder().setVersioningEnabled(Boolean.valueOf(true)).build().update(new Storage.BucketTargetOption[0]);
        }
    }

    @Override
    public void checkAllBuckets(List<String> buckets) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            int retry = 300;
            for (String bucketStr : buckets) {
                LOG.debug((Object)("Checking bucket: " + bucketStr));
                boolean exists = this.bucketExists(bucketStr);
                if (!exists) {
                    throw new IllegalStateException("GCS Bucket " + bucketStr + " needed for the file system does not exists");
                }
                UUID uuid = UUID.randomUUID();
                File file1 = new File("/tmp/" + uuid);
                File file2 = new File("/tmp/" + uuid + ".downloaded");
                try {
                    String message = "hello! hello! testing! testing! testing 1 2  3!";
                    FileWriter fw = new FileWriter(file1);
                    fw.write(message);
                    fw.close();
                    BlobId blobId = BlobId.of((String)bucketStr, (String)uuid.toString());
                    Blob upBlob = this.storage.get(blobId, this.getBlobGetOptions(new Storage.BlobGetOption[0]));
                    assert (upBlob == null);
                    BlobInfo objectInfo = BlobInfo.newBuilder((BlobId)blobId).build();
                    this.storage.create(objectInfo, Files.readAllBytes(Paths.get(file1.getAbsolutePath(), new String[0])), this.getBlobTargetOptions(new Storage.BlobTargetOption[0]));
                    Blob downBlob = this.storage.get(blobId);
                    downBlob.downloadTo(Paths.get(file2.getAbsolutePath(), new String[0]));
                    this.storage.delete(BlobId.of((String)bucketStr, (String)uuid.toString()), this.getStorageBlobSourceOptions(new Storage.BlobSourceOption[0]));
                    assert (FileUtils.contentEquals((File)file1, (File)file2));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Write test for GCS bucket: " + bucketStr + " failed. " + e);
                }
                finally {
                    file1.delete();
                    file2.delete();
                }
            }
            LOG.info((Object)("HopsFS-Cloud. Check all buckets: " + Arrays.toString(buckets.toArray()) + " Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in checkAllBuckets, Buckets: " + Arrays.toString(buckets.toArray()) + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public int getPrefixSize() {
        return this.prefixSize;
    }

    @Override
    public void uploadObject(String bucket, String objectKey, File object, Map<String, String> metadata) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            LOG.info((Object)("HopsFS-Cloud. Put Object. Bucket: " + bucket + " Object Key: " + objectKey + "  Object Size: " + objectKey.length()));
            BlobId blobId = BlobId.of((String)bucket, (String)objectKey);
            BlobInfo objectInfo = BlobInfo.newBuilder((BlobId)blobId).build();
            Blob upBlob = this.storage.create(objectInfo, Files.readAllBytes(Paths.get(object.getAbsolutePath(), new String[0])), this.getBlobTargetOptions(new Storage.BlobTargetOption[0]));
            if (metadata != null) {
                upBlob.toBuilder().setMetadata(metadata).build().update(new Storage.BlobTargetOption[0]);
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in uploadObject. Bucket: " + bucket + " Key: " + objectKey + " File: " + object.getAbsolutePath() + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud.  Upload object. Bucket: " + bucket + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
    }

    @Override
    public boolean objectExists(String bucket, String objectKey) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            BlobId blobId = BlobId.of((String)bucket, (String)objectKey);
            Blob blob = this.storage.get(blobId, this.getBlobGetOptions(new Storage.BlobGetOption[0]));
            boolean objExists = false;
            if (blob != null) {
                objExists = blob.exists(new Blob.BlobSourceOption[0]);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Object Exists. Bucket: " + bucket + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
            return objExists;
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in objectExists. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public Map<String, String> getUserMetaData(String bucket, String objectKey) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            BlobId blobId = BlobId.of((String)bucket, (String)objectKey);
            Blob blob = this.storage.get(blobId, this.getBlobGetOptions(new Storage.BlobGetOption[0]));
            if (blob == null) {
                throw new IOException("Object: " + objectKey + " not found in the bucket: " + bucket);
            }
            HashMap<String, String> metadata = blob.getMetadata();
            if (metadata == null) {
                metadata = new HashMap<String, String>();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Get Metadata. Bucket: " + bucket + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
            return metadata;
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in getUserMetaData. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public long getObjectSize(String bucket, String objectKey) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            BlobId blobId = BlobId.of((String)bucket, (String)objectKey);
            Blob blob = this.storage.get(blobId, this.getBlobGetOptions(new Storage.BlobGetOption[0]));
            if (blob == null) {
                throw new IOException("Object: " + objectKey + " not found in the bucket: " + bucket);
            }
            long objSize = blob.getSize();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Get object size. Bucket: " + bucket + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
            return objSize;
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in getObjectSize. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public void downloadObject(String bucket, String objectKey, File path) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            BlobId blobId;
            Blob blob;
            if (path.exists()) {
                path.delete();
            } else if (!path.getParentFile().exists()) {
                path.getParentFile().mkdirs();
            }
            Random rand = new Random(System.currentTimeMillis());
            File tmpFile = new File(path.getAbsolutePath() + "." + rand.nextLong() + ".downloading");
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            if ((blob = this.storage.get(blobId = BlobId.of((String)bucket, (String)objectKey), this.getBlobGetOptions(new Storage.BlobGetOption[0]))) == null) {
                throw new IOException("Object: " + objectKey + " not found in the bucket: " + bucket);
            }
            blob.downloadTo(Paths.get(tmpFile.getAbsolutePath(), new String[0]));
            tmpFile.renameTo(path);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Download object. Bucket: " + bucket + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in downloadObject Bucket: " + bucket + " ObjKey: " + objectKey + " File: " + path.getAbsolutePath() + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public void deleteObject(String bucket, String objectKey) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            BlobId blobId = BlobId.of((String)bucket, (String)objectKey);
            if (!this.storage.delete(blobId, this.getStorageBlobSourceOptions(new Storage.BlobSourceOption[0]))) {
                throw new IOException("Object: " + objectKey + " not found in the bucket: " + bucket);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Delete Object. Bucket: " + bucket + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in deleteObject. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    @VisibleForTesting
    public void renameObject(String srcBucket, String dstBucket, String srcKey, String dstKey) throws IOException {
        long startTime = System.currentTimeMillis();
        this.copyObject(srcBucket, dstBucket, srcKey, dstKey, null);
        try {
            BlobId srcBlobId = BlobId.of((String)srcBucket, (String)srcKey);
            this.storage.delete(srcBlobId, this.getStorageBlobSourceOptions(new Storage.BlobSourceOption[0]));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Rename Object. Src Bucket: " + srcBucket + " Src Object Key: " + srcKey + " Dst Bucket: " + dstBucket + " Dst Object Key: " + dstKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in renameObject  Src Bucket: " + srcBucket + " Dst Bucket: " + dstBucket + " SrcKey: " + srcKey + " DstKey: " + dstKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public void copyObject(String srcBucket, String dstBucket, String srcKey, String dstKey, Map<String, String> newObjMetadata) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            BlobId srcBlobId = BlobId.of((String)srcBucket, (String)srcKey);
            Blob blob = this.storage.get(srcBlobId, this.getBlobGetOptions(new Storage.BlobGetOption[0]));
            if (blob == null) {
                throw new IOException("Object: " + srcKey + " not found in the bucket: " + srcBucket);
            }
            BlobId dstBlobId = BlobId.of((String)dstBucket, (String)dstKey);
            blob.copyTo(dstBlobId, new Blob.BlobSourceOption[0]);
            if (newObjMetadata != null) {
                Blob newBlob = this.storage.get(dstBlobId, this.getBlobGetOptions(new Storage.BlobGetOption[0]));
                newBlob.toBuilder().setMetadata(newObjMetadata).build().update(new Storage.BlobTargetOption[0]);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Copy Object. Src Bucket: " + srcBucket + " Src Object Key: " + srcKey + " Dst Bucket: " + dstBucket + " Dst Object Key: " + dstKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in  copyObject  Src Bucket: " + srcBucket + " Dst Bucket: " + dstBucket + " SrcKey: " + srcKey + " DstKey: " + dstKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public Map<BlockIDAndGSTuple, CloudBlock> getAll(String prefix, List<String> buckets) throws IOException {
        long startTime = System.currentTimeMillis();
        HashMap<BlockIDAndGSTuple, CloudBlock> allBlocks = new HashMap<BlockIDAndGSTuple, CloudBlock>();
        try {
            for (String b : buckets) {
                this.getAllInt(allBlocks, b, prefix);
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in  getAll.  Prefix: " + prefix + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud. Get all objects. Buckets: " + Arrays.toString(buckets.toArray()) + "  Prefix:" + prefix + " Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
        return allBlocks;
    }

    private void getAllInt(Map<BlockIDAndGSTuple, CloudBlock> blocks, String bucketStr, String prefix) throws IOException {
        try {
            HashMap<BlockIDAndGSTuple, CloudObject> blockObjs = new HashMap<BlockIDAndGSTuple, CloudObject>();
            HashMap<BlockIDAndGSTuple, CloudObject> metaObjs = new HashMap<BlockIDAndGSTuple, CloudObject>();
            Bucket bucket = this.storage.get(bucketStr, this.getBucketGetOptions(new Storage.BucketGetOption[0]));
            Page page = bucket.list(this.getBlobListOptions(Storage.BlobListOption.prefix((String)prefix)));
            while (true) {
                for (Blob blob : page.iterateAll()) {
                    this.processListBlob(blockObjs, metaObjs, blob);
                }
                if (!page.hasNextPage()) break;
                page = page.getNextPage();
            }
            CloudPersistenceProviderS3Impl.mergeMetaAndBlockObjects(metaObjs, blockObjs, blocks);
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in  getAllInt.  Prefix: " + prefix + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    private void processListBlob(Map<BlockIDAndGSTuple, CloudObject> blockObjs, Map<BlockIDAndGSTuple, CloudObject> metaObjs, Blob blob) {
        if (CloudHelper.isPartialGCSFile(blob.getName())) {
            return;
        }
        String key = blob.getName();
        CloudObject co = new CloudObject();
        co.setBucket(blob.getBucket());
        co.setKey(key);
        co.setSize(blob.getSize());
        co.setLastModifiedTime(blob.getUpdateTime());
        BlockIDAndGSTuple idAndGS = CloudHelper.getIDAndGSFromKey(key);
        if (idAndGS != null && CloudHelper.isBlockFilename(key)) {
            blockObjs.put(idAndGS, co);
        } else if (idAndGS != null || CloudHelper.isMetaFilename(key)) {
            metaObjs.put(idAndGS, co);
        } else {
            LOG.warn((Object)("HopsFS-Cloud. File system objects are tampered. The " + key + " is not HopsFS object."));
        }
    }

    @Override
    public List<String> getAllHopsFSDirectories(List<String> buckets) throws IOException {
        long startTime = System.currentTimeMillis();
        ArrayList<String> dirs = new ArrayList<String>();
        try {
            for (String b : buckets) {
                this.getAllDirectoriesInt(b, dirs);
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in getAllDirectories Bucket: " + Arrays.toString(buckets.toArray()) + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud. Get all directories. Buckets: " + Arrays.toString(buckets.toArray()) + "  Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
        return dirs;
    }

    private void getAllDirectoriesInt(String bucketStr, List<String> dirs) throws IOException {
        Bucket bucket = this.storage.get(bucketStr, this.getBucketGetOptions(new Storage.BucketGetOption[0]));
        Page page = bucket.list(this.getBlobListOptions(Storage.BlobListOption.prefix((String)""), Storage.BlobListOption.currentDirectory()));
        while (true) {
            for (Blob blob : page.iterateAll()) {
                if (!blob.getName().contains("hopsfs-blocks-set-")) continue;
                dirs.add(blob.getName());
            }
            if (!page.hasNextPage()) break;
            page = page.getNextPage();
        }
    }

    @Override
    public long getPartSize() {
        return this.partSize;
    }

    @Override
    public int getXferThreads() {
        return this.numTransferThreads;
    }

    @Override
    public UploadID startMultipartUpload(String bucket, String objectKey, Map<String, String> metadata) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"HopsFS-Cloud. Starting Multipart Upload.");
        }
        return null;
    }

    @Override
    public PartRef uploadPart(String bucket, String objectKey, UploadID uploadID, int partNo, File file, long startPos, long endPos) throws IOException {
        long startTime = System.currentTimeMillis();
        String objectName = objectKey.substring(objectKey.lastIndexOf(47) + 1);
        String dir = objectKey.substring(0, objectKey.lastIndexOf(47));
        String key = dir + "/" + "partial-blocks" + "/" + objectName + ".part_" + partNo;
        try {
            byte[] partData = new byte[(int)(endPos - startPos)];
            RandomAccessFile input = new RandomAccessFile(file, "r");
            input.seek(startPos);
            input.readFully(partData);
            input.close();
            BlobId blobId = BlobId.of((String)bucket, (String)key);
            BlobInfo objectInfo = BlobInfo.newBuilder((BlobId)blobId).build();
            Blob upBlob = this.storage.create(objectInfo, partData, this.getBlobTargetOptions(new Storage.BlobTargetOption[0]));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud.  Upload object part. Bucket: " + bucket + " Object Key: " + key + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
            return new GCSPartRef(partNo, key);
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in uploadPart. Bucket: " + bucket + " ObjKey: " + objectKey + " UploadID: " + uploadID.toString() + " Part No:" + partNo + " File: " + file.getAbsolutePath() + " Start Pos: " + startPos + " End Pos: " + endPos + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public void finalizeMultipartUpload(String bucket, String objectKey, UploadID uploadID, List<PartRef> parts) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            PartRef part;
            BlobId blobId = BlobId.of((String)bucket, (String)objectKey);
            BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).build();
            Storage.ComposeRequest.Builder requestBuilder = Storage.ComposeRequest.newBuilder();
            requestBuilder.setTarget(blobInfo);
            requestBuilder.setTargetOptions(this.getBlobTargetOptions(new Storage.BlobTargetOption[0]));
            for (PartRef p : parts) {
                part = (GCSPartRef)p;
                requestBuilder.addSource(new String[]{((GCSPartRef)part).getKey()});
            }
            this.storage.compose(requestBuilder.build());
            if (this.versioningEnabled) {
                for (PartRef part2 : parts) {
                    GCSPartRef gcsPart = (GCSPartRef)part2;
                    this.deleteAllVersions(bucket, gcsPart.getKey());
                }
            } else {
                ArrayList<BlobId> toDelete = new ArrayList<BlobId>();
                Iterator<PartRef> iterator = parts.iterator();
                while (iterator.hasNext()) {
                    PartRef gcsPart = part = iterator.next();
                    toDelete.add(BlobId.of((String)bucket, (String)((GCSPartRef)gcsPart).getKey()));
                }
                this.storage.delete(toDelete);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud.  Finalize multipart upload. Bucket: " + bucket + " Object Key: " + objectKey + " Parts: " + Arrays.toString(parts.toArray()) + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in finalizeMultipartUpload. Bucket: " + bucket + " ObjKey: " + objectKey + " UploadID: " + uploadID.toString() + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public void abortMultipartUpload(String bucket, String objectKey, UploadID uploadID) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            String objectName = objectKey.substring(objectKey.lastIndexOf(47) + 1);
            String dir = objectKey.substring(0, objectKey.lastIndexOf(47));
            String prefix = dir + "/" + "partial-blocks" + "/" + objectName;
            StringBuilder deleteMsg = new StringBuilder();
            List<Blob> blobs = this.listPrefix(bucket, prefix);
            for (Blob b : blobs) {
                this.deleteObject(bucket, b.getName());
                deleteMsg.append(b.getName()).append(", ");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud.  Abort multipart upload. Bucket: " + bucket + " Object Key: " + objectKey + " Parts Prefix: " + prefix + " Parts: [" + deleteMsg + "] Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in abortMultipartUpload. Bucket: " + bucket + " ObjKey: " + objectKey + " UploadID: " + uploadID.toString() + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    private Map<BlockIDAndGSTuple, List<Blob>> listPartialBlocks(List<String> buckets, String prefix) throws IOException {
        HashMap<BlockIDAndGSTuple, List<Blob>> blobsMap = new HashMap<BlockIDAndGSTuple, List<Blob>>();
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (String bucket : buckets) {
            blobs.addAll(this.listPrefix(bucket, prefix));
        }
        for (Blob b : blobs) {
            if (!CloudHelper.isPartialGCSFile(b.getName())) {
                LOG.warn((Object)("HopsFS-Cloud. Unrecognized object: " + b.getName() + " search prefix \"" + prefix + "\""));
                continue;
            }
            BlockIDAndGSTuple id = CloudHelper.getIDAndGSFromKey(b.getName());
            ArrayList<Blob> blobList = (ArrayList<Blob>)blobsMap.get(id);
            if (blobList == null) {
                blobList = new ArrayList<Blob>();
            }
            blobList.add(b);
            blobsMap.put(id, blobList);
        }
        return blobsMap;
    }

    private List<Blob> listPrefix(String bucketStr, String prefix) throws IOException {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        try {
            Bucket bucket = this.storage.get(bucketStr, this.getBucketGetOptions(new Storage.BucketGetOption[0]));
            Page page = bucket.list(this.getBlobListOptions(Storage.BlobListOption.prefix((String)prefix)));
            while (true) {
                for (Blob blob : page.iterateAll()) {
                    blobs.add(blob);
                }
                if (page.hasNextPage()) {
                    page = page.getNextPage();
                    continue;
                }
                break;
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in listPrefix. Bucket: " + bucketStr + " Prefix: " + prefix + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        return blobs;
    }

    @Override
    public List<ActiveMultipartUploads> listMultipartUploads(List<String> buckets, String prefix) throws IOException {
        long startTime = System.currentTimeMillis();
        Map<BlockIDAndGSTuple, List<Blob>> blocksMap = this.listPartialBlocks(buckets, prefix);
        ArrayList<ActiveMultipartUploads> blocksList = new ArrayList<ActiveMultipartUploads>();
        for (BlockIDAndGSTuple key : blocksMap.keySet()) {
            List<Blob> parts = blocksMap.get(key);
            blocksList.add(new GCSActiveMultipartUploads(key, parts));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud.  List multipart uploads. Buckets: " + Arrays.toString(buckets.toArray()) + " Prefix: " + prefix + " Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
        return blocksList;
    }

    @Override
    public boolean restoreDeletedBlock(String bucket, String objectKey) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            List<Blob> versions = this.listAllVersions(bucket, objectKey);
            boolean restored = false;
            if (versions.size() == 0) {
                restored = false;
            } else {
                Blob latestVersion = versions.get(versions.size() - 1);
                if (latestVersion.getDeleteTime() == null) {
                    restored = false;
                } else {
                    Storage.CopyRequest copyRequest = Storage.CopyRequest.newBuilder().setSource(BlobId.of((String)bucket, (String)objectKey, (Long)latestVersion.getGeneration())).setTarget(BlobId.of((String)bucket, (String)objectKey), this.getBlobTargetOptions(new Storage.BlobTargetOption[0])).setSourceOptions(this.getStorageBlobSourceOptions(new Storage.BlobSourceOption[0])).build();
                    this.storage.copy(copyRequest);
                    latestVersion.delete(new Blob.BlobSourceOption[0]);
                    restored = true;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud.  Restore deleted version. Bucket: " + bucket + " Key: " + objectKey + " Success: " + restored + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
            return restored;
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in restoreDeletedBlock. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public boolean isVersioningSupported(String bucketStr) throws IOException {
        if (!this.versioningEnabled) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        try {
            Bucket bucket = this.storage.get(bucketStr, this.getBucketGetOptions(new Storage.BucketGetOption[0]));
            Boolean versioning = bucket.versioningEnabled();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud.  Is versioning supported. Bucket: " + bucket + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
            if (versioning != null) {
                return versioning;
            }
            return false;
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in isVersioningSupported. Bucket: " + bucketStr + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public void deleteAllVersions(String bucket, String objectKey) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            Page page = this.storage.list(bucket, this.getBlobListOptions(Storage.BlobListOption.prefix((String)objectKey), Storage.BlobListOption.versions((boolean)true)));
            while (true) {
                for (Blob blob : page.iterateAll()) {
                    blob.delete(this.getBlobSourceOptions(new Blob.BlobSourceOption[0]));
                }
                if (!page.hasNextPage()) break;
                page = page.getNextPage();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud.  Delete all versions. Bucket: " + bucket + " Object key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in deleteAllVersions. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public void deleteOldVersions(String bucket, String objectKey) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            List<Blob> versions = this.listAllVersions(bucket, objectKey);
            if (versions.size() == 0) {
                throw new IOException("No versions found");
            }
            for (int i = 0; i < versions.size() - 1; ++i) {
                Blob version = versions.get(i);
                version.delete(this.getBlobSourceOptions(new Blob.BlobSourceOption[0]));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("HopsFS-Cloud. Deleted version " + version.getGeneration() + " of Object: " + objectKey));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Deleted all old versions  of Object: " + objectKey + " Time: " + (System.currentTimeMillis() - startTime) + " ms"));
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in deleteOldVersion. Bucket: " + bucket + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    public List<Blob> listAllVersions(String bucket, String prefix) throws IOException {
        HashMap<Long, Blob> versionsMap = new HashMap<Long, Blob>();
        try {
            Page page = this.storage.list(bucket, this.getBlobListOptions(Storage.BlobListOption.prefix((String)prefix), Storage.BlobListOption.versions((boolean)true), Storage.BlobListOption.pageSize((long)5L)));
            while (true) {
                for (Blob blob : page.iterateAll()) {
                    versionsMap.put(blob.getGeneration(), blob);
                }
                if (page.hasNextPage()) {
                    page = page.getNextPage();
                    continue;
                }
                break;
            }
        }
        catch (StorageException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in listAllVersions. Bucket: " + bucket + " ObjKey: " + prefix + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        ArrayList<Blob> versions = new ArrayList<Blob>(versionsMap.values());
        Collections.sort(versions, new Comparator<Blob>(){

            @Override
            public int compare(Blob o1, Blob o2) {
                return Long.compare(o1.getUpdateTime(), o2.getUpdateTime());
            }
        });
        return versions;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Object getCloudClient() {
        return this.storage;
    }

    private Storage.BucketListOption[] getBucketListOption(Storage.BucketListOption ... options) {
        ArrayList<Storage.BucketListOption> optionsList = new ArrayList<Storage.BucketListOption>();
        for (Storage.BucketListOption opt : options) {
            optionsList.add(opt);
        }
        if (this.requesterPays) {
            optionsList.add(Storage.BucketListOption.userProject((String)this.requesterPaysProject));
        }
        return optionsList.toArray(new Storage.BucketListOption[optionsList.size()]);
    }

    private Storage.BlobListOption[] getBlobListOptions(Storage.BlobListOption ... options) {
        ArrayList<Storage.BlobListOption> optionsList = new ArrayList<Storage.BlobListOption>();
        for (Storage.BlobListOption opt : options) {
            optionsList.add(opt);
        }
        if (this.requesterPays) {
            optionsList.add(Storage.BlobListOption.userProject((String)this.requesterPaysProject));
        }
        return optionsList.toArray(new Storage.BlobListOption[optionsList.size()]);
    }

    private Storage.BucketSourceOption[] getBucketSourceOptions(Storage.BucketSourceOption ... options) {
        ArrayList<Storage.BucketSourceOption> optionsList = new ArrayList<Storage.BucketSourceOption>();
        for (Storage.BucketSourceOption opt : options) {
            optionsList.add(opt);
        }
        if (this.requesterPays) {
            optionsList.add(Storage.BucketSourceOption.userProject((String)this.requesterPaysProject));
        }
        return optionsList.toArray(new Storage.BucketSourceOption[optionsList.size()]);
    }

    private Storage.BucketGetOption[] getBucketGetOptions(Storage.BucketGetOption ... options) {
        ArrayList<Storage.BucketGetOption> optionsList = new ArrayList<Storage.BucketGetOption>();
        for (Storage.BucketGetOption opt : options) {
            optionsList.add(opt);
        }
        if (this.requesterPays) {
            optionsList.add(Storage.BucketGetOption.userProject((String)this.requesterPaysProject));
        }
        return optionsList.toArray(new Storage.BucketGetOption[optionsList.size()]);
    }

    private Storage.BucketTargetOption[] getBucketTargetOptions(Storage.BucketTargetOption ... options) {
        ArrayList<Storage.BucketTargetOption> optionsList = new ArrayList<Storage.BucketTargetOption>();
        for (Storage.BucketTargetOption opt : options) {
            optionsList.add(opt);
        }
        if (this.requesterPays) {
            optionsList.add(Storage.BucketTargetOption.userProject((String)this.requesterPaysProject));
        }
        return optionsList.toArray(new Storage.BucketTargetOption[optionsList.size()]);
    }

    private Storage.BlobGetOption[] getBlobGetOptions(Storage.BlobGetOption ... options) {
        ArrayList<Storage.BlobGetOption> optionsList = new ArrayList<Storage.BlobGetOption>();
        for (Storage.BlobGetOption opt : options) {
            optionsList.add(opt);
        }
        if (this.requesterPays) {
            optionsList.add(Storage.BlobGetOption.userProject((String)this.requesterPaysProject));
        }
        return optionsList.toArray(new Storage.BlobGetOption[optionsList.size()]);
    }

    private Storage.BlobTargetOption[] getBlobTargetOptions(Storage.BlobTargetOption ... options) {
        ArrayList<Storage.BlobTargetOption> optionsList = new ArrayList<Storage.BlobTargetOption>();
        for (Storage.BlobTargetOption opt : options) {
            optionsList.add(opt);
        }
        if (this.requesterPays) {
            optionsList.add(Storage.BlobTargetOption.userProject((String)this.requesterPaysProject));
        }
        return optionsList.toArray(new Storage.BlobTargetOption[optionsList.size()]);
    }

    private Storage.BlobSourceOption[] getStorageBlobSourceOptions(Storage.BlobSourceOption ... options) {
        ArrayList<Storage.BlobSourceOption> optionsList = new ArrayList<Storage.BlobSourceOption>();
        for (Storage.BlobSourceOption opt : options) {
            optionsList.add(opt);
        }
        if (this.requesterPays) {
            optionsList.add(Storage.BlobSourceOption.userProject((String)this.requesterPaysProject));
        }
        return optionsList.toArray(new Storage.BlobSourceOption[optionsList.size()]);
    }

    private Blob.BlobSourceOption[] getBlobSourceOptions(Blob.BlobSourceOption ... options) {
        ArrayList<Blob.BlobSourceOption> optionsList = new ArrayList<Blob.BlobSourceOption>();
        for (Blob.BlobSourceOption opt : options) {
            optionsList.add(opt);
        }
        if (this.requesterPays) {
            optionsList.add(Blob.BlobSourceOption.userProject((String)this.requesterPaysProject));
        }
        return optionsList.toArray(new Blob.BlobSourceOption[optionsList.size()]);
    }
}

