/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CloudProvider;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudPersistenceProvider;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudPersistenceProviderAzureImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudPersistenceProviderGCSImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudPersistenceProviderS3Impl;

public class CloudPersistenceProviderFactory {
    public static CloudPersistenceProvider getCloudClient(Configuration conf) throws IOException {
        String cloudProvider = conf.get("dfs.cloud.provider", "AWS");
        if (cloudProvider.compareToIgnoreCase(CloudProvider.AWS.name()) == 0) {
            return new CloudPersistenceProviderS3Impl(conf);
        }
        if (cloudProvider.compareToIgnoreCase(CloudProvider.AZURE.name()) == 0) {
            return new CloudPersistenceProviderAzureImpl(conf);
        }
        if (cloudProvider.compareToIgnoreCase(CloudProvider.GCS.name()) == 0) {
            return new CloudPersistenceProviderGCSImpl(conf);
        }
        throw new UnsupportedOperationException("Cloud provider '" + cloudProvider + "' is not supported");
    }
}

