/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud;

import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.AzureException;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.util.BinaryData;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobRetentionPolicy;
import com.azure.storage.blob.models.BlobServiceProperties;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.ListBlobContainersOptions;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.RetryPolicyType;
import com.google.common.annotations.VisibleForTesting;
import io.hops.metadata.hdfs.BlockIDAndGSTuple;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.CloudBlock;
import org.apache.hadoop.hdfs.server.common.CloudHelper;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.ActiveMultipartUploads;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.AzurePartRef;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.BlockMovedToColdStorageException;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudObject;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudPersistenceProvider;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudPersistenceProviderS3Impl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.PartRef;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.UploadID;

public class CloudPersistenceProviderAzureImpl
implements CloudPersistenceProvider {
    public static final Log LOG = LogFactory.getLog(CloudPersistenceProviderAzureImpl.class);
    BlobServiceClient blobClient;
    private final Configuration conf;
    private final int prefixSize;
    private int maxThreads;
    private long partSize;
    private final int bucketDeletionThreads;
    private final boolean softDeletesEnabled;

    public CloudPersistenceProviderAzureImpl(Configuration conf) throws IOException {
        this.conf = conf;
        String storageConnectionString = null;
        String storageName = null;
        String containerName = null;
        String clientID = null;
        if (System.getenv("AZURE_STORAGE_CONNECTION_STRING") != null) {
            storageConnectionString = System.getenv("AZURE_STORAGE_CONNECTION_STRING");
        } else {
            containerName = conf.get("dfs.cloud.azure.container", "");
            storageName = conf.get("dfs.cloud.azure.storage", "");
            clientID = conf.get("dfs.azure.mgm.identity.client.id", "");
            if (containerName == null || containerName.compareTo("") == 0 || storageName == null || storageName.compareTo("") == 0) {
                throw new IllegalArgumentException("Azure storage name or container name  is not set properly");
            }
        }
        this.prefixSize = conf.getInt("dfs.cloud.prefix.size", 500);
        this.maxThreads = conf.getInt("dfs.dn.cloud.max.upload.threads", 20);
        if (this.maxThreads < 2) {
            LOG.warn((Object)"dfs.dn.cloud.max.upload.threads must be at least 2: forcing to 2.");
            this.maxThreads = 2;
        }
        this.partSize = conf.getLong("dfs.cloud.multipart.size", 0x1000000L);
        if (this.partSize < 0x500000L) {
            LOG.error((Object)"dfs.cloud.multipart.size must be at least 5 MB");
            this.partSize = 0x500000L;
        }
        int retryCount = conf.getInt("dfs.cloud.failed.ops.retry.count", 5);
        this.bucketDeletionThreads = conf.getInt("dfs.nn.max.threads.for.formatting.cloud.buckets", 30);
        this.softDeletesEnabled = conf.getBoolean("azure.enable.soft.deletes", false);
        try {
            RequestRetryOptions retryOptions = new RequestRetryOptions(RetryPolicyType.EXPONENTIAL, Integer.valueOf(retryCount), (Integer)null, null, null, null);
            BlobServiceClientBuilder builder = new BlobServiceClientBuilder();
            if (storageConnectionString != null) {
                LOG.info((Object)"HopsFS-Cloud. Connection connection string");
                builder.connectionString(storageConnectionString);
            } else {
                LOG.info((Object)"HopsFS-Cloud. Connection using managed identities");
                builder.endpoint("https://" + storageName + ".blob.core.windows.net/" + containerName);
                DefaultAzureCredentialBuilder credentialBuilder = new DefaultAzureCredentialBuilder();
                if (clientID != null && clientID.compareTo("") != 0) {
                    LOG.info((Object)("Using managed identity with client ID: " + clientID));
                    credentialBuilder.managedIdentityClientId(clientID);
                }
                builder.credential((TokenCredential)credentialBuilder.build());
            }
            this.blobClient = builder.retryOptions(retryOptions).buildClient();
            LOG.info((Object)"Azure Connected ");
        }
        catch (AzureException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteAllBuckets(String prefix) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            ListBlobContainersOptions options = new ListBlobContainersOptions();
            options.setPrefix(prefix.toLowerCase());
            for (BlobContainerItem cont : this.blobClient.listBlobContainers(options, null)) {
                LOG.info((Object)("Deleting container: " + cont.getName()));
                BlobContainerClient bcc = this.blobClient.getBlobContainerClient(cont.getName());
                if (!bcc.exists()) continue;
                bcc.delete();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Delete all containers. Prefix: " + prefix + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in deleteAllBuckets. Prefix: " + prefix + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public boolean existsCID(String container) throws IOException {
        BlobContainerClient bcc = this.blobClient.getBlobContainerClient(container);
        if (!bcc.exists()) {
            return false;
        }
        return this.objectExists(container, "HOPSFS_CID");
    }

    @Override
    public void setCID(String container, String cid) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            if (!this.bucketExists(container)) {
                throw new IOException("Container " + container + " does not exist");
            }
            BlobContainerClient bcc = this.blobClient.getBlobContainerClient(container);
            BlobClient bc = bcc.getBlobClient("HOPSFS_CID");
            BinaryData binaryData = BinaryData.fromString((String)cid);
            bc.upload(binaryData);
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in setCID, CID: " + cid + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud.  set CID. Bucket: " + container + " Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
    }

    @Override
    public String getCID(String container) throws IOException {
        long startTime = System.currentTimeMillis();
        String cid = null;
        try {
            BlobContainerClient bcc = this.blobClient.getBlobContainerClient(container);
            if (!bcc.exists()) {
                throw new IOException("Container " + container + " does not exist");
            }
            BlobClient bc = bcc.getBlobClient("HOPSFS_CID");
            BinaryData binaryData = bc.downloadContent();
            cid = new String(binaryData.toBytes());
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in getCID. Container: " + container + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud.  get CID.  Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
        return cid;
    }

    @Override
    public boolean isEmpty(String container) throws IOException {
        BlobContainerClient bcc = this.blobClient.getBlobContainerClient(container);
        if (!bcc.exists()) {
            throw new IOException("Container " + container + " does not exist");
        }
        ListBlobsOptions lbo = new ListBlobsOptions();
        lbo.setPrefix("");
        return !bcc.listBlobs(lbo, null).iterator().hasNext();
    }

    @Override
    public boolean bucketExists(String container) throws IOException {
        BlobContainerClient bcc = this.blobClient.getBlobContainerClient(container);
        return bcc.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(List<String> containers) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            ExecutorService tPool = Executors.newFixedThreadPool(this.bucketDeletionThreads);
            try {
                for (String containerStr : containers) {
                    if (this.softDeletesEnabled && !this.isVersioningSupported(containerStr)) {
                        throw new IOException("Cannot format file system. Versioning is enabled. However the container does not have DeleteRetentionPolicy set.");
                    }
                    this.emptyBucket(containerStr, true, tPool);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn((Object)e);
            }
            finally {
                tPool.shutdown();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Format containers: " + Arrays.toString(containers.toArray()) + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (AzureException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void createBucket(final String containerStr) throws IOException {
        new CloudActionHandler(){

            @Override
            public Object task() throws IOException {
                LOG.info((Object)("Creating container: " + containerStr));
                BlobContainerClient bcc = CloudPersistenceProviderAzureImpl.this.blobClient.getBlobContainerClient(containerStr);
                if (!bcc.exists()) {
                    bcc.create();
                }
                return null;
            }
        }.performTask();
        if (this.softDeletesEnabled) {
            new CloudActionHandler(){

                @Override
                public Object task() throws IOException {
                    LOG.info((Object)"Enabling soft deletes for storage");
                    CloudPersistenceProviderAzureImpl.this.enableSoftDeletes();
                    return null;
                }
            }.performTask();
        }
    }

    private void emptyBucket(final String container, boolean onlyDeleteHopsFSData, ExecutorService tPool) throws IOException, ExecutionException, InterruptedException {
        final AtomicInteger deletedBlocks = new AtomicInteger(0);
        try {
            if (!this.bucketExists(container)) {
                throw new IOException("Cannot format file system. The container does not exist");
            }
            System.out.println("HopsFS-Cloud. Emptying container: " + container);
            BlobContainerClient bcc = this.blobClient.getBlobContainerClient(container);
            ListBlobsOptions lbo = new ListBlobsOptions();
            Iterable blobPages = bcc.listBlobs(lbo, null).iterableByPage();
            for (PagedResponse page : blobPages) {
                ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
                List blobs = page.getValue();
                for (BlobItem blobItem : blobs) {
                    final String objectkey = blobItem.getName();
                    if (onlyDeleteHopsFSData && !objectkey.startsWith("hopsfs-blocks-set-")) continue;
                    Callable<Object> task = new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            CloudPersistenceProviderAzureImpl.this.deleteObject(container, objectkey);
                            String msg = "\rDeleted Blocks: " + deletedBlocks.incrementAndGet();
                            System.out.print(msg);
                            return null;
                        }
                    };
                    futures.add(tPool.submit(task));
                }
                for (Future future : futures) {
                    future.get();
                }
            }
            BlobClient bc = bcc.getBlobClient("HOPSFS_CID");
            if (bc.exists().booleanValue()) {
                bc.delete();
            }
            System.out.println("");
        }
        catch (AzureException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void checkAllBuckets(List<String> containers) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            int retry = 300;
            for (String contStr : containers) {
                LOG.debug((Object)("Checking container: " + contStr));
                boolean exists = false;
                BlobContainerClient bcc = null;
                for (int j = 0; j < 300; ++j) {
                    bcc = this.blobClient.getBlobContainerClient(contStr);
                    if (!bcc.exists()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    exists = true;
                    break;
                }
                if (!exists) {
                    throw new IllegalStateException("Azure Container " + contStr + " needed for the file system does not exists");
                }
                UUID uuid = UUID.randomUUID();
                File file1 = new File("/tmp/" + uuid);
                File file2 = new File("/tmp/" + uuid + ".downloaded");
                try {
                    BlobClient bc = bcc.getBlobClient(uuid.toString());
                    String message = "hello! hello! testing! testing! testing 1 2  3!";
                    FileWriter fw = new FileWriter(file1);
                    fw.write(message);
                    fw.close();
                    bc.uploadFromFile(file1.getAbsolutePath());
                    bc.downloadToFile(file2.getAbsolutePath());
                    bc.delete();
                    assert (FileUtils.contentEquals((File)file1, (File)file2));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Write test for Azure container: " + contStr + " failed. " + e);
                }
                finally {
                    file1.delete();
                    file2.delete();
                }
            }
            LOG.info((Object)("HopsFS-Cloud. Check all containers: " + Arrays.toString(containers.toArray()) + " Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
        catch (AzureException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getPrefixSize() {
        return this.prefixSize;
    }

    @Override
    public void uploadObject(String container, String objectKey, File file, Map<String, String> metadata) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            LOG.info((Object)("HopsFS-Cloud. Put Object. Bucket: " + container + " Object Key: " + objectKey + " Object Size: " + objectKey.length()));
            BlobContainerClient bcc = this.blobClient.getBlobContainerClient(container);
            BlobClient bc = bcc.getBlobClient(objectKey);
            bc.uploadFromFile(file.getAbsolutePath(), true);
            bc.setMetadata(metadata);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Put Object. Container: " + container + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in uploadObject. Container: " + container + " Key: " + objectKey + " File: " + file.getAbsolutePath() + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public boolean objectExists(String container, String objectKey) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            BlobContainerClient bcc = this.blobClient.getBlobContainerClient(container);
            BlobClient bc = bcc.getBlobClient(objectKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Obj Exists? Container: " + container + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
            return bc.exists();
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in objectExists. Container: " + container + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public Map<String, String> getUserMetaData(String container, String objectKey) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            BlobContainerClient bcc = this.blobClient.getBlobContainerClient(container);
            BlobClient bc = bcc.getBlobClient(objectKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Get metadata. Container: " + container + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
            return bc.getProperties().getMetadata();
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in getUserMetaData. Container: " + container + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public long getObjectSize(String container, String objectKey) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            BlobContainerClient bcc = this.blobClient.getBlobContainerClient(container);
            BlobClient bc = bcc.getBlobClient(objectKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Get obj size. Container: " + container + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
            return bc.getProperties().getBlobSize();
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in getObjectSize. Container: " + container + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public void downloadObject(String container, String objectKey, File path) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            if (path.exists()) {
                path.delete();
            } else if (!path.getParentFile().exists()) {
                path.getParentFile().mkdirs();
            }
            Random rand = new Random(System.currentTimeMillis());
            File tmpFile = new File(path.getAbsolutePath() + "." + rand.nextLong() + ".downloading");
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            BlobContainerClient bcc = this.blobClient.getBlobContainerClient(container);
            BlobClient bc = bcc.getBlobClient(objectKey);
            BlobProperties props = bc.downloadToFile(tmpFile.getAbsolutePath());
            tmpFile.renameTo(path);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Download obj. Container: " + container + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (BlobStorageException e) {
            if (e.getErrorCode() == BlobErrorCode.BLOB_ARCHIVED && e.getStatusCode() == 409) {
                String message = " The block has moved to ARCHIVE storage. Please restore the block to read the file";
                throw new BlockMovedToColdStorageException(message);
            }
            throw e;
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in downloadObject Container: " + container + " ObjKey: " + objectKey + " File: " + path.getAbsolutePath() + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    @VisibleForTesting
    public Map<BlockIDAndGSTuple, CloudBlock> getAll(String prefix, List<String> containers) throws IOException {
        long startTime = System.currentTimeMillis();
        HashMap<BlockIDAndGSTuple, CloudBlock> blocks = new HashMap<BlockIDAndGSTuple, CloudBlock>();
        for (String contStr : containers) {
            this.listContainer(contStr, prefix, blocks);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud. Get all blocks. Containers: " + Arrays.toString(containers.toArray()) + " Prefix: " + prefix + " Total Blocks: " + blocks.size() + " Time (ms): " + (System.currentTimeMillis() - startTime)));
        }
        return blocks;
    }

    @Override
    public List<String> getAllHopsFSDirectories(List<String> containers) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            ArrayList<String> dirs = new ArrayList<String>();
            for (String container : containers) {
                PagedIterable items = this.blobClient.getBlobContainerClient(container).listBlobsByHierarchy("");
                for (BlobItem item : items) {
                    String key = item.getName();
                    if (key.contains("hopsfs-blocks-set-")) {
                        dirs.add(key);
                        continue;
                    }
                    LOG.info((Object)("HopsFS-Cloud. Ignoring " + key + " directory. It is not HopsFS directory"));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Get all top level dirs. Containers: " + Arrays.toString(containers.toArray()) + " Total Dirs: " + dirs.size() + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
            return dirs;
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in getAllDirectories Container: " + Arrays.toString(containers.toArray()) + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    private void listContainer(String container, String prefix, Map<BlockIDAndGSTuple, CloudBlock> result) throws IOException {
        try {
            HashMap<BlockIDAndGSTuple, CloudObject> blockObjs = new HashMap<BlockIDAndGSTuple, CloudObject>();
            HashMap<BlockIDAndGSTuple, CloudObject> metaObjs = new HashMap<BlockIDAndGSTuple, CloudObject>();
            BlobContainerClient bcc = this.blobClient.getBlobContainerClient(container);
            ListBlobsOptions lbo = new ListBlobsOptions();
            lbo.setPrefix(prefix);
            Iterable blobPages = bcc.listBlobs(lbo, null).iterableByPage();
            for (PagedResponse page : blobPages) {
                List blobs = page.getValue();
                for (BlobItem item : blobs) {
                    String key = item.getName();
                    CloudObject co = new CloudObject();
                    co.setBucket(container);
                    co.setKey(item.getName());
                    co.setSize(item.getProperties().getContentLength());
                    co.setLastModifiedTime(item.getProperties().getLastModified().toEpochSecond());
                    BlockIDAndGSTuple idAndGS = CloudHelper.getIDAndGSFromKey(key);
                    if (idAndGS != null && CloudHelper.isBlockFilename(key)) {
                        blockObjs.put(idAndGS, co);
                        continue;
                    }
                    if (idAndGS != null || CloudHelper.isMetaFilename(key)) {
                        metaObjs.put(idAndGS, co);
                        continue;
                    }
                    LOG.warn((Object)("HopsFS-Cloud. File system objects are tampered. The " + key + " is not HopsFS object."));
                }
            }
            CloudPersistenceProviderS3Impl.mergeMetaAndBlockObjects(metaObjs, blockObjs, result);
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in listContainer. Container: " + container + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public void deleteObject(String container, String objectKey) throws IOException {
        try {
            this.deleteObjectInternal(container, objectKey);
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in deleteObject. Container: " + container + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    public void deleteObjectInternal(String container, String objectKey) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            BlobContainerClient bcc = this.blobClient.getBlobContainerClient(container);
            BlobClient bc = bcc.getBlobClient(objectKey);
            bc.delete();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Delete Object. Container: " + container + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (BlobStorageException e) {
            if (e.getErrorCode() == BlobErrorCode.SNAPSHOTS_PRESENT && e.getStatusCode() == 409) {
                LOG.warn((Object)("Unable to delete the object key: " + objectKey + " as it has snapshot. Retrying delete includeing snapshots"));
                this.deleteIncludingSnapshots(container, objectKey);
                return;
            }
            throw new IOException(e);
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in deleteObjectInternal. Container: " + container + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    private void deleteIncludingSnapshots(String container, String objectKey) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            BlobContainerClient bcc = this.blobClient.getBlobContainerClient(container);
            BlobClient bc = bcc.getBlobClient(objectKey);
            bc.deleteWithResponse(DeleteSnapshotsOptionType.INCLUDE, new BlobRequestConditions(), null, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Delete Object including all snaphots. Container: " + container + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in deleteIncludingSnapshots. Container: " + container + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    @VisibleForTesting
    public void renameObject(String srcContainer, String dstContainer, String srcKey, String dstKey) throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            BlobContainerClient srcBcc = this.blobClient.getBlobContainerClient(srcContainer);
            BlobClient srcBc = srcBcc.getBlobClient(srcKey);
            UUID uuid = UUID.randomUUID();
            File file = new File("/tmp/" + uuid);
            srcBc.downloadToFile(file.getAbsolutePath());
            srcBc.delete();
            BlobContainerClient dstBcc = this.blobClient.getBlobContainerClient(dstContainer);
            BlobClient dstBc = dstBcc.getBlobClient(dstKey);
            dstBc.uploadFromFile(file.getAbsolutePath());
            file.delete();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Rename Object. Src Container: " + srcContainer + " Src Object Key: " + srcKey + " Dst Container: " + dstContainer + " Dst Object Key: " + dstKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in renameObject  Src Container: " + srcContainer + " Dst Container: " + dstContainer + " SrcKey: " + srcKey + " DstKey: " + dstKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public void copyObject(String srcContainer, String dstContainer, String srcKey, String dstKey, Map<String, String> newObjMetadata) throws IOException {
        throw new UnsupportedOperationException("Azure does not suppor copy or rename operation");
    }

    @Override
    public long getPartSize() {
        return this.partSize;
    }

    @Override
    public int getXferThreads() {
        return this.maxThreads;
    }

    @Override
    public UploadID startMultipartUpload(String container, String objectKey, Map<String, String> metadata) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"HopsFS-Cloud. Starting Multipart Upload.");
        }
        return null;
    }

    @Override
    public PartRef uploadPart(String container, String objectKey, UploadID uploadID, int partNo, File file, long startPos, long endPos) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            BlockBlobClient bbc = this.blobClient.getBlobContainerClient(container).getBlobClient(objectKey).getBlockBlobClient();
            String id64 = this.base64ID(partNo);
            FileInputStream fis = new FileInputStream(file);
            fis.skip(startPos);
            int len = (int)(endPos - startPos);
            byte[] bytes = new byte[len];
            int read = fis.read(bytes, 0, len);
            bbc.stageBlock(id64, (InputStream)new ByteArrayInputStream(bytes), (long)read);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Uploaded Part.  Container: " + container + " Object Key: " + objectKey + " PartID: " + id64 + " Part Size: " + len + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
            return new AzurePartRef(id64);
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in uploadPart. Container: " + container + " ObjKey: " + objectKey + " UploadID: " + uploadID.toString() + " Part No:" + partNo + " File: " + file.getAbsolutePath() + " Start Pos: " + startPos + " End Pos: " + endPos + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    private String base64ID(int id) {
        String id64 = new String(Base64.getEncoder().encode(String.format("%09d", id).getBytes()));
        return id64;
    }

    @Override
    public void finalizeMultipartUpload(String container, String objectKey, UploadID uploadID, List<PartRef> refs) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            ArrayList<String> ids = new ArrayList<String>();
            for (PartRef ref : refs) {
                ids.add(((AzurePartRef)ref).getId64());
            }
            BlockBlobClient bbc = this.blobClient.getBlobContainerClient(container).getBlobClient(objectKey).getBlockBlobClient();
            bbc.commitBlockList(ids);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Finalize Multipart Upload. Container: " + container + " Object Key: " + objectKey + " Parts: " + ids.size() + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in finalizeMultipartUpload. Container: " + container + " ObjKey: " + objectKey + " UploadID: " + uploadID.toString() + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public void abortMultipartUpload(String container, String objectKey, UploadID uploadID) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            BlockBlobClient bbc = this.blobClient.getBlobContainerClient(container).getBlobClient(objectKey).getBlockBlobClient();
            bbc.delete();
        }
        catch (BlobStorageException e) {
            if (e.getMessage().contains("The specified blob does not exist")) {
                LOG.debug((Object)"HopsFS-Cloud. Multipart upload alreay aborted.");
                return;
            }
            throw e;
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in abortMultipartUpload. Container: " + container + " ObjKey: " + objectKey + " UploadID: " + uploadID.toString() + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. Abort multipart upload. Container: " + container + " Object Key: " + objectKey + " Time (ms): " + (System.currentTimeMillis() - startTime)));
            }
        }
    }

    @Override
    public List<ActiveMultipartUploads> listMultipartUploads(List<String> container, String prefix) throws IOException {
        throw new UnsupportedOperationException("Operation not supported for azure");
    }

    @Override
    public boolean restoreDeletedBlock(String container, String objectKey) throws IOException {
        try {
            this.blobClient.getBlobContainerClient(container).getBlobClient(objectKey).undelete();
            return true;
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in listMultipartUploads. Container: " + container + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public boolean isVersioningSupported(String container) throws IOException {
        try {
            BlobServiceProperties props = this.blobClient.getProperties();
            return props.getDeleteRetentionPolicy().isEnabled();
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in isVersioningSupported. Container: " + container + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    public void enableSoftDeletes() throws IOException {
        try {
            int days = this.conf.getInt("azure.soft.deletes.retention.days", 90);
            if (days < 7) {
                throw new RuntimeException("Number of retention days for soft deleted blocks must be >= 7");
            }
            BlobRetentionPolicy blobRetentionPolicy = new BlobRetentionPolicy();
            blobRetentionPolicy.setEnabled(true).setDays(Integer.valueOf(days));
            BlobServiceProperties blobServiceProperties = new BlobServiceProperties();
            blobServiceProperties.setDeleteRetentionPolicy(blobRetentionPolicy);
            this.blobClient.setProperties(blobServiceProperties);
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in enableSoftDeletes. Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public void deleteAllVersions(String container, String objectKey) throws IOException {
        try {
            BlobClient bc = this.blobClient.getBlobContainerClient(container).getBlobClient(objectKey);
            if (bc.exists().booleanValue()) {
                bc.delete();
            }
        }
        catch (AzureException e) {
            LOG.info((Object)("HopsFS-Cloud: Exception in deleteAllVersions. Container: " + container + " ObjKey: " + objectKey + " Error: " + e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public void deleteOldVersions(String bucket, String objectKey) throws IOException {
    }

    @Override
    public void shutdown() {
    }

    public BlobServiceClient getBlobClient() {
        return this.blobClient;
    }

    @Override
    public Object getCloudClient() {
        return this.blobClient;
    }

    private abstract class CloudActionHandler {
        private CloudActionHandler() {
        }

        public abstract Object task() throws IOException;

        public Object performTask() throws IOException {
            ArrayList<AzureException> exceptions = new ArrayList<AzureException>();
            long sleepTime = 500L;
            for (int i = 0; i < 10; ++i) {
                try {
                    if (i != 0) {
                        LOG.info((Object)("HopsFS-Cloud. Operation Failed. Cause: " + exceptions.get(exceptions.size() - 1) + " Retrying operation after " + (sleepTime *= 2L) + " ms. Retry Count: " + i));
                        Thread.sleep(sleepTime);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    Object object = this.task();
                    return object;
                }
                catch (AzureException azureException) {
                    exceptions.add(azureException);
                    continue;
                }
            }
            for (Exception exception : exceptions) {
                LOG.info((Object)"Supressed Exception", (Throwable)exception);
            }
            throw new IOException((Throwable)exceptions.get(0));
        }
    }
}

