/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ProvidedBlocksCacheDiskUtilization;

public class ProvidedBlocksCacheCleaner
extends Thread {
    static final Log LOG = LogFactory.getLog(ProvidedBlocksCacheCleaner.class);
    private final File baseDir;
    private final long checkInterval;
    private final int activationTheshold;
    private final int deleteBatchSize;
    private final int waitBeforeDelete;
    private Map<String, CachedProvidedBlock> cachedFiles = new ConcurrentHashMap<String, CachedProvidedBlock>();
    private ProvidedBlocksCacheDiskUtilization diskUtilization;
    private boolean run = true;

    public ProvidedBlocksCacheCleaner(File baseDir, long checkInterval, int activationTheshold, int deleteBatchSize, int waitBeforeDelete) {
        this.baseDir = baseDir;
        this.activationTheshold = activationTheshold;
        this.checkInterval = checkInterval;
        this.deleteBatchSize = deleteBatchSize;
        this.diskUtilization = new ProvidedBlocksCacheDiskUtilization(baseDir);
        this.waitBeforeDelete = waitBeforeDelete;
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(baseDir);
        while (!dirs.isEmpty()) {
            File[] files;
            for (File file : files = ((File)dirs.remove(0)).listFiles()) {
                if (file.isFile()) {
                    this.cachedFiles.put(file.getAbsolutePath(), new CachedProvidedBlock(file.getAbsolutePath(), System.currentTimeMillis()));
                    continue;
                }
                dirs.add(file);
            }
        }
    }

    public void fileAccessed(String file) {
        this.cachedFiles.put(file, new CachedProvidedBlock(file, System.currentTimeMillis()));
        LOG.debug((Object)("HopsFS-Cloud. Provided blocks Cache. Added/Updated file: " + file + " Total cached files: " + this.cachedFiles.size()));
    }

    public void fileDeleted(String file) {
        this.cachedFiles.remove(file);
        LOG.debug((Object)("HopsFS-Cloud. Provided blocks Cache. Removed file: " + file));
    }

    @Override
    public void run() {
        try {
            while (this.run) {
                double percentage = this.diskUtilization.getDiskUtilization();
                if (percentage >= (double)this.activationTheshold) {
                    LOG.info((Object)("HopsFS-Cloud. Disk utilization is " + (long)percentage + ". Freeing up space to make room for new blocks"));
                    this.freeUpSpace();
                    Thread.sleep(1000L);
                    continue;
                }
                LOG.debug((Object)("HopsFS-Cloud. Provided bocks cache. No need to free up disk space. Disk utilization: " + percentage + "%"));
                Thread.sleep(this.checkInterval);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void freeUpSpace() {
        LOG.debug((Object)("HopsFS-Cloud. Provided blocks cache. Total Files in cache are " + this.cachedFiles.size()));
        ArrayList<CachedProvidedBlock> list = new ArrayList<CachedProvidedBlock>(this.cachedFiles.values());
        Collections.sort(list);
        int counter = 0;
        for (CachedProvidedBlock cBlk : list) {
            String filePath = cBlk.path;
            File file = new File(filePath);
            long ts = file.lastModified();
            if (System.currentTimeMillis() - ts < (long)this.waitBeforeDelete) continue;
            boolean isFileUnlocked = false;
            boolean deleted = false;
            try {
                FileUtils.touch((File)file);
                isFileUnlocked = true;
            }
            catch (IOException e) {
                isFileUnlocked = false;
            }
            if (isFileUnlocked && file.delete()) {
                this.fileDeleted(filePath);
                ++counter;
                deleted = true;
            }
            if (!deleted) {
                LOG.warn((Object)("HopsFS-Cloud. Provided blocks disk cache. Could not delete " + file.getName()));
                continue;
            }
            if (counter < this.deleteBatchSize) continue;
            break;
        }
    }

    public void shutdown() {
        this.run = false;
        this.interrupt();
    }

    public int getCachedFilesCount() {
        return this.cachedFiles.size();
    }

    public ProvidedBlocksCacheDiskUtilization getDiskUtilizationCalc() {
        return this.diskUtilization;
    }

    public void setDiskUtilizationMock(ProvidedBlocksCacheDiskUtilization mock) {
        this.diskUtilization = mock;
    }

    class CachedProvidedBlock
    implements Comparable<CachedProvidedBlock> {
        private final String path;
        private final long time;

        public CachedProvidedBlock(String path, long time) {
            this.path = path;
            this.time = time;
        }

        public long getTime() {
            return this.time;
        }

        public String getPath() {
            return this.path;
        }

        @Override
        public int compareTo(CachedProvidedBlock o) {
            return new Long(this.time).compareTo(o.time);
        }
    }
}

