/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@VisibleForTesting
public class CloudFsVolumeImpl
extends FsVolumeImpl {
    public static final Logger LOG = LoggerFactory.getLogger(CloudFsVolumeImpl.class);

    CloudFsVolumeImpl(FsDatasetImpl dataset, String storageID, File currentDir, Configuration conf, StorageType storageType) throws IOException {
        super(dataset, storageID, currentDir, conf, storageType);
        LOG.info("HopsFS-Cloud. Initializing CloudFsVolumeImpl.  ");
    }

    @Override
    File createRbwFile(String bpid, Block b) throws IOException {
        LOG.info("HopsFS-Cloud. Creating Rbw File. BlockID: " + b.getBlockId() + " GenStamp: " + b.getGenerationStamp());
        return super.createRbwFile(bpid, b);
    }

    @Override
    public FsVolumeSpi.BlockIterator newBlockIterator(String bpid, String name) {
        return new BlockIteratorImpl(bpid, name);
    }

    private class BlockIteratorImpl
    implements FsVolumeSpi.BlockIterator {
        private final String name;
        private final String bpid;

        BlockIteratorImpl(String bpid, String name) {
            this.name = name;
            this.bpid = bpid;
        }

        @Override
        public ExtendedBlock nextBlock() throws IOException {
            return null;
        }

        @Override
        public boolean atEnd() {
            return true;
        }

        @Override
        public void rewind() {
        }

        @Override
        public void save() throws IOException {
        }

        @Override
        public void setMaxStalenessMs(long maxStalenessMs) {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public long getIterStartMs() {
            return System.currentTimeMillis();
        }

        @Override
        public long getLastSavedMs() {
            return System.currentTimeMillis();
        }

        @Override
        public String getBlockPoolId() {
            return this.bpid;
        }
    }
}

