/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.PartRef;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.UploadID;

public class ProvidedReplicaBeingWritten
extends ReplicaBeingWritten {
    private boolean isMultipart = false;
    private boolean isMultipartComplete = false;
    private boolean cancellMultipart = false;
    private boolean isAppend = false;
    private List<Long> oldGS = new ArrayList<Long>();
    private boolean isRecovered = false;
    private int currentPart = 0;
    private final long partSize;
    List<PartRef> partETags = new ArrayList<PartRef>();
    List<Future> uploadTasks = new ArrayList<Future>();
    private UploadID uploadID = null;
    private boolean isSynced;

    public ProvidedReplicaBeingWritten(ReplicaBeingWritten from, long partSize) {
        super(from);
        this.partSize = partSize;
        this.isSynced = false;
    }

    public boolean isPartAvailable() {
        if (this.cancellMultipart) {
            return false;
        }
        return this.getBytesOnDisk() >= (long)(this.currentPart + 1) * this.partSize;
    }

    public int incrementAndGetNextPart() {
        return ++this.currentPart;
    }

    public int getCurrentPart() {
        return this.currentPart;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public UploadID getUploadID() {
        return this.uploadID;
    }

    public void setUploadID(UploadID uploadID) {
        this.uploadID = uploadID;
    }

    public void addEtag(PartRef etag) {
        this.partETags.add(etag);
    }

    public List<PartRef> getPartETags() {
        return this.partETags;
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    public void setMultipart(boolean multipart) {
        this.isMultipart = multipart;
    }

    public boolean isMultipartComplete() {
        return this.isMultipartComplete;
    }

    public void setMultipartComplete(boolean multipartComplete) {
        this.isMultipartComplete = multipartComplete;
    }

    public List<Future> getAllUploadTasks() {
        return this.uploadTasks;
    }

    public void addUploadTask(Future future) {
        this.uploadTasks.add(future);
    }

    public boolean isSynced() {
        return this.isSynced;
    }

    public void setSynced(boolean synced) {
        this.isSynced = synced;
    }

    public boolean isCancellMultipart() {
        return this.cancellMultipart;
    }

    public void setCancellMultipart(boolean cancellMultipart) {
        this.cancellMultipart = cancellMultipart;
    }

    public boolean isAppend() {
        return this.isAppend;
    }

    public void setAppend(boolean append) {
        this.isAppend = append;
    }

    public void setRecovered(boolean recovered) {
        this.isRecovered = recovered;
    }

    public boolean isRecovered() {
        return this.isRecovered;
    }

    public List<Long> getOldGS() {
        return this.oldGS;
    }

    public void addOldGS(long oldGS) {
        this.oldGS.add(oldGS);
    }
}

