/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import com.google.common.collect.Lists;
import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.BlockIDAndGSTuple;
import io.hops.metadata.hdfs.dal.CloudBucketDataAccess;
import io.hops.metadata.hdfs.entity.CloudBucket;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CloudProvider;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.CloudBucketAlreadyExistsException;
import org.apache.hadoop.hdfs.server.blockmanagement.CloudBucketNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;

public class CloudHelper {
    public static final Log LOG = LogFactory.getLog(CloudHelper.class);
    public static final String ROOT_PREFIX = "";
    public static final String BLOCKFILE_EXTENSION = ".data";
    public static final String PREFIX_STR = "hopsfs-blocks-set-";
    public static final String GCS_MULTI_PART_DIR = "partial-blocks";
    public static final String GCS_MULTI_PART_SUFFIX = ".part_";
    public static final String CID_FILE = "HOPSFS_CID";
    public static final Pattern blockFilePattern = Pattern.compile("hopsfs-blocks-set-(-??\\d++)/blk_(-??\\d++)_(\\d++)\\.data$");
    public static final Pattern metaFilePattern = Pattern.compile("hopsfs-blocks-set-(-??\\d++)/blk_(-??\\d++)_(\\d++)\\.meta$");
    public static final Pattern partialBlockFilePattern = Pattern.compile("hopsfs-blocks-set-(-??\\d++)/partial-blocks/blk_(-??\\d++)_(\\d++)\\.data.part_(\\d++)$");
    private static Map<String, CloudBucket> BUCKETS = null;
    static Random rand = new Random(System.currentTimeMillis());

    public static String getBlockKey(int prefixSize, Block b) {
        return CloudHelper.getPrefix(prefixSize, b.getBlockId()) + b.getBlockName() + "_" + b.getGenerationStamp() + BLOCKFILE_EXTENSION;
    }

    public static String getMetaFileKey(int prefixSize, Block b) {
        String metaFileID = DatanodeUtil.getMetaName(b.getBlockName(), b.getGenerationStamp());
        return CloudHelper.getPrefix(prefixSize, b.getBlockId()) + metaFileID;
    }

    public static String getPrefix(int prefixSize, long blockID) {
        long prefixNo = blockID / (long)prefixSize;
        return PREFIX_STR + prefixNo + "/";
    }

    public static boolean isBlockFilename(String name) {
        return blockFilePattern.matcher(name).matches();
    }

    public static boolean isMetaFilename(String name) {
        return metaFilePattern.matcher(name).matches();
    }

    public static boolean isPartialGCSFile(String name) {
        return partialBlockFilePattern.matcher(name).matches();
    }

    public static BlockIDAndGSTuple getIDAndGSFromKey(String key) {
        long blockID = 0L;
        long gs = 0L;
        if (CloudHelper.isBlockFilename(key)) {
            blockID = CloudHelper.extractBlockIDFromBlockName(key);
            gs = CloudHelper.extractGSFromBlockName(key);
        } else if (CloudHelper.isMetaFilename(key)) {
            blockID = CloudHelper.extractBlockIDFromMetaName(key);
            gs = CloudHelper.extractGSFromMetaName(key);
        } else if (CloudHelper.isPartialGCSFile(key)) {
            blockID = CloudHelper.extractBlockIDFromPartialBlock(key);
            gs = CloudHelper.extractGSFromPartialBlock(key);
        } else {
            return null;
        }
        return new BlockIDAndGSTuple(blockID, gs);
    }

    public static long extractBlockIDFromBlockName(String name) {
        List<Long> numbers = CloudHelper.extractNumbers(name);
        return numbers.get(numbers.size() - 2);
    }

    public static long extractGSFromBlockName(String name) {
        List<Long> numbers = CloudHelper.extractNumbers(name);
        return numbers.get(numbers.size() - 1);
    }

    public static long extractBlockIDFromMetaName(String name) {
        List<Long> numbers = CloudHelper.extractNumbers(name);
        return numbers.get(numbers.size() - 2);
    }

    public static long extractGSFromMetaName(String name) {
        List<Long> numbers = CloudHelper.extractNumbers(name);
        return numbers.get(numbers.size() - 1);
    }

    public static long extractBlockIDFromPartialBlock(String name) {
        List<Long> numbers = CloudHelper.extractNumbers(name);
        return numbers.get(numbers.size() - 3);
    }

    public static long extractGSFromPartialBlock(String name) {
        List<Long> numbers = CloudHelper.extractNumbers(name);
        return numbers.get(numbers.size() - 2);
    }

    public static List<Long> extractNumbers(String key) {
        String str = key.replaceAll("[^?0-9]+", " ");
        String[] numbersStr = str.trim().split(" ");
        ArrayList<Long> numbers = new ArrayList<Long>();
        for (String num : numbersStr) {
            numbers.add(Long.parseLong(num));
        }
        return numbers;
    }

    public static Map<String, CloudBucket> getAllBuckets() throws StorageException {
        if (BUCKETS != null && BUCKETS.size() != 0) {
            return BUCKETS;
        }
        BUCKETS = CloudHelper.getAllBucketsFromDB();
        return BUCKETS;
    }

    private static Map<String, CloudBucket> getAllBucketsFromDB() throws StorageException {
        try {
            LightWeightRequestHandler h = new LightWeightRequestHandler(HDFSOperationType.GET_ALL_CLOUD_BUCKETS){

                public Object performTask() throws IOException {
                    CloudBucketDataAccess da = (CloudBucketDataAccess)HdfsStorageFactory.getDataAccess(CloudBucketDataAccess.class);
                    return da.getAll();
                }
            };
            return (Map)h.handle();
        }
        catch (IOException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public static int addBucket(final String name) throws StorageException {
        try {
            if (CloudHelper.getAllBuckets().keySet().contains(name)) {
                throw new CloudBucketAlreadyExistsException("Bucket with name: " + name + " already added");
            }
            LightWeightRequestHandler h = new LightWeightRequestHandler(HDFSOperationType.ADD_CLOUD_BUCKET){

                public Object performTask() throws IOException {
                    CloudBucketDataAccess da = (CloudBucketDataAccess)HdfsStorageFactory.getDataAccess(CloudBucketDataAccess.class);
                    return da.addBucket(name);
                }
            };
            return (Integer)h.handle();
        }
        catch (IOException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public static String getCloudBucketName(short ID) throws StorageException, CloudBucketNotFoundException {
        if (ID == -1) {
            return ROOT_PREFIX;
        }
        for (CloudBucket bucket : CloudHelper.getAllBuckets().values()) {
            if (bucket.getID() != ID) continue;
            return bucket.getName();
        }
        throw new CloudBucketNotFoundException("Bucket with ID: " + ID + " is not found");
    }

    public static short getCloudBucketID(String name) throws StorageException {
        if (name.compareToIgnoreCase(ROOT_PREFIX) == 0) {
            return -1;
        }
        Map<String, CloudBucket> buckets = CloudHelper.getAllBuckets();
        if (!buckets.keySet().contains(name)) {
            throw new CloudBucketNotFoundException("Bucket with name: " + name + " is not added");
        }
        return buckets.get(name).getID();
    }

    public static List<String> getBucketsFromConf(Configuration conf) {
        String cloudProvider = conf.get("dfs.cloud.provider", "AWS");
        String bucket = null;
        if (cloudProvider.compareToIgnoreCase(CloudProvider.AZURE.name()) == 0) {
            bucket = conf.get("dfs.cloud.azure.container", ROOT_PREFIX);
        } else if (cloudProvider.compareToIgnoreCase(CloudProvider.AWS.name()) == 0) {
            bucket = conf.get("dfs.cloud.aws.s3.bucket", "hopsfs.bucket");
        } else if (cloudProvider.compareToIgnoreCase(CloudProvider.GCS.name()) == 0) {
            bucket = conf.get("dfs.cloud.gcs.bucket", "hopsfs.bucket");
        } else {
            throw new IllegalArgumentException("Cloud Provider " + cloudProvider + " not supported");
        }
        ArrayList<String> buckets = new ArrayList<String>();
        buckets.add(bucket);
        return buckets;
    }

    public static String getRandomCloudBucket() throws StorageException {
        Map<String, CloudBucket> buckets = CloudHelper.getAllBuckets();
        if (buckets == null || buckets.isEmpty()) {
            throw new CloudBucketNotFoundException("No cloud buckets found");
        }
        return (String)Lists.newArrayList(buckets.keySet()).get(rand.nextInt(buckets.size()));
    }

    public static void clearCache() {
        if (BUCKETS != null) {
            BUCKETS.clear();
        }
    }
}

