/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.CloudHelper;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudPersistenceProvider;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudPersistenceProviderFactory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;

public class ProvidedBlocksCorruptionChecker
implements Callable<Object> {
    public static final Log LOG = LogFactory.getLog(ProvidedBlocksCorruptionChecker.class);
    private static int HEADER_LEN = 7;
    final Namesystem ns;
    final BlockInfoContiguous block;
    final DatanodeStorageInfo storageInfo;
    final String reason;
    final CorruptReplicasMap.Reason reasonCode;
    final Configuration conf;

    public ProvidedBlocksCorruptionChecker(Namesystem ns, Configuration conf, BlockInfoContiguous block, DatanodeStorageInfo storageInfo, String reason, CorruptReplicasMap.Reason reasonCode) {
        this.ns = ns;
        this.block = block;
        this.conf = conf;
        this.storageInfo = storageInfo;
        this.reason = reason;
        this.reasonCode = reasonCode;
    }

    @Override
    public Object call() throws Exception {
        CloudPersistenceProvider cloudConnector = null;
        try {
            cloudConnector = CloudPersistenceProviderFactory.getCloudClient(this.conf);
            if (this.hasCheckSumError(cloudConnector)) {
                this.markCorrupt();
            } else {
                this.deleteFromDNCache();
            }
        }
        catch (Exception e) {
            LOG.info((Object)("HopsFS-Cloud: Block checksum verification failed " + e));
        }
        finally {
            if (cloudConnector != null) {
                cloudConnector.shutdown();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasCheckSumError(CloudPersistenceProvider cloudConnector) throws IOException {
        boolean bl;
        String bucket = this.block.getCloudBucket();
        int prefixSize = this.conf.getInt("dfs.cloud.prefix.size", 500);
        String blockKey = CloudHelper.getBlockKey(prefixSize, this.block);
        String metaKey = CloudHelper.getMetaFileKey(prefixSize, this.block);
        File blockFile = null;
        File metaFile = null;
        FileInputStream metaStream = null;
        FileInputStream dataStream = null;
        FileChannel metaChannel = null;
        FileChannel dataChannel = null;
        DataInputStream checksumStream = null;
        try {
            ByteBuffer dataBuf;
            ByteBuffer metaBuf;
            BlockMetadataHeader header;
            File tmp = new File(System.getProperty("java.io.tmpdir"));
            blockFile = new File(tmp, UUID.randomUUID().toString());
            metaFile = new File(tmp, UUID.randomUUID().toString());
            cloudConnector.downloadObject(bucket, blockKey, blockFile);
            cloudConnector.downloadObject(bucket, metaKey, metaFile);
            try {
                metaStream = new FileInputStream(metaFile);
                checksumStream = new DataInputStream(metaStream);
                header = BlockMetadataHeader.readHeader(checksumStream);
                metaChannel = metaStream.getChannel();
                metaChannel.position(HEADER_LEN);
            }
            catch (RuntimeException e) {
                throw new IOException("Failed to read HDFS metadata file header for " + metaFile + ": " + StringUtils.stringifyException((Throwable)e));
            }
            catch (IOException e) {
                throw new IOException("Failed to read HDFS metadata file header for " + metaFile + ": " + StringUtils.stringifyException((Throwable)e));
            }
            DataChecksum checksum = header.getChecksum();
            LOG.debug((Object)("Checksum type: " + checksum.toString()));
            try {
                dataStream = new FileInputStream(blockFile);
                dataChannel = dataStream.getChannel();
                int CHECKSUMS_PER_BUF = 32768;
                metaBuf = ByteBuffer.allocate(checksum.getChecksumSize() * 32768);
                dataBuf = ByteBuffer.allocate(checksum.getBytesPerChecksum() * 32768);
            }
            catch (IOException e) {
                throw new IOException("Failed to open HDFS block file for " + blockFile + ": " + StringUtils.stringifyException((Throwable)e));
            }
            long offset = 0L;
            while (true) {
                dataBuf.clear();
                int dataRead = -1;
                try {
                    dataRead = dataChannel.read(dataBuf);
                    if (dataRead < 0) {
                        break;
                    }
                }
                catch (IOException e) {
                    throw new IOException("Got I/O error reading block file " + blockFile + "from disk at offset " + dataChannel.position() + ": " + StringUtils.stringifyException((Throwable)e));
                }
                try {
                    int csumToRead = (checksum.getBytesPerChecksum() - 1 + dataRead) / checksum.getBytesPerChecksum() * checksum.getChecksumSize();
                    metaBuf.clear();
                    metaBuf.limit(csumToRead);
                    metaChannel.read(metaBuf);
                    dataBuf.flip();
                    metaBuf.flip();
                }
                catch (IOException e) {
                    throw new IOException("Got I/O error reading metadata file " + metaFile + "from disk at offset " + metaChannel.position() + ": " + StringUtils.stringifyException((Throwable)e));
                }
                try {
                    checksum.verifyChunkedSums(dataBuf, metaBuf, blockFile.getAbsolutePath(), offset);
                }
                catch (IOException e) {
                    LOG.info((Object)("verifyChunkedSums error: " + StringUtils.stringifyException((Throwable)e)));
                    boolean bl2 = true;
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{metaStream, dataStream, checksumStream});
                    if (blockFile != null && blockFile.exists()) {
                        blockFile.delete();
                    }
                    if (metaFile != null && metaFile.exists()) {
                        metaFile.delete();
                    }
                    return bl2;
                }
                offset += (long)dataRead;
            }
            LOG.info((Object)("Checksum verification succeeded on block " + (Object)((Object)this.block)));
            bl = false;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{metaStream, dataStream, checksumStream});
            if (blockFile != null && blockFile.exists()) {
                blockFile.delete();
            }
            if (metaFile != null && metaFile.exists()) {
                metaFile.delete();
            }
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{metaStream, dataStream, checksumStream});
        if (blockFile != null && blockFile.exists()) {
            blockFile.delete();
        }
        if (metaFile != null && metaFile.exists()) {
            metaFile.delete();
        }
        return bl;
    }

    private void markCorrupt() throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.CLOUD_ADD_CORRUPT_BLOCKS){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock(ProvidedBlocksCorruptionChecker.this.block);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier)).add(lf.getIndividualBlockLock(ProvidedBlocksCorruptionChecker.this.block.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(LockFactory.BLK.UR));
            }

            public Object performTask() throws IOException {
                ((FSNamesystem)ProvidedBlocksCorruptionChecker.this.ns).getBlockManager().getNeededReplications().add(ProvidedBlocksCorruptionChecker.this.block, 0, 0, 1);
                return null;
            }
        }.handle();
    }

    void deleteFromDNCache() throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.FIND_AND_MARK_BLOCKS_AS_CORRUPT){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock(ProvidedBlocksCorruptionChecker.this.block);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier)).add(lf.getIndividualBlockLock(ProvidedBlocksCorruptionChecker.this.block.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(LockFactory.BLK.IV));
            }

            public Object performTask() throws IOException {
                BlockInfoContiguous storedBlock = ((FSNamesystem)ProvidedBlocksCorruptionChecker.this.ns).getStoredBlock(ProvidedBlocksCorruptionChecker.this.block);
                if (storedBlock == null) {
                    LOG.info((Object)("HopsFS-Cloud: BLOCK* findAndMarkBlockAsCorrupt: " + (Object)((Object)ProvidedBlocksCorruptionChecker.this.block) + " not found"));
                    return null;
                }
                ((FSNamesystem)ProvidedBlocksCorruptionChecker.this.ns).getBlockManager().getInvalidateBlocks().addProvidedBlock(ProvidedBlocksCorruptionChecker.this.block, this.inodeIdentifier.getInodeId(), false);
                return null;
            }
        }.handle();
    }
}

