/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.lc.repackaged.com.google.cloud.storage.Blob;
import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.HdfsVariables;
import io.hops.metadata.Variables;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.common.entity.LongVariable;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.hdfs.BlockIDAndGSTuple;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import io.hops.metadata.hdfs.dal.BlockLookUpDataAccess;
import io.hops.metadata.hdfs.dal.ProvidedBlockReportTasksDataAccess;
import io.hops.metadata.hdfs.dal.UnderReplicatedBlockDataAccess;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.InvalidatedBlock;
import io.hops.metadata.hdfs.entity.ProvidedBlockReportTask;
import io.hops.metadata.hdfs.entity.UnderReplicatedBlock;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CloudProvider;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.CloudBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.ProvidedBlocksCheckerFaultInjector;
import org.apache.hadoop.hdfs.server.common.CloudHelper;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.ActiveMultipartUploads;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudPersistenceProvider;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.CloudPersistenceProviderFactory;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.GCSActiveMultipartUploads;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.cloud.S3ActiveMultipartUploads;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;

public class ProvidedBlocksChecker
extends Thread {
    private final Namesystem ns;
    private boolean run = true;
    private final int prefixSize;
    private final long blockReportDelay;
    private final long sleepInterval;
    private final long subTaskSize;
    private final long markBlocksCorruptOrMissingDelay;
    private final BlockManager bm;
    private final int maxProvidedBRThreads;
    private boolean isBRInProgress = false;
    private final long deleteAbandonedBlocksAfter;
    private final Configuration conf;
    private final boolean isS3MultipartUpload;
    private final boolean isGCSMultipartUpload;
    CloudPersistenceProvider cloudConnector;
    static final Log LOG = LogFactory.getLog(ProvidedBlocksChecker.class);

    public ProvidedBlocksChecker(Configuration conf, Namesystem ns, BlockManager bm) throws IOException {
        this.ns = ns;
        this.bm = bm;
        this.conf = conf;
        this.prefixSize = conf.getInt("dfs.cloud.prefix.size", 500);
        this.blockReportDelay = conf.getLong("dfs.cloud.block.report.delay", 21600000L);
        this.sleepInterval = conf.getLong("dfs.cloud.block.report.thread.sleep.interval", 10000L);
        this.subTaskSize = conf.getLong("dfs.cloud.br.sub.tasks.size", 5000L);
        this.markBlocksCorruptOrMissingDelay = conf.getLong("dfs.cloud.mark.blocks.corrupt.or.missing.after", 3600000L);
        this.maxProvidedBRThreads = conf.getInt("dfs.cloud.max.br.threads", 5);
        this.deleteAbandonedBlocksAfter = conf.getLong("dfs.cloud.delete.abandoned.multipart.files.after", 604800000L);
        if (this.subTaskSize % (long)this.prefixSize != 0L) {
            String message = "Invalid configuration dfs.cloud.br.sub.tasks.size must be multiple of dfs.cloud.prefix.size";
            LOG.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        String cloudProvider = conf.get("dfs.cloud.provider", "AWS");
        this.isS3MultipartUpload = conf.getBoolean("dfs.cloud.concurrent.upload", true) && cloudProvider.compareToIgnoreCase(CloudProvider.AWS.name()) == 0;
        this.isGCSMultipartUpload = conf.getBoolean("dfs.cloud.concurrent.upload", true) && cloudProvider.compareToIgnoreCase(CloudProvider.GCS.name()) == 0;
        this.cloudConnector = CloudPersistenceProviderFactory.getCloudClient(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.run) {
            try {
                if (this.ns.isRunning() && this.ns.isLeader()) {
                    long startTime = this.getProvidedBlocksScanStartTime();
                    long existingTasks = this.countBRPendingTasks();
                    long timeElapsed = System.currentTimeMillis() - startTime;
                    if (timeElapsed > this.blockReportDelay && existingTasks == 0L) {
                        long END_ID = HdfsVariables.getMaxBlockID();
                        List<ProvidedBlockReportTask> tasks = this.generateTasks(END_ID);
                        LOG.info((Object)("HopsFS-Cloud. BR Created " + tasks.size() + " block reporting tasks for block ids up to " + END_ID));
                        this.addNewBlockReportTasks(tasks);
                        this.checkS3AbandonedBlocks();
                    }
                }
                if (this.countBRPendingTasks() == 0L) continue;
                this.startWork();
            }
            catch (IOException e) {
                LOG.warn((Object)e, (Throwable)e);
            }
            finally {
                if (!this.run) continue;
                try {
                    Thread.sleep(this.sleepInterval);
                }
                catch (InterruptedException e) {
                    ProvidedBlocksChecker.currentThread().interrupt();
                }
            }
        }
    }

    private void startWork() throws IOException {
        ArrayList<BRTasksPullers> workers = new ArrayList<BRTasksPullers>();
        for (int i = 0; i < this.maxProvidedBRThreads; ++i) {
            workers.add(new BRTasksPullers(i));
        }
        try {
            this.isBRInProgress = true;
            List futures = ((FSNamesystem)this.ns).getBlockOperationsExecutor().invokeAll(workers);
            for (Future maybeException : futures) {
                maybeException.get();
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
        finally {
            this.isBRInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processTask(ProvidedBlockReportTask task) throws IOException {
        boolean successful = false;
        try {
            long start = task.getStartIndex();
            while (start < task.getEndIndex()) {
                long end = start + (long)this.prefixSize;
                String prefix = CloudHelper.getPrefix(this.prefixSize, start);
                LOG.debug((Object)("HopsFS-Cloud. BR Checking prefix: " + prefix));
                HashMap<BlockIDAndGSTuple, BlockInfoContiguous> dbBlocksMap = new HashMap<BlockIDAndGSTuple, BlockInfoContiguous>();
                HashMap<Long, UnderReplicatedBlock> corruptBlkMap = new HashMap<Long, UnderReplicatedBlock>();
                this.findAllBlocksRange(start, end, dbBlocksMap, corruptBlkMap);
                ProvidedBlocksCheckerFaultInjector.get().errorAfterReadingBlocks(dbBlocksMap);
                Map<BlockIDAndGSTuple, CloudBlock> cloudBlocksMap = this.cloudConnector.getAll(prefix, Lists.newArrayList(CloudHelper.getAllBuckets().keySet()));
                LOG.debug((Object)("HopsFS-Cloud. BR DB view size: " + dbBlocksMap.size() + " Cloud view size: " + cloudBlocksMap.size()));
                ArrayList<BlockInfoContiguous> toMissing = new ArrayList<BlockInfoContiguous>();
                ArrayList<BlockToMarkCorrupt> toCorrupt = new ArrayList<BlockToMarkCorrupt>();
                ArrayList<CloudBlock> toDelete = new ArrayList<CloudBlock>();
                ArrayList<BlockInfoContiguous> toUnCorrupt = new ArrayList<BlockInfoContiguous>();
                this.reportDiff(dbBlocksMap, cloudBlocksMap, corruptBlkMap, toMissing, toCorrupt, toDelete, toUnCorrupt);
                if (toMissing.size() != 0 || toCorrupt.size() != 0 || toDelete.size() != 0) {
                    LOG.info((Object)("HopsFS-Cloud. BR toMissing: " + toMissing.size() + " toCorrupt: " + toCorrupt.size() + " toDelete: " + toDelete.size() + " Prefix: " + prefix));
                }
                this.handleMissingBlocks(toMissing);
                this.handleCorruptBlocks(toCorrupt);
                this.handleToDeleteBlocks(toDelete);
                this.handleToUnCorruptBlocks(toUnCorrupt);
                this.handleGCSFailedMultipartUploads(prefix + "partial-blocks");
                start = end;
            }
            successful = true;
            return successful;
        }
        catch (Exception e) {
            LOG.warn((Object)e, (Throwable)e);
        }
        finally {
            return successful;
        }
    }

    public List<ProvidedBlockReportTask> generateTasks(long maxBlkID) {
        ArrayList<ProvidedBlockReportTask> tasks = new ArrayList<ProvidedBlockReportTask>();
        long startIndex = 0L;
        while (startIndex < maxBlkID) {
            long endIndex = startIndex + this.subTaskSize;
            ProvidedBlockReportTask task = new ProvidedBlockReportTask(startIndex, endIndex, 0L, -1L);
            tasks.add(task);
            startIndex = endIndex;
        }
        return tasks;
    }

    @VisibleForTesting
    public void reportDiff(Map<BlockIDAndGSTuple, BlockInfoContiguous> dbView, Map<BlockIDAndGSTuple, CloudBlock> cView, Map<Long, UnderReplicatedBlock> corruptView, List<BlockInfoContiguous> toMissing, List<BlockToMarkCorrupt> toCorrupt, List<CloudBlock> toDelete, List<BlockInfoContiguous> toUnCorrupt) throws IOException {
        HashSet<BlockIDAndGSTuple> aggregatedSafeBlocks = new HashSet<BlockIDAndGSTuple>();
        aggregatedSafeBlocks.addAll(dbView.keySet());
        for (BlockIDAndGSTuple dbBlockKey : dbView.keySet()) {
            BlockInfoContiguous dbBlock = dbView.get(dbBlockKey);
            CloudBlock cblock = cView.get(dbBlockKey);
            BlockToMarkCorrupt cb = null;
            if (dbBlock instanceof BlockInfoContiguousUnderConstruction) {
                if (cView.containsKey(dbBlockKey)) {
                    cView.remove(dbBlockKey);
                }
                aggregatedSafeBlocks.remove(dbBlock.getBlockId());
                continue;
            }
            if (cblock == null || cblock.isPartiallyListed()) {
                long lastModifiedTime = dbBlock.getTimestamp();
                if (cblock != null && cblock.getLastModified() > lastModifiedTime) {
                    lastModifiedTime = cblock.getLastModified();
                }
                if (System.currentTimeMillis() - lastModifiedTime > this.markBlocksCorruptOrMissingDelay) {
                    toMissing.add(dbBlock);
                    aggregatedSafeBlocks.remove(dbBlock.getBlockId());
                }
                cView.remove(dbBlockKey);
                LOG.info((Object)("HopsFS-Cloud: BR delayed action on DB: " + (Object)((Object)dbBlock) + " Cloud: " + (cblock == null ? "null" : cblock)));
                continue;
            }
            if (cblock.getBlock().getNumBytes() != dbBlock.getNumBytes()) {
                cb = new BlockToMarkCorrupt(cblock, dbBlock, "Block size mismatch", CorruptReplicasMap.Reason.SIZE_MISMATCH);
            } else if (cblock.getBlock().getCloudBucket().compareToIgnoreCase(dbBlock.getCloudBucket()) != 0) {
                cb = new BlockToMarkCorrupt(cblock, dbBlock, "Cloud bucket mismatch", CorruptReplicasMap.Reason.INVALID_STATE);
            } else {
                cView.remove(dbBlockKey);
                if (corruptView.containsKey(dbBlockKey.getBlockID())) {
                    toUnCorrupt.add(dbBlock);
                }
            }
            if (cb == null) continue;
            toCorrupt.add(cb);
            aggregatedSafeBlocks.remove(dbBlock.getBlockId());
            cView.remove(dbBlockKey);
        }
        for (BlockIDAndGSTuple tuple : cView.keySet()) {
            boolean timeout;
            CloudBlock cloudBlock = cView.get(tuple);
            if (this.belongsToBlkUC(dbView, cloudBlock)) continue;
            BlockInfoContiguous dbBlock = this.removeFromDBMissing(cloudBlock.getBlock().getBlockId(), toMissing);
            boolean dbMissingFromCloud = dbBlock == null;
            boolean bl = timeout = System.currentTimeMillis() - cloudBlock.getLastModified() > this.markBlocksCorruptOrMissingDelay;
            if (dbMissingFromCloud && timeout) {
                toDelete.add(cloudBlock);
                continue;
            }
            if (!dbMissingFromCloud && timeout) {
                toCorrupt.add(new BlockToMarkCorrupt(cloudBlock, dbBlock, "Block GS mismatch", CorruptReplicasMap.Reason.GENSTAMP_MISMATCH));
                continue;
            }
            LOG.info((Object)("HopsFS-Cloud: BR delayed action on DB: " + (Object)((Object)dbBlock) + " Cloud: " + cloudBlock));
        }
        if (this.ns.isInStartupSafeMode()) {
            LOG.info((Object)("HopsFS-Cloud. BR Aggregated safe block #: " + aggregatedSafeBlocks.size()));
            HashSet<Long> aggregatedSafeBlocksIDs = new HashSet<Long>();
            for (BlockIDAndGSTuple tuple : aggregatedSafeBlocks) {
                aggregatedSafeBlocksIDs.add(tuple.getBlockID());
            }
            this.ns.adjustSafeModeBlocks(aggregatedSafeBlocksIDs);
        }
    }

    private boolean belongsToBlkUC(Map<BlockIDAndGSTuple, BlockInfoContiguous> dbView, CloudBlock cb) {
        for (BlockInfoContiguous bc : dbView.values()) {
            if (bc.getBlockId() != cb.getBlock().getBlockId()) continue;
            return bc.getBlockUCState() != HdfsServerConstants.BlockUCState.COMPLETE;
        }
        return false;
    }

    private BlockInfoContiguous removeFromDBMissing(Long blockID, List<BlockInfoContiguous> missingBlocks) {
        int found = -1;
        for (int i = 0; i < missingBlocks.size(); ++i) {
            BlockInfoContiguous block = missingBlocks.get(i);
            if (block.getBlockId() != blockID.longValue()) continue;
            found = i;
        }
        if (found != -1) {
            return missingBlocks.remove(found);
        }
        return null;
    }

    private void handleMissingBlocks(List<BlockInfoContiguous> missingBlocks) throws IOException {
        for (BlockInfoContiguous blk : missingBlocks) {
            LOG.info((Object)("HopsFS-Cloud: BR Marking block " + (Object)((Object)blk) + " corrupt because it is missing"));
            this.addCorrptUnderReplicatedBlock(blk);
        }
    }

    private void handleCorruptBlocks(List<BlockToMarkCorrupt> corruptBlocks) throws IOException {
        for (BlockToMarkCorrupt b : corruptBlocks) {
            LOG.info((Object)("HopsFS-Cloud: BR Marking block " + (Object)((Object)b.stored) + " corrupt because " + b.reason));
            this.addCorrptUnderReplicatedBlock(b.stored);
        }
    }

    private void handleToUnCorruptBlocks(List<BlockInfoContiguous> unCorruptBlocks) throws IOException {
        for (BlockInfoContiguous b : unCorruptBlocks) {
            LOG.info((Object)("HopsFS-Cloud: BR Marking block " + (Object)((Object)b) + " as not corrupt"));
            this.removeCorruptUnderReplicatedBlock(b);
        }
    }

    private void addCorrptUnderReplicatedBlock(final BlockInfoContiguous block) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.CLOUD_ADD_CORRUPT_BLOCKS){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock(block);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier));
                locks.add(lf.getIndividualBlockLock(block.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(LockFactory.BLK.UR));
            }

            public Object performTask() throws StorageException, IOException {
                ((ProvidedBlocksChecker)ProvidedBlocksChecker.this).bm.neededReplications.add(block, 0, 0, 1);
                return null;
            }
        }.handle();
    }

    private void removeCorruptUnderReplicatedBlock(final BlockInfoContiguous block) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.CLOUD_ADD_CORRUPT_BLOCKS){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock(block);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier));
                locks.add(lf.getIndividualBlockLock(block.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(LockFactory.BLK.UR));
            }

            public Object performTask() throws StorageException, IOException {
                ((ProvidedBlocksChecker)ProvidedBlocksChecker.this).bm.neededReplications.remove(block);
                return null;
            }
        }.handle();
    }

    @VisibleForTesting
    public int handleToDeleteBlocks(List<CloudBlock> toDelete) throws IOException {
        ArrayList invblks = new ArrayList();
        int count = 0;
        for (CloudBlock cblock : toDelete) {
            if (!this.handleToDeleteBlock(cblock)) continue;
            ++count;
        }
        return count;
    }

    private boolean handleToDeleteBlock(final CloudBlock cblock) throws IOException {
        HopsTransactionalRequestHandler processDeletedBlock = new HopsTransactionalRequestHandler(HDFSOperationType.DELETE_CLOUD_BLKS_BY_BLK_RPT){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock(cblock.getBlock());
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                if (this.inodeIdentifier != null) {
                    locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier, true));
                    locks.add(lf.getIndividualBlockLock(cblock.getBlock().getBlockId(), this.inodeIdentifier));
                    locks.add(lf.getBlockRelated(LockFactory.BLK.IV));
                }
            }

            public Object performTask() throws IOException {
                boolean delete = true;
                if (this.inodeIdentifier != null) {
                    INode file = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{this.inodeIdentifier.getInodeId()});
                    if (file == null) {
                        LOG.info((Object)("HopsFS-Cloud. BR. Deleting block that does not belong to any file. Block: " + cblock));
                    } else {
                        BlockInfoContiguous blockInfo = (BlockInfoContiguous)((Object)EntityManager.find((FinderType)BlockInfoContiguous.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{cblock.getBlock().getBlockId(), this.inodeIdentifier.getInodeId()}));
                        if (blockInfo != null && blockInfo.getGenerationStamp() == cblock.getBlock().getGenerationStamp()) {
                            LOG.warn((Object)("HopsFS-Cloud. BR. Ignoring delete request for block ID: " + blockInfo.getBlockId() + " GS: " + blockInfo.getGenerationStamp() + " inode ID: " + file.getId()));
                            delete = false;
                        }
                    }
                }
                if (delete) {
                    LOG.info((Object)("HopsFS-Cloud. BR Deleting block id=" + cblock.getBlock()));
                    Block block = cblock.getBlock();
                    InvalidatedBlock invBlk = new InvalidatedBlock(-1, block.getBlockId(), block.getGenerationStamp(), CloudHelper.getCloudBucketID(block.getCloudBucket()), Long.MAX_VALUE, (long)INode.NON_EXISTING_INODE_ID, true);
                    ArrayList<InvalidatedBlock> invblks = new ArrayList<InvalidatedBlock>();
                    invblks.add(invBlk);
                    ProvidedBlocksChecker.this.bm.getInvalidateBlocks().addAll(invblks);
                    return true;
                }
                return false;
            }
        };
        return (Boolean)processDeletedBlock.handle();
    }

    public void shutDown() {
        this.run = false;
        this.interrupt();
    }

    public void findAllBlocksRange(final long startID, final long endID, final Map<BlockIDAndGSTuple, BlockInfoContiguous> blkMap, final Map<Long, UnderReplicatedBlock> corruptBlkMap) throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.BR_GET_RANGE_OF_BLOCKS){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws IOException {
                BlockLookUpDataAccess da = (BlockLookUpDataAccess)HdfsStorageFactory.getDataAccess(BlockLookUpDataAccess.class);
                long[] allBlockIDs = new long[(int)(endID - startID)];
                int index = 0;
                long blockID = startID;
                while (blockID < endID) {
                    allBlockIDs[index] = blockID++;
                    ++index;
                }
                long[] allInodeIDs = da.findINodeIdsByBlockIds(allBlockIDs);
                assert (allInodeIDs.length == allBlockIDs.length);
                LinkedList<Long> blockIdsArr = new LinkedList<Long>();
                LinkedList<Long> inodeIdsArr = new LinkedList<Long>();
                for (int i = 0; i < allInodeIDs.length; ++i) {
                    if (allInodeIDs[i] <= 1L) continue;
                    inodeIdsArr.add(allInodeIDs[i]);
                    blockIdsArr.add(allBlockIDs[i]);
                }
                ProvidedBlocksChecker.this.getCloudBlock(blockIdsArr.stream().mapToLong(l -> l).toArray(), inodeIdsArr.stream().mapToLong(l -> l).toArray(), blkMap);
                ProvidedBlocksChecker.this.getCorruptCloudBlocks(blkMap, corruptBlkMap);
                return null;
            }
        };
        handler.handle();
    }

    private void getCloudBlock(long[] blockIDs, long[] inodeIDs, Map<BlockIDAndGSTuple, BlockInfoContiguous> outBlkMap) throws StorageException {
        BlockInfoDataAccess bda = (BlockInfoDataAccess)HdfsStorageFactory.getDataAccess(BlockInfoDataAccess.class);
        List existingBlocks = bda.findByIds(blockIDs, inodeIDs);
        for (BlockInfoContiguous blk : existingBlocks) {
            if (!blk.isProvidedBlock()) continue;
            outBlkMap.put(new BlockIDAndGSTuple(blk.getBlockId(), blk.getGenerationStamp()), blk);
        }
    }

    private void getCorruptCloudBlocks(Map<BlockIDAndGSTuple, BlockInfoContiguous> inBlkMap, Map<Long, UnderReplicatedBlock> outCorruptMap) throws StorageException {
        long[] inodeIDs = new long[inBlkMap.size()];
        long[] blkIDs = new long[inBlkMap.size()];
        int index = 0;
        for (BlockInfoContiguous blk : inBlkMap.values()) {
            inodeIDs[index] = blk.getInodeId();
            blkIDs[index] = blk.getBlockId();
            ++index;
        }
        UnderReplicatedBlockDataAccess urbda = (UnderReplicatedBlockDataAccess)HdfsStorageFactory.getDataAccess(UnderReplicatedBlockDataAccess.class);
        List corruptBlocks = urbda.findByIds(inodeIDs, blkIDs);
        for (UnderReplicatedBlock blk : corruptBlocks) {
            outCorruptMap.put(blk.getBlockId(), blk);
        }
    }

    public static void scheduleBlockReportNow() throws IOException {
        LOG.debug((Object)"HopsFS-Cloud. BR Scheduling a block report now");
        ProvidedBlocksChecker.setProvidedBlocksScanStartTime(0L);
    }

    public ProvidedBlockReportTask popPendingBRTask() throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.BR_POP_TASK){

            public void acquireLock(TransactionLocks locks) throws IOException {
                HdfsStorageFactory.getConnector().writeLock();
                LongVariable var = (LongVariable)Variables.getVariable((Variable.Finder)Variable.Finder.providedBlocksCheckStartTime);
            }

            public Object performTask() throws IOException {
                EntityManager.preventStorageCall((boolean)false);
                ProvidedBlockReportTasksDataAccess da = (ProvidedBlockReportTasksDataAccess)HdfsStorageFactory.getDataAccess(ProvidedBlockReportTasksDataAccess.class);
                ProvidedBlockReportTask task = (ProvidedBlockReportTask)da.popTask();
                LOG.debug((Object)("HopsFS-Cloud. BR pulled a task from queue Task: " + task));
                return task;
            }
        };
        return (ProvidedBlockReportTask)handler.handle();
    }

    public long countBRPendingTasks() throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.BR_COUNT_TASKS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                HdfsStorageFactory.getConnector().writeLock();
                LongVariable var = (LongVariable)Variables.getVariable((Variable.Finder)Variable.Finder.providedBlocksCheckStartTime);
            }

            public Object performTask() throws IOException {
                EntityManager.preventStorageCall((boolean)false);
                ProvidedBlockReportTasksDataAccess da = (ProvidedBlockReportTasksDataAccess)HdfsStorageFactory.getDataAccess(ProvidedBlockReportTasksDataAccess.class);
                return da.count();
            }
        };
        return (Long)handler.handle();
    }

    public List<ProvidedBlockReportTask> getAllTasks() throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.BR_GET_ALL_TASKS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                HdfsStorageFactory.getConnector().writeLock();
                Variables.getVariable((Variable.Finder)Variable.Finder.providedBlocksCheckStartTime);
            }

            public Object performTask() throws IOException {
                EntityManager.preventStorageCall((boolean)false);
                ProvidedBlockReportTasksDataAccess da = (ProvidedBlockReportTasksDataAccess)HdfsStorageFactory.getDataAccess(ProvidedBlockReportTasksDataAccess.class);
                return da.getAllTasks();
            }
        };
        return (List)handler.handle();
    }

    public void addNewBlockReportTasks(List<ProvidedBlockReportTask> tasks) throws IOException {
        int index = 0;
        while (index < tasks.size()) {
            int start = index;
            int end = index + 1000 > tasks.size() ? tasks.size() : index + 1000;
            this.addNewBlockReportTasks(tasks.subList(start, end), start == 0);
            index = end;
        }
    }

    public void addNewBlockReportTasks(final List<ProvidedBlockReportTask> tasks, final boolean updateCounters) throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.BR_ADD_TASKS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                HdfsStorageFactory.getConnector().writeLock();
                LongVariable var = (LongVariable)Variables.getVariable((Variable.Finder)Variable.Finder.providedBlocksCheckStartTime);
            }

            public Object performTask() throws IOException {
                EntityManager.preventStorageCall((boolean)false);
                ProvidedBlockReportTasksDataAccess da = (ProvidedBlockReportTasksDataAccess)HdfsStorageFactory.getDataAccess(ProvidedBlockReportTasksDataAccess.class);
                da.addTasks(tasks);
                if (LOG.isDebugEnabled()) {
                    for (ProvidedBlockReportTask task : tasks) {
                        LOG.debug((Object)("HopsFS-Cloud. BR Added new block report tasks " + task));
                    }
                }
                if (updateCounters) {
                    long startTime = System.currentTimeMillis();
                    Variables.updateVariable((Variable)new LongVariable(Variable.Finder.providedBlocksCheckStartTime, startTime));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("HopsFS-Cloud. BR set start time to : " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(startTime))));
                    }
                    long counter = (Long)Variables.getVariable((Variable.Finder)Variable.Finder.providedBlockReportsCount).getValue();
                    Variables.updateVariable((Variable)new LongVariable(Variable.Finder.providedBlockReportsCount, counter + 1L));
                    LOG.debug((Object)("HopsFS-Cloud. BR set counter to : " + (counter + 1L)));
                }
                return null;
            }
        };
        handler.handle();
    }

    public long getProvidedBlockReportsCount() throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.BR_COUNT_TASKS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                HdfsStorageFactory.getConnector().writeLock();
                LongVariable var = (LongVariable)Variables.getVariable((Variable.Finder)Variable.Finder.providedBlocksCheckStartTime);
            }

            public Object performTask() throws IOException {
                EntityManager.preventStorageCall((boolean)false);
                long counter = (Long)Variables.getVariable((Variable.Finder)Variable.Finder.providedBlockReportsCount).getValue();
                LOG.debug((Object)("HopsFS-Cloud. BR get counter : " + counter));
                return counter;
            }
        };
        return (Long)handler.handle();
    }

    public long getProvidedBlocksScanStartTime() throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_PROVIDED_BLOCK_CHECK_START_TIME){

            public void acquireLock(TransactionLocks locks) throws IOException {
                HdfsStorageFactory.getConnector().writeLock();
                LongVariable var = (LongVariable)Variables.getVariable((Variable.Finder)Variable.Finder.providedBlocksCheckStartTime);
            }

            public Object performTask() throws IOException {
                EntityManager.preventStorageCall((boolean)false);
                long time = (Long)Variables.getVariable((Variable.Finder)Variable.Finder.providedBlocksCheckStartTime).getValue();
                if (LOG.isDebugEnabled()) {
                    LOG.trace((Object)("HopsFS-Cloud. BR get start time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(time))));
                }
                return time;
            }
        };
        return (Long)handler.handle();
    }

    private static void setProvidedBlocksScanStartTime(final long newTime) throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.UPDATE_PROVIDED_BLOCK_CHECK_START_TIME){

            public void acquireLock(TransactionLocks locks) throws IOException {
                HdfsStorageFactory.getConnector().writeLock();
                LongVariable var = (LongVariable)Variables.getVariable((Variable.Finder)Variable.Finder.providedBlocksCheckStartTime);
            }

            public Object performTask() throws IOException {
                EntityManager.preventStorageCall((boolean)false);
                Variables.updateVariable((Variable)new LongVariable(Variable.Finder.providedBlocksCheckStartTime, newTime));
                LOG.debug((Object)("HopsFS-Cloud. BR set start time to: " + newTime));
                return null;
            }
        };
        handler.handle();
    }

    public static void deleteAllTask() throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.BR_DELETE_ALL_TASKS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                HdfsStorageFactory.getConnector().writeLock();
                LongVariable var = (LongVariable)Variables.getVariable((Variable.Finder)Variable.Finder.providedBlocksCheckStartTime);
            }

            public Object performTask() throws IOException {
                EntityManager.preventStorageCall((boolean)false);
                ProvidedBlockReportTasksDataAccess da = (ProvidedBlockReportTasksDataAccess)HdfsStorageFactory.getDataAccess(ProvidedBlockReportTasksDataAccess.class);
                da.deleteAll();
                LOG.debug((Object)"HopsFS-Cloud. BR Deleted all tasks");
                return null;
            }
        };
        handler.handle();
    }

    void handleGCSFailedMultipartUploads(String prefix) throws IOException {
        if (this.isGCSMultipartUpload) {
            List<ActiveMultipartUploads> partialBlocks = this.cloudConnector.listMultipartUploads(Lists.newArrayList(CloudHelper.getAllBuckets().keySet()), prefix);
            for (ActiveMultipartUploads pb : partialBlocks) {
                GCSActiveMultipartUploads gcsPB = (GCSActiveMultipartUploads)pb;
                BlockInfoContiguous blockInfo = this.findBlockInfo(gcsPB.getId().getBlockID());
                if (blockInfo == null) {
                    for (Blob blob : gcsPB.getParts()) {
                        LOG.info((Object)("HopsFS-Cloud. BR Corresponding blockinfo not found for parts. Block " + gcsPB.getId().toString() + " Deleting Part: " + blob.getName()));
                        this.cloudConnector.deleteObject(blob.getBucket(), blob.getName());
                    }
                    continue;
                }
                if (blockInfo instanceof BlockInfoContiguousUnderConstruction) {
                    LOG.info((Object)("HopsFS-Cloud. Not deleting multipart as the Block is under construction. Block " + gcsPB.getId().toString()));
                    continue;
                }
                if (!blockInfo.isComplete()) continue;
                for (Blob blob : gcsPB.getParts()) {
                    LOG.info((Object)("HopsFS-Cloud. Block is complete. Deleting multipart. Part" + blob.getName() + " Block " + gcsPB.getId().toString()));
                    this.cloudConnector.deleteObject(blob.getBucket(), blob.getName());
                }
            }
        }
    }

    public BlockInfoContiguous findBlockInfo(final long bid) throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_BLOCK_BY_BID){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws IOException {
                BlockLookUpDataAccess da = (BlockLookUpDataAccess)HdfsStorageFactory.getDataAccess(BlockLookUpDataAccess.class);
                long[] allBlockIDs = new long[]{bid};
                long[] allInodeIDs = da.findINodeIdsByBlockIds(allBlockIDs);
                if (allInodeIDs.length != 1) {
                    return null;
                }
                BlockInfoDataAccess bda = (BlockInfoDataAccess)HdfsStorageFactory.getDataAccess(BlockInfoDataAccess.class);
                return bda.findById(bid, allInodeIDs[0]);
            }
        };
        return (BlockInfoContiguous)((Object)handler.handle());
    }

    void checkS3AbandonedBlocks() throws IOException {
        if (this.isS3MultipartUpload) {
            for (ActiveMultipartUploads u : this.cloudConnector.listMultipartUploads(Lists.newArrayList(CloudHelper.getAllBuckets().keySet()), "")) {
                S3ActiveMultipartUploads upload = (S3ActiveMultipartUploads)u;
                long elapsedTime = System.currentTimeMillis() - upload.getStartTime();
                if (elapsedTime <= this.deleteAbandonedBlocksAfter) continue;
                this.cloudConnector.abortMultipartUpload(upload.getBucket(), upload.getObjectID(), upload.getUploadID());
            }
        }
    }

    public boolean isBRInProgress() {
        return this.isBRInProgress;
    }

    public class BlockToMarkCorrupt {
        final CloudBlock corrupted;
        final BlockInfoContiguous stored;
        final String reason;
        final CorruptReplicasMap.Reason reasonCode;

        BlockToMarkCorrupt(CloudBlock corrupted, BlockInfoContiguous stored, String reason, CorruptReplicasMap.Reason reasonCode) {
            Preconditions.checkNotNull((Object)((Object)stored), (Object)"stored is null");
            this.corrupted = corrupted;
            this.stored = stored;
            this.reason = reason;
            this.reasonCode = reasonCode;
        }

        public String toString() {
            return (Object)((Object)this.stored) + " Reason: " + this.reason;
        }
    }

    class BRTasksPullers
    implements Callable {
        private int id;
        private int count;

        BRTasksPullers(int id) {
            this.id = id;
        }

        public Object call() throws Exception {
            ProvidedBlockReportTask task = null;
            long startTime = System.currentTimeMillis();
            do {
                if ((task = ProvidedBlocksChecker.this.popPendingBRTask()) != null) {
                    ProvidedBlocksChecker.this.processTask(task);
                    ++this.count;
                    continue;
                }
                LOG.info((Object)("HopsFS-Cloud. BR Worker ID: " + this.id + " processed " + this.count + " tasks. Total Processing time: " + (System.currentTimeMillis() - startTime) + " ms."));
                return null;
            } while (!Thread.currentThread().isInterrupted());
            return null;
        }
    }
}

