/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.ProvidedBlockCacheLocDataAccess;
import io.hops.metadata.hdfs.entity.ProvidedBlockCacheLoc;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.protocol.RemovedBlock;

public class ProvidedBlocksCacheHelper {
    public static final Log LOG = LogFactory.getLog(ProvidedBlocksCacheHelper.class);

    public static void deleteProvidedBlockCacheLocationTx(final List<RemovedBlock> deletedBlocks) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.DELETE_CLOUD_BLKS_CACHE_LOC){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws IOException {
                ProvidedBlockCacheLocDataAccess da = (ProvidedBlockCacheLocDataAccess)HdfsStorageFactory.getDataAccess(ProvidedBlockCacheLocDataAccess.class);
                ProvidedBlocksCacheHelper.deleteProvidedBlockCacheLocInternal(deletedBlocks, da);
                return null;
            }
        }.handle();
    }

    private static void deleteProvidedBlockCacheLocInternal(List<RemovedBlock> deletedBlocks, ProvidedBlockCacheLocDataAccess da) throws StorageException {
        Long[] blkIDs = new Long[deletedBlocks.size()];
        for (int i = 0; i < deletedBlocks.size(); ++i) {
            blkIDs[i] = deletedBlocks.get(i).getBlockId();
        }
        Map cacheLocMap = da.findByBlockIDs(blkIDs);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud. Deleting cache entry for block ID: " + Arrays.toString(cacheLocMap.values().toArray())));
        }
        da.prepare(cacheLocMap.values(), Collections.emptyList(), Collections.emptyList());
    }

    public static Map<Long, ProvidedBlockCacheLoc> batchReadCacheLocsTx(final List<RemovedBlock> blocks) throws IOException {
        HopsTransactionalRequestHandler h = new HopsTransactionalRequestHandler(HDFSOperationType.BATCH_READ_CLOUD_BLKS_CACHE_LOCS){

            public Object performTask() throws IOException {
                ProvidedBlockCacheLocDataAccess da = (ProvidedBlockCacheLocDataAccess)HdfsStorageFactory.getDataAccess(ProvidedBlockCacheLocDataAccess.class);
                Object[] locs = new Long[blocks.size()];
                for (int i = 0; i < blocks.size(); ++i) {
                    locs[i] = ((RemovedBlock)blocks.get(i)).getBlockId();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("HopsFS-Cloud. Batch read cache entries for block IDs: " + Arrays.toString(locs)));
                }
                return da.findByBlockIDs((Long[])locs);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
            }
        };
        return (Map)h.handle();
    }
}

