/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.collect.Iterables;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.ProvidedBlockCacheLoc;
import io.hops.metadata.hdfs.entity.Replica;
import io.hops.metadata.hdfs.entity.ReplicaBase;
import io.hops.transaction.EntityManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HashBuckets;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;

@InterfaceAudience.Private
public class BlockInfoContiguous
extends Block {
    public static final BlockInfoContiguous[] EMPTY_ARRAY = new BlockInfoContiguous[0];
    private static final List<Replica> EMPTY_REPLICAS_ARRAY = new ArrayList<Replica>();
    public static int NON_EXISTING_ID = -1;
    protected BlockCollection bc;
    private int blockIndex = -1;
    private long timestamp = 1L;
    protected long inodeId = NON_EXISTING_ID;
    public static final Log LOG = LogFactory.getLog(BlockInfoContiguous.class);

    public BlockInfoContiguous(Block blk, long inodeId) {
        super(blk);
        this.inodeId = inodeId;
        this.timestamp = System.currentTimeMillis();
        if (blk instanceof BlockInfoContiguous) {
            this.bc = ((BlockInfoContiguous)blk).bc;
            this.blockIndex = ((BlockInfoContiguous)blk).blockIndex;
            this.timestamp = ((BlockInfoContiguous)blk).timestamp;
            if (inodeId != ((BlockInfoContiguous)blk).inodeId) {
                throw new IllegalArgumentException("inodeId does not match");
            }
        }
    }

    public BlockInfoContiguous() {
        this.bc = null;
    }

    protected BlockInfoContiguous(BlockInfoContiguous from) {
        super((Block)from);
        this.bc = from.bc;
        this.blockIndex = from.blockIndex;
        this.timestamp = from.timestamp;
        this.inodeId = from.inodeId;
    }

    public BlockCollection getBlockCollection() throws StorageException, TransactionContextException {
        BlockCollection bc;
        this.bc = bc = (BlockCollection)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{this.inodeId});
        if (bc == null) {
            this.inodeId = NON_EXISTING_ID;
        }
        return bc;
    }

    public void setBlockCollection(BlockCollection bc) throws StorageException, TransactionContextException {
        this.bc = bc;
        if (bc != null) {
            this.setINodeId(bc.getId());
        }
    }

    public boolean isDeleted() throws StorageException, TransactionContextException {
        this.getBlockCollection();
        return this.bc == null;
    }

    public int numNodes(DatanodeManager datanodeMgr) throws StorageException, TransactionContextException {
        if (this.isProvidedBlock()) {
            return 1;
        }
        return this.getReplicas(datanodeMgr).size();
    }

    public DatanodeStorageInfo[] getStorages(DatanodeManager datanodeMgr) throws IOException {
        List<Replica> replicas = this.getReplicas(datanodeMgr);
        if (this.isComplete() && this.isProvidedBlock()) {
            return this.phantomStoragesForProvidedBlocks(datanodeMgr);
        }
        return this.getStorages(datanodeMgr, replicas);
    }

    public DatanodeStorageInfo[] phantomStoragesForProvidedBlocks(DatanodeManager dnMgm) throws IOException {
        DatanodeDescriptor dns;
        ArrayList<DatanodeStorageInfo> ret = new ArrayList<DatanodeStorageInfo>();
        ProvidedBlockCacheLoc loc = (ProvidedBlockCacheLoc)EntityManager.find((FinderType)ProvidedBlockCacheLoc.Finder.ByBlockId, (Object[])new Object[]{this.getBlockId()});
        if (loc != null && (dns = dnMgm.getDatanodeBySid(loc.getStorageID())) != null && !dnMgm.isDatanodeDead(dns) && !dns.isStale(dnMgm.getStaleInterval())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HopsFS-Cloud. The block ID: " + this.getBlockId() + " is cached on DN: " + dns.toString()));
            }
            DatanodeStorageInfo storageInfo = dnMgm.getStorage(loc.getStorageID());
            ret.add(storageInfo);
        }
        if (ret.isEmpty()) {
            ret.addAll(this.getNonStaleRandomCloudStorage(1, dnMgm, null));
            if (ret.size() > 0) {
                EntityManager.update((Object)new ProvidedBlockCacheLoc(this.getBlockId(), ((DatanodeStorageInfo)ret.get(0)).getSid()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("HopsFS-Cloud. Updating the cache location for block ID: " + this.getBlockId()));
                }
            } else {
                LOG.warn((Object)("HopsFS-Cloud. Unable to select a datanode to read the provided block: " + this.getBlockId()));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HopsFS-Cloud. Block ID: " + this.getBlockId() + " Returning Storages " + Arrays.toString(ret.toArray())));
        }
        return (DatanodeStorageInfo[])Iterables.toArray(ret, DatanodeStorageInfo.class);
    }

    public List<DatanodeStorageInfo> getNonStaleRandomCloudStorage(int count, DatanodeManager dnMgm, DatanodeInfo ignoreDN) {
        ArrayList<DatanodeStorageInfo> ret = new ArrayList<DatanodeStorageInfo>();
        List<DatanodeDescriptor> dnDescs = dnMgm.getRandomDN(dnMgm.getNumLiveDataNodes());
        for (DatanodeDescriptor dnDesc : dnDescs) {
            if (ignoreDN != null && dnDesc.equals(ignoreDN)) continue;
            List<DatanodeStorageInfo> storages = Arrays.asList(dnDesc.getStorageInfos());
            Collections.shuffle(storages);
            for (DatanodeStorageInfo info : storages) {
                DatanodeDescriptor dnd = dnMgm.getDatanodeBySid(info.getSid());
                if (info.getStorageType() != StorageType.CLOUD || dnd.isStale(dnMgm.getStaleInterval())) continue;
                ret.add(info);
                break;
            }
            if (ret.size() != count) continue;
            break;
        }
        return ret;
    }

    public DatanodeStorageInfo[] getStorages(DatanodeManager datanodeMgr, DatanodeStorage.State state) throws StorageException, TransactionContextException {
        List<Replica> replicas = this.getReplicas(datanodeMgr);
        return this.getStorages(datanodeMgr, replicas, state);
    }

    public DatanodeStorageInfo getStorageOnNode(DatanodeDescriptor node) throws TransactionContextException, StorageException {
        DatanodeStorageInfo[] storagesOnNode;
        for (DatanodeStorageInfo s : storagesOnNode = node.getStorageInfos()) {
            if (!this.isReplicatedOnStorage(s)) continue;
            return s;
        }
        return null;
    }

    private List<Replica> getReplicasNoCheck() throws StorageException, TransactionContextException {
        List<Replica> replicas = (List<Replica>)EntityManager.findList((FinderType)Replica.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{this.getBlockId(), this.getInodeId()});
        if (replicas == null) {
            replicas = EMPTY_REPLICAS_ARRAY;
        } else {
            Collections.sort(replicas, Replica.Order.ByStorageId);
        }
        return replicas;
    }

    public List<Replica> getReplicas(DatanodeManager datanodeMgr) throws StorageException, TransactionContextException {
        List<Replica> replicas = this.getReplicasNoCheck();
        this.getDatanodes(datanodeMgr, replicas);
        return replicas;
    }

    boolean addStorage(DatanodeStorageInfo storage) throws StorageException, TransactionContextException {
        Replica replica = new Replica(storage.getSid(), this.getBlockId(), this.getInodeId(), HashBuckets.getInstance().getBucketForBlock(this));
        this.update(replica);
        return true;
    }

    void removeAllReplicas() throws StorageException, TransactionContextException {
        for (Replica replica : this.getReplicasNoCheck()) {
            this.remove(replica);
            HashBuckets hashBuckets = HashBuckets.getInstance();
            hashBuckets.undoHash(replica.getStorageId(), HdfsServerConstants.ReplicaState.FINALIZED, this);
        }
    }

    Replica removeReplica(DatanodeStorageInfo storage) throws StorageException, TransactionContextException {
        List<Replica> replicas = this.getReplicasNoCheck();
        Replica replica = null;
        for (Replica r : replicas) {
            if (r.getStorageId() != storage.getSid()) continue;
            replica = r;
            this.remove(r);
            break;
        }
        return replica;
    }

    Replica removeReplica(int sid) throws StorageException, TransactionContextException {
        List<Replica> replicas = this.getReplicasNoCheck();
        Replica replica = null;
        for (Replica r : replicas) {
            if (r.getStorageId() != sid) continue;
            replica = r;
            this.remove(r);
            break;
        }
        return replica;
    }

    public Integer getReplicatedOnDatanode(DatanodeDescriptor dn) throws StorageException, TransactionContextException {
        DatanodeStorageInfo[] storages = dn.getStorageInfos();
        HashSet<Integer> sids = new HashSet<Integer>();
        for (DatanodeStorageInfo s : storages) {
            sids.add(s.getSid());
        }
        List list = (List)EntityManager.findList((FinderType)Replica.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{this.getBlockId(), this.getInodeId()});
        if (list != null) {
            for (Replica replica : list) {
                if (!sids.contains(replica.getStorageId())) continue;
                return replica.getStorageId();
            }
        }
        return null;
    }

    boolean isReplicatedOnStorage(DatanodeStorageInfo storage) throws StorageException, TransactionContextException {
        Replica replica = (Replica)EntityManager.find((FinderType)Replica.Finder.ByBlockIdAndStorageId, (Object[])new Object[]{this.getBlockId(), storage.getSid()});
        return replica != null;
    }

    public HdfsServerConstants.BlockUCState getBlockUCState() {
        return HdfsServerConstants.BlockUCState.COMPLETE;
    }

    public boolean isComplete() {
        return this.getBlockUCState().equals((Object)HdfsServerConstants.BlockUCState.COMPLETE);
    }

    public BlockInfoContiguousUnderConstruction convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState s, DatanodeStorageInfo[] targets) throws StorageException, TransactionContextException {
        if (this.isComplete()) {
            BlockInfoContiguousUnderConstruction ucBlock = new BlockInfoContiguousUnderConstruction(this, this.getInodeId(), s, targets);
            ucBlock.setBlockCollection(this.getBlockCollection());
            return ucBlock;
        }
        BlockInfoContiguousUnderConstruction ucBlock = (BlockInfoContiguousUnderConstruction)this;
        ucBlock.setBlockUCState(s);
        ucBlock.setExpectedLocations(targets);
        ucBlock.setBlockCollection(this.getBlockCollection());
        return ucBlock;
    }

    public long getInodeId() {
        return this.inodeId;
    }

    public void setINodeIdNoPersistance(long id) {
        this.inodeId = id;
    }

    public void setINodeId(long id) throws StorageException, TransactionContextException {
        this.setINodeIdNoPersistance(id);
        this.save();
    }

    public int getBlockIndex() {
        return this.blockIndex;
    }

    public void setBlockIndexNoPersistance(int bindex) {
        this.blockIndex = bindex;
    }

    public void setBlockIndex(int bindex) throws StorageException, TransactionContextException {
        this.setBlockIndexNoPersistance(bindex);
        this.save();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestampNoPersistance(long ts) {
        this.timestamp = ts;
    }

    public void setTimestamp(long ts) throws StorageException, TransactionContextException {
        this.setTimestampNoPersistance(ts);
        this.save();
    }

    protected DatanodeStorageInfo[] getStorages(DatanodeManager datanodeMgr, List<? extends ReplicaBase> replicas) {
        int numLocations = replicas.size();
        HashSet<DatanodeStorageInfo> set = new HashSet<DatanodeStorageInfo>();
        for (int i = numLocations - 1; i >= 0; --i) {
            DatanodeStorageInfo desc = datanodeMgr.getStorage(replicas.get(i).getStorageId());
            if (desc != null) {
                set.add(desc);
                continue;
            }
            replicas.remove(i);
        }
        DatanodeStorageInfo[] storages = new DatanodeStorageInfo[set.size()];
        return set.toArray(storages);
    }

    protected DatanodeStorageInfo[] getStorages(DatanodeManager datanodeMgr, List<? extends ReplicaBase> replicas, DatanodeStorage.State state) {
        int numLocations = replicas.size();
        HashSet<DatanodeStorageInfo> set = new HashSet<DatanodeStorageInfo>();
        for (int i = numLocations - 1; i >= 0; --i) {
            DatanodeStorageInfo desc = datanodeMgr.getStorage(replicas.get(i).getStorageId());
            if (desc != null && desc.getState().equals((Object)state)) {
                set.add(desc);
                continue;
            }
            replicas.remove(i);
        }
        DatanodeStorageInfo[] storages = new DatanodeStorageInfo[set.size()];
        return set.toArray(storages);
    }

    protected DatanodeDescriptor[] getDatanodes(DatanodeManager datanodeMgr, List<? extends ReplicaBase> replicas) {
        int numLocations = replicas.size();
        HashSet<DatanodeDescriptor> datanodes = new HashSet<DatanodeDescriptor>();
        for (int i = numLocations - 1; i >= 0; --i) {
            DatanodeDescriptor dn = datanodeMgr.getDatanodeBySid(replicas.get(i).getStorageId());
            if (dn != null) {
                datanodes.add(dn);
                continue;
            }
            replicas.remove(i);
        }
        DatanodeDescriptor[] locations = new DatanodeDescriptor[datanodes.size()];
        return datanodes.toArray(locations);
    }

    public DatanodeDescriptor getDatanode(DatanodeManager datanodeMgr, int i) throws StorageException, TransactionContextException {
        return this.getDatanodes(datanodeMgr, this.getReplicasNoCheck())[i];
    }

    protected void update(Replica replica) throws TransactionContextException, StorageException {
        EntityManager.update((Object)replica);
    }

    protected void remove(Replica replica) throws StorageException, TransactionContextException {
        EntityManager.remove((Object)replica);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    public String toString() {
        return super.toString() + ", State = " + (Object)((Object)this.getBlockUCState());
    }

    public void setBlockId(long bid) throws StorageException, TransactionContextException {
        this.setBlockIdNoPersistance(bid);
        this.save();
    }

    public void setNumBytes(long len) throws StorageException, TransactionContextException {
        this.setNumBytesNoPersistance(len);
        this.save();
    }

    public void setGenerationStamp(long stamp) throws StorageException, TransactionContextException {
        this.setGenerationStampNoPersistance(stamp);
        this.save();
    }

    public void set(long blkid, long len, long genStamp, String cloudBucket) throws StorageException, TransactionContextException {
        this.setNoPersistance(blkid, len, genStamp, cloudBucket);
        this.save();
    }

    protected void save() throws StorageException, TransactionContextException {
        EntityManager.update((Object)((Object)this));
    }

    protected void remove() throws StorageException, TransactionContextException {
        EntityManager.remove((Object)((Object)this));
    }

    public static BlockInfoContiguous cloneBlock(BlockInfoContiguous block) throws StorageException {
        if (block == null) {
            throw new StorageException("Unable to create a clone of the Block");
        }
        if (block instanceof BlockInfoContiguousUnderConstruction) {
            return new BlockInfoContiguousUnderConstruction(block, block.getInodeId());
        }
        return new BlockInfoContiguous(block, block.getInodeId());
    }

    public static enum Order implements Comparator<BlockInfoContiguous>
    {
        ByBlockIndex{

            @Override
            public int compare(BlockInfoContiguous o1, BlockInfoContiguous o2) {
                if (o1.getBlockIndex() == o2.getBlockIndex()) {
                    throw new IllegalStateException("A file cannot have 2 blocks with the same index. index = " + o1.getBlockIndex() + " blk1_id = " + o1.getBlockId() + " blk2_id = " + o2.getBlockId());
                }
                if (o1.getBlockIndex() < o2.getBlockIndex()) {
                    return -1;
                }
                return 1;
            }
        }
        ,
        ByBlockId{

            @Override
            public int compare(BlockInfoContiguous o1, BlockInfoContiguous o2) {
                if (o1.getBlockId() == o2.getBlockId()) {
                    return 0;
                }
                if (o1.getBlockId() < o2.getBlockId()) {
                    return -1;
                }
                return 1;
            }
        }
        ,
        ByGenerationStamp{

            @Override
            public int compare(BlockInfoContiguous o1, BlockInfoContiguous o2) {
                if (o1.getGenerationStamp() == o2.getGenerationStamp()) {
                    throw new IllegalStateException("A file cannot have 2 blocks with the same generation stamp");
                }
                if (o1.getGenerationStamp() < o2.getGenerationStamp()) {
                    return -1;
                }
                return 1;
            }
        };


        @Override
        public abstract int compare(BlockInfoContiguous var1, BlockInfoContiguous var2);

        public Comparator acsending() {
            return this;
        }

        public Comparator descending() {
            return Collections.reverseOrder(this);
        }
    }

    public static enum Finder implements FinderType<BlockInfoContiguous>
    {
        ByBlockIdAndINodeId,
        ByINodeId,
        ByINodeIds,
        ByMaxBlockIndexForINode,
        ByBlockIdsAndINodeIds,
        ByINodeIdAndIndex;


        public Class getType() {
            return BlockInfoContiguous.class;
        }

        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByBlockIdAndINodeId: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case ByBlockIdsAndINodeIds: {
                    return FinderType.Annotation.Batched;
                }
                case ByMaxBlockIndexForINode: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
                case ByINodeId: 
                case ByINodeIdAndIndex: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
                case ByINodeIds: {
                    return FinderType.Annotation.BatchedPrunedIndexScan;
                }
            }
            throw new IllegalStateException();
        }
    }
}

