/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.block;

import javax.crypto.SecretKey;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.token.delegation.DelegationKey;

@InterfaceAudience.Private
public class BlockKey
extends DelegationKey {
    private KeyType keyType;

    public BlockKey() {
    }

    public BlockKey(int keyId, long expiryDate, SecretKey key, KeyType keyType) {
        super(keyId, expiryDate, key);
        this.keyType = keyType;
    }

    public BlockKey(int keyId, long expiryDate, SecretKey key) {
        super(keyId, expiryDate, key);
    }

    public BlockKey(int keyId, long expiryDate, byte[] encodedKey) {
        super(keyId, expiryDate, encodedKey);
    }

    public void setKeyType(KeyType keyType) {
        if (keyType != KeyType.CurrKey && keyType != KeyType.NextKey && keyType != KeyType.SimpleKey) {
            throw new IllegalArgumentException("Wrong key type " + (Object)((Object)keyType));
        }
        this.keyType = keyType;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public boolean isCurrKey() {
        return this.keyType == KeyType.CurrKey;
    }

    public boolean isNextKey() {
        return this.keyType == KeyType.NextKey;
    }

    public boolean isSimpleKey() {
        return this.keyType == KeyType.SimpleKey;
    }

    public static enum KeyType {
        CurrKey,
        NextKey,
        SimpleKey;

    }
}

