/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.datatransfer.Op;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.htrace.core.SpanId;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class Receiver
implements DataTransferProtocol {
    private final Tracer tracer;
    protected DataInputStream in;

    protected Receiver(Tracer tracer) {
        this.tracer = tracer;
    }

    protected void initialize(DataInputStream in) {
        this.in = in;
    }

    protected final Op readOp() throws IOException {
        short version = this.in.readShort();
        if (version != 28) {
            throw new IOException("Version Mismatch (Expected: 28, Received: " + version + " )");
        }
        return Op.read(this.in);
    }

    private TraceScope continueTraceSpan(DataTransferProtos.DataTransferTraceInfoProto proto, String description) {
        TraceScope scope = null;
        SpanId spanId = DataTransferProtoUtil.fromProto(proto);
        if (spanId != null) {
            scope = this.tracer.newScope(description, spanId);
        }
        return scope;
    }

    private TraceScope continueTraceSpan(DataTransferProtos.ClientOperationHeaderProto header, String description) {
        return this.continueTraceSpan(header.getBaseHeader(), description);
    }

    private TraceScope continueTraceSpan(DataTransferProtos.BaseHeaderProto header, String description) {
        return this.continueTraceSpan(header.getTraceInfo(), description);
    }

    protected final void processOp(Op op) throws IOException {
        switch (op) {
            case READ_BLOCK: {
                this.opReadBlock();
                break;
            }
            case WRITE_BLOCK: {
                this.opWriteBlock(this.in);
                break;
            }
            case REPLACE_BLOCK: {
                this.opReplaceBlock(this.in);
                break;
            }
            case COPY_BLOCK: {
                this.opCopyBlock(this.in);
                break;
            }
            case BLOCK_CHECKSUM: {
                this.opBlockChecksum(this.in);
                break;
            }
            case TRANSFER_BLOCK: {
                this.opTransferBlock(this.in);
                break;
            }
            case REQUEST_SHORT_CIRCUIT_FDS: {
                this.opRequestShortCircuitFds(this.in);
                break;
            }
            case RELEASE_SHORT_CIRCUIT_FDS: {
                this.opReleaseShortCircuitFds(this.in);
                break;
            }
            case REQUEST_SHORT_CIRCUIT_SHM: {
                this.opRequestShortCircuitShm(this.in);
                break;
            }
            default: {
                throw new IOException("Unknown op " + (Object)((Object)op) + " in data stream");
            }
        }
    }

    private static CachingStrategy getCachingStrategy(DataTransferProtos.CachingStrategyProto strategy) {
        Boolean dropBehind = strategy.hasDropBehind() ? Boolean.valueOf(strategy.getDropBehind()) : null;
        Long readahead = strategy.hasReadahead() ? Long.valueOf(strategy.getReadahead()) : null;
        return new CachingStrategy(dropBehind, readahead);
    }

    private void opReadBlock() throws IOException {
        DataTransferProtos.OpReadBlockProto proto = DataTransferProtos.OpReadBlockProto.parseFrom(PBHelper.vintPrefixed(this.in));
        try (TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());){
            this.readBlock(PBHelper.convert(proto.getHeader().getBaseHeader().getBlock()), PBHelper.convert(proto.getHeader().getBaseHeader().getToken()), proto.getHeader().getClientName(), proto.getOffset(), proto.getLen(), proto.getSendChecksums(), proto.hasCachingStrategy() ? Receiver.getCachingStrategy(proto.getCachingStrategy()) : CachingStrategy.newDefaultStrategy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opWriteBlock(DataInputStream in) throws IOException {
        DataTransferProtos.OpWriteBlockProto proto = DataTransferProtos.OpWriteBlockProto.parseFrom(PBHelper.vintPrefixed(in));
        DatanodeInfo[] targets = PBHelper.convert(proto.getTargetsList());
        try (TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());){
            this.writeBlock(PBHelper.convert(proto.getHeader().getBaseHeader().getBlock()), PBHelper.convertStorageType(proto.getStorageType()), PBHelper.convert(proto.getHeader().getBaseHeader().getToken()), proto.getHeader().getClientName(), targets, PBHelper.convertStorageTypes(proto.getTargetStorageTypesList(), targets.length), PBHelper.convert(proto.getSource()), DataTransferProtoUtil.fromProto(proto.getStage()), proto.getPipelineSize(), proto.getMinBytesRcvd(), proto.getMaxBytesRcvd(), proto.getLatestGenerationStamp(), DataTransferProtoUtil.fromProto(proto.getRequestedChecksum()), proto.hasCachingStrategy() ? Receiver.getCachingStrategy(proto.getCachingStrategy()) : CachingStrategy.newDefaultStrategy(), proto.hasPinning() ? proto.getPinning() : false, PBHelper.convertBooleanList(proto.getTargetPinningsList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opTransferBlock(DataInputStream in) throws IOException {
        DataTransferProtos.OpTransferBlockProto proto = DataTransferProtos.OpTransferBlockProto.parseFrom(PBHelper.vintPrefixed(in));
        DatanodeInfo[] targets = PBHelper.convert(proto.getTargetsList());
        try (TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());){
            this.transferBlock(PBHelper.convert(proto.getHeader().getBaseHeader().getBlock()), PBHelper.convert(proto.getHeader().getBaseHeader().getToken()), proto.getHeader().getClientName(), targets, PBHelper.convertStorageTypes(proto.getTargetStorageTypesList(), targets.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opRequestShortCircuitFds(DataInputStream in) throws IOException {
        DataTransferProtos.OpRequestShortCircuitAccessProto proto = DataTransferProtos.OpRequestShortCircuitAccessProto.parseFrom(PBHelper.vintPrefixed(in));
        ShortCircuitShm.SlotId slotId = proto.hasSlotId() ? PBHelper.convert(proto.getSlotId()) : null;
        try (TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());){
            this.requestShortCircuitFds(PBHelper.convert(proto.getHeader().getBlock()), PBHelper.convert(proto.getHeader().getToken()), slotId, proto.getMaxVersion(), proto.getSupportsReceiptVerification());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opReleaseShortCircuitFds(DataInputStream in) throws IOException {
        DataTransferProtos.ReleaseShortCircuitAccessRequestProto proto = DataTransferProtos.ReleaseShortCircuitAccessRequestProto.parseFrom(PBHelper.vintPrefixed(in));
        try (TraceScope traceScope = this.continueTraceSpan(proto.getTraceInfo(), proto.getClass().getSimpleName());){
            this.releaseShortCircuitFds(PBHelper.convert(proto.getSlotId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opRequestShortCircuitShm(DataInputStream in) throws IOException {
        DataTransferProtos.ShortCircuitShmRequestProto proto = DataTransferProtos.ShortCircuitShmRequestProto.parseFrom(PBHelper.vintPrefixed(in));
        try (TraceScope traceScope = this.continueTraceSpan(proto.getTraceInfo(), proto.getClass().getSimpleName());){
            this.requestShortCircuitShm(proto.getClientName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opReplaceBlock(DataInputStream in) throws IOException {
        DataTransferProtos.OpReplaceBlockProto proto = DataTransferProtos.OpReplaceBlockProto.parseFrom(PBHelper.vintPrefixed(in));
        try (TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());){
            this.replaceBlock(PBHelper.convert(proto.getHeader().getBlock()), PBHelper.convertStorageType(proto.getStorageType()), PBHelper.convert(proto.getHeader().getToken()), proto.getDelHint(), PBHelper.convert(proto.getSource()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opCopyBlock(DataInputStream in) throws IOException {
        DataTransferProtos.OpCopyBlockProto proto = DataTransferProtos.OpCopyBlockProto.parseFrom(PBHelper.vintPrefixed(in));
        try (TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());){
            this.copyBlock(PBHelper.convert(proto.getHeader().getBlock()), PBHelper.convert(proto.getHeader().getToken()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opBlockChecksum(DataInputStream in) throws IOException {
        DataTransferProtos.OpBlockChecksumProto proto = DataTransferProtos.OpBlockChecksumProto.parseFrom(PBHelper.vintPrefixed(in));
        try (TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());){
            this.blockChecksum(PBHelper.convert(proto.getHeader().getBlock()), PBHelper.convert(proto.getHeader().getToken()));
        }
    }
}

