/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;

public class LastUpdatedContentSummary
extends QuotaUsage {
    protected LastUpdatedContentSummary(Builder builder) {
        super((QuotaUsage.Builder)builder);
    }

    public long getFileAndDirCount() {
        return super.getFileAndDirectoryCount();
    }

    public long getSpaceConsumed() {
        return super.getSpaceConsumed();
    }

    public long getNsQuota() {
        return super.getQuota();
    }

    public long getDsQuota() {
        return super.getSpaceQuota();
    }

    public boolean equals(Object to) {
        return super.equals(to);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static class Builder
    extends QuotaUsage.Builder {
        public Builder fileAndDirectoryCount(long count) {
            super.fileAndDirectoryCount(count);
            return this;
        }

        public Builder quota(long quota) {
            super.quota(quota);
            return this;
        }

        public Builder spaceConsumed(long spaceConsumed) {
            super.spaceConsumed(spaceConsumed);
            return this;
        }

        public Builder spaceQuota(long spaceQuota) {
            super.spaceQuota(spaceQuota);
            return this;
        }

        public Builder typeConsumed(long[] typeConsumed) {
            super.typeConsumed(typeConsumed);
            return this;
        }

        public Builder typeQuota(StorageType type, long quota) {
            super.typeQuota(type, quota);
            return this;
        }

        public Builder typeConsumed(StorageType type, long consumed) {
            super.typeConsumed(type, consumed);
            return this;
        }

        public Builder typeQuota(long[] typeQuota) {
            super.typeQuota(typeQuota);
            return this;
        }

        public LastUpdatedContentSummary build() {
            return new LastUpdatedContentSummary(this);
        }
    }
}

