/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.ProvidedBlockCacheLoc;
import io.hops.transaction.lock.BaseIndividualBlockLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;

final class ProvidedBlockCacheLocLock
extends Lock {
    ProvidedBlockCacheLocLock() {
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        Lock lock = locks.getLock(Lock.Type.Block);
        if (lock instanceof BaseIndividualBlockLock) {
            BaseIndividualBlockLock individualBlockLock = (BaseIndividualBlockLock)lock;
            HashSet<Long> blockIds = new HashSet<Long>();
            for (BlockInfoContiguous blk : individualBlockLock.getBlocks()) {
                blockIds.add(blk.getBlockId());
            }
            if (blockIds.size() > 0) {
                Collection collection = this.acquireLockList(DEFAULT_LOCK_TYPE, (FinderType)ProvidedBlockCacheLoc.Finder.ByBlockIds, blockIds.toArray(new Long[blockIds.size()]));
            }
        } else {
            throw new TransactionLocks.LockNotAddedException("Block Lock wasn't added");
        }
    }

    protected Lock.Type getType() {
        return Lock.Type.ProvidedBlkCacheLoc;
    }
}

