/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INode;

public class MultipleINodesLock
extends BaseINodeLock {
    private final List<INodeIdentifier> inodeIdentifiers;
    private final TransactionLockTypes.INodeLockType lockType;
    private long[] inodeIds;

    public MultipleINodesLock(List<INodeIdentifier> inodeIdentifiers, TransactionLockTypes.INodeLockType lockType) {
        this.inodeIdentifiers = inodeIdentifiers;
        this.inodeIds = new long[inodeIdentifiers.size()];
        this.lockType = lockType;
        if (lockType == TransactionLockTypes.INodeLockType.READ_COMMITTED) {
            throw new IllegalArgumentException("For READ_COMMITTED locks BatchedINodeLocks as better performance");
        }
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        List<INode> inodes;
        if (this.inodeIdentifiers != null && !this.inodeIdentifiers.isEmpty()) {
            inodes = this.orderedReadWithLock();
            for (INode inode : inodes) {
                if (inode == null) continue;
                List<INode> pathInodes = this.readUpInodes(inode);
                this.addPathINodesAndUpdateResolvingCache(INodeUtil.constructPath(pathInodes), pathInodes);
            }
        } else {
            throw new StorageException("INodeIdentifier object is not properly initialized ");
        }
        this.addIndividualINodes(inodes);
    }

    private List<INode> orderedReadWithLock() throws TransactionContextException, StorageException {
        ArrayList<INode> inodes = new ArrayList<INode>();
        Collections.sort(this.inodeIdentifiers);
        for (int i = 0; i < this.inodeIdentifiers.size(); ++i) {
            INodeIdentifier inodeIdentifier = this.inodeIdentifiers.get(i);
            this.inodeIds[i] = inodeIdentifier.getInodeId();
            INode inode = this.find(this.lockType, inodeIdentifier.getName(), inodeIdentifier.getPid(), inodeIdentifier.getPartitionId(), inodeIdentifier.getInodeId());
            if (inode == null) continue;
            inodes.add(inode);
        }
        return inodes;
    }

    long[] getINodeIds() {
        return this.inodeIds;
    }

    public String toString() {
        if (this.inodeIdentifiers != null) {
            return "Multiple INode Lock = { " + this.inodeIdentifiers.size() + " inodes locked  }";
        }
        return "No inodes selected for locking";
    }
}

