/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.LeaseCreationLock;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.LeaseCreationLockComparator;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.Lease;

public final class LeaseLock
extends Lock {
    private final TransactionLockTypes.LockType lockType;
    private final String leaseHolder;
    private final List<Lease> leases;
    private final String singleFileLock;
    private final TransactionLockTypes.LeaseHolderResolveType resolveType;
    private final int LEASE_CREATION_LOCK_ROWS;

    LeaseLock(TransactionLockTypes.LockType lockType, TransactionLockTypes.LeaseHolderResolveType resolveType, String leaseHolder, String singleFileLock, int leaseCreationLockRows) {
        this.lockType = lockType;
        this.leaseHolder = leaseHolder;
        this.leases = new ArrayList<Lease>();
        this.resolveType = resolveType;
        this.singleFileLock = singleFileLock;
        this.LEASE_CREATION_LOCK_ROWS = leaseCreationLockRows;
        if (resolveType == TransactionLockTypes.LeaseHolderResolveType.SINGLE_PATH && (singleFileLock == null || singleFileLock.isEmpty())) {
            throw new IllegalArgumentException("Please specify a lease path to lock");
        }
    }

    LeaseLock(TransactionLockTypes.LockType lockType, int leaseCreationLockRows) {
        this(lockType, TransactionLockTypes.LeaseHolderResolveType.ALL_PATHS, null, null, leaseCreationLockRows);
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        LeaseLock.setLockMode((TransactionLockTypes.LockType)this.lockType);
        HashSet<String> hldrs = new HashSet<String>();
        if (this.leaseHolder != null) {
            hldrs.add(this.leaseHolder);
        }
        if (locks.containsLock(Lock.Type.INode)) {
            BaseINodeLock inodeLock = (BaseINodeLock)locks.getLock(Lock.Type.INode);
            for (INode f : inodeLock.getAllResolvedINodes()) {
                if (!(f instanceof INodeFile) || !f.isUnderConstruction()) continue;
                hldrs.add(((INodeFile)f).getFileUnderConstructionFeature().getClientName());
            }
        }
        if (TransactionLockTypes.LeaseHolderResolveType.ALL_SYSTEM_PATHS_FOR_TESTSING == this.resolveType) {
            Collection leases = this.acquireLockList(this.lockType, Lease.Finder.All, new Object[0]);
            for (Lease lease : leases) {
                hldrs.add(lease.getHolder());
            }
        }
        ArrayList holders = new ArrayList(hldrs);
        Collections.sort(holders, new LeaseCreationLockComparator(this.LEASE_CREATION_LOCK_ROWS));
        if (holders.isEmpty() && !locks.containsLock(Lock.Type.INode)) {
            Collection allLeases = this.acquireLockList(this.lockType, Lease.Finder.All, new Object[0]);
            if (this.leases != null) {
                this.leases.addAll(allLeases);
            }
        }
        for (String h : holders) {
            this.acquireLock(this.lockType, (FinderType)LeaseCreationLock.Finder.ByRowID, new Object[]{Math.abs(Lease.getHolderId(h)) % this.LEASE_CREATION_LOCK_ROWS});
            Lease lease = (Lease)this.acquireLock(this.lockType, Lease.Finder.ByHolder, new Object[]{h, Lease.getHolderId(h)});
            if (lease == null) continue;
            this.leases.add(lease);
        }
    }

    Collection<Lease> getLeases() {
        return this.leases;
    }

    public TransactionLockTypes.LockType getLockType() {
        return this.lockType;
    }

    protected final Lock.Type getType() {
        return Lock.Type.Lease;
    }

    public String getSingleFileLock() {
        return this.singleFileLock;
    }

    public TransactionLockTypes.LeaseHolderResolveType getResolveType() {
        return this.resolveType;
    }

    public String getLeaseHolder() {
        return this.leaseHolder;
    }
}

