/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import com.google.common.primitives.Longs;
import io.hops.common.INodeUtil;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.CachedBlock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.DatanodeID;

public class CachedBlockLock
extends Lock {
    private long[] blockIds;
    private DatanodeID datanodeId;
    private Collection<CachedBlock> cachedBlocks;

    public CachedBlockLock(List<Long> blockIds, DatanodeID datanodeId) {
        this.blockIds = Longs.toArray(blockIds);
        this.datanodeId = datanodeId;
    }

    public CachedBlockLock(DatanodeID datanodeId) {
        this.datanodeId = datanodeId;
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        this.cachedBlocks = this.acquireLockList(TransactionLockTypes.LockType.WRITE, (FinderType)CachedBlock.Finder.ByDatanodeId, new Object[]{this.datanodeId});
        if (this.blockIds != null) {
            long[] inodeIds = INodeUtil.resolveINodesFromBlockIds(this.blockIds);
            this.cachedBlocks.addAll(this.acquireLockList(TransactionLockTypes.LockType.WRITE, (FinderType)CachedBlock.Finder.ByBlockIdsAndINodeIds, new Object[]{this.blockIds, inodeIds, this.datanodeId}));
        }
    }

    protected Lock.Type getType() {
        return Lock.Type.CachedBlock;
    }

    public Collection<CachedBlock> getAllResolvedCachedBlock() {
        return this.cachedBlocks;
    }
}

