/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.transaction.EntityManager;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.CachePool;

public class CachePoolLock
extends Lock {
    private final List<String> poolNames;
    private final TransactionLockTypes.LockType lockType;

    public CachePoolLock(String poolName) {
        this.poolNames = new ArrayList<String>(1);
        this.poolNames.add(poolName);
        this.lockType = TransactionLockTypes.LockType.WRITE;
    }

    public CachePoolLock(List<String> poolNames) {
        this(poolNames, TransactionLockTypes.LockType.WRITE);
    }

    public CachePoolLock(TransactionLockTypes.LockType lockType) {
        this(null, lockType);
    }

    public CachePoolLock(List<String> poolNames, TransactionLockTypes.LockType lockType) {
        this.poolNames = poolNames;
        this.lockType = lockType;
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        CachePoolLock.setLockMode((TransactionLockTypes.LockType)this.lockType);
        if (this.poolNames != null && !this.poolNames.isEmpty()) {
            for (String poolName : this.poolNames) {
                EntityManager.find((FinderType)CachePool.Finder.ByName, (Object[])new Object[]{poolName});
            }
        } else {
            EntityManager.findList((FinderType)CachePool.Finder.All, (Object[])new Object[0]);
        }
    }

    protected Lock.Type getType() {
        return Lock.Type.cachePool;
    }
}

