/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.BlockChecksumDataAccess;
import io.hops.metadata.hdfs.entity.BlockChecksum;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.namenode.INode;

class BlockChecksumLock
extends Lock {
    private final String target;
    private final int blockIndex;

    BlockChecksumLock(String target, int blockIndex) {
        this.target = target;
        this.blockIndex = blockIndex;
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        BaseINodeLock iNodeLock = (BaseINodeLock)locks.getLock(Lock.Type.INode);
        INode iNode = iNodeLock.getTargetINode(this.target);
        if (!BaseINodeLock.isStoredInDB(iNode)) {
            BlockChecksumDataAccess.KeyTuple key = new BlockChecksumDataAccess.KeyTuple(iNode.getId(), this.blockIndex);
            this.acquireLock(DEFAULT_LOCK_TYPE, (FinderType)BlockChecksum.Finder.ByKeyTuple, new Object[]{key});
        } else {
            LOG.debug((Object)("Stuffed Inode:  BlockChecksumLock. Skipping acquring locks on the inode named: " + iNode.getLocalName() + " as the file is stored in the database"));
        }
    }

    protected final Lock.Type getType() {
        return Lock.Type.BlockChecksum;
    }
}

