/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INode;

public class BatchedINodeLock
extends BaseINodeLock {
    private final List<INodeIdentifier> inodeIdentifiers;
    private long[] inodeIds;

    public BatchedINodeLock(List<INodeIdentifier> inodeIdentifiers) {
        this.inodeIdentifiers = inodeIdentifiers;
        this.inodeIds = new long[inodeIdentifiers.size()];
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        List<INode> inodes;
        if (this.inodeIdentifiers != null && !this.inodeIdentifiers.isEmpty()) {
            inodes = this.batchRead();
            for (INode inode : inodes) {
                if (inode == null) continue;
                List<INode> pathInodes = this.readUpInodes(inode);
                this.addPathINodesAndUpdateResolvingCache(INodeUtil.constructPath(pathInodes), pathInodes);
            }
        } else {
            throw new StorageException("INodeIdentifier object is not properly initialized ");
        }
        this.addIndividualINodes(inodes);
    }

    private List<INode> batchRead() throws TransactionContextException, StorageException {
        String[] names = new String[this.inodeIdentifiers.size()];
        long[] parentIds = new long[this.inodeIdentifiers.size()];
        long[] partitionIds = new long[this.inodeIdentifiers.size()];
        for (int i = 0; i < this.inodeIdentifiers.size(); ++i) {
            INodeIdentifier inodeIdentifier = this.inodeIdentifiers.get(i);
            names[i] = inodeIdentifier.getName();
            parentIds[i] = inodeIdentifier.getPid();
            partitionIds[i] = inodeIdentifier.getPartitionId();
            this.inodeIds[i] = inodeIdentifier.getInodeId();
        }
        List<INode> inodes = this.find(TransactionLockTypes.INodeLockType.READ_COMMITTED, names, parentIds, partitionIds, false);
        return inodes;
    }

    long[] getINodeIds() {
        return this.inodeIds;
    }

    public String toString() {
        if (this.inodeIdentifiers != null) {
            return "Batch INode Lock = { " + this.inodeIdentifiers.size() + " inodes locked  }";
        }
        return "No inodes selected for batch locking";
    }
}

