/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.XAttrDataAccess;
import io.hops.metadata.hdfs.entity.StoredXAttr;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.context.HdfsTransactionContextMaintenanceCmds;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class XAttrContext
extends BaseEntityContext<StoredXAttr.PrimaryKey, StoredXAttr> {
    private final XAttrDataAccess<StoredXAttr, StoredXAttr.PrimaryKey> dataAccess;
    private final Map<Long, Collection<StoredXAttr>> xAttrsByInodeId = new HashMap<Long, Collection<StoredXAttr>>();

    public XAttrContext(XAttrDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    StoredXAttr.PrimaryKey getKey(StoredXAttr storedXAttr) {
        return storedXAttr.getPrimaryKey();
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    public StoredXAttr find(FinderType<StoredXAttr> finder, Object ... params) throws TransactionContextException, StorageException {
        StoredXAttr.Finder xfinder = (StoredXAttr.Finder)finder;
        switch (xfinder) {
            case ByPrimaryKey: {
                return this.findByPrimaryKey(xfinder, params);
            }
            case ByPrimaryKeyLocal: {
                return this.findByPrimaryKeyLocal(xfinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<StoredXAttr> findList(FinderType<StoredXAttr> finder, Object ... params) throws TransactionContextException, StorageException {
        StoredXAttr.Finder xfinder = (StoredXAttr.Finder)finder;
        switch (xfinder) {
            case ByInodeId: {
                return this.findByInodeId(xfinder, params);
            }
            case ByInodeIdLocal: {
                return this.findByInodeIdLocal(xfinder, params);
            }
            case ByPrimaryKeyBatch: {
                return this.findByPrimaryKeyBatch(xfinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    private StoredXAttr findByPrimaryKey(StoredXAttr.Finder finder, Object[] params) throws StorageException, StorageCallPreventedException {
        StoredXAttr.PrimaryKey pk = (StoredXAttr.PrimaryKey)params[0];
        StoredXAttr result = null;
        if (this.contains(pk)) {
            result = (StoredXAttr)this.get(pk);
            this.hit((FinderType)finder, result, new Object[]{"pk", pk, "results", result});
        } else {
            this.aboutToAccessStorage((FinderType)finder, params);
            List results = this.dataAccess.getXAttrsByPrimaryKeyBatch(Arrays.asList(pk));
            result = (StoredXAttr)results.get(0);
            this.gotFromDB(pk, result);
            this.miss((FinderType)finder, result, new Object[]{"pk", pk, "results", results});
        }
        return result;
    }

    private StoredXAttr findByPrimaryKeyLocal(StoredXAttr.Finder finder, Object[] params) throws StorageException, StorageCallPreventedException {
        StoredXAttr.PrimaryKey pk = (StoredXAttr.PrimaryKey)params[0];
        StoredXAttr result = null;
        if (this.contains(pk)) {
            result = (StoredXAttr)this.get(pk);
            this.hit((FinderType)finder, result, new Object[]{"pk", pk, "results", result});
        }
        return result;
    }

    private Collection<StoredXAttr> findByInodeId(StoredXAttr.Finder finder, Object[] params) throws StorageException, StorageCallPreventedException {
        long inodeId = (Long)params[0];
        Collection results = null;
        if (this.xAttrsByInodeId.containsKey(inodeId)) {
            results = this.xAttrsByInodeId.get(inodeId);
            this.hit((FinderType)finder, results, new Object[]{"inodeId", inodeId, "results", results});
        } else {
            this.aboutToAccessStorage((FinderType)finder, params);
            results = this.dataAccess.getXAttrsByInodeId(inodeId);
            this.gotFromDB(results);
            this.xAttrsByInodeId.put(inodeId, results);
            this.miss((FinderType)finder, results, new Object[]{"inodeId", inodeId, "results", results});
        }
        return results;
    }

    private Collection<StoredXAttr> findByInodeIdLocal(StoredXAttr.Finder finder, Object[] params) throws StorageException, StorageCallPreventedException {
        long inodeId = (Long)params[0];
        Collection<StoredXAttr> results = null;
        if (this.xAttrsByInodeId.containsKey(inodeId)) {
            results = this.xAttrsByInodeId.get(inodeId);
            this.hit((FinderType)finder, results, new Object[]{"inodeId", inodeId, "results", results});
        }
        return results;
    }

    private Collection<StoredXAttr> findByPrimaryKeyBatch(StoredXAttr.Finder finder, Object[] params) throws StorageException, StorageCallPreventedException {
        List pks = (List)params[0];
        List results = null;
        if (this.containsAll(pks)) {
            results = this.getAll(pks);
            this.hit((FinderType)finder, results, new Object[]{"pks", pks, "results", results});
        } else {
            this.aboutToAccessStorage((FinderType)finder, params);
            results = this.dataAccess.getXAttrsByPrimaryKeyBatch(pks);
            this.gotFromDB(pks, results);
            this.miss((FinderType)finder, results, new Object[]{"pks", pks, "results", results});
        }
        return results;
    }

    private void gotFromDB(List<StoredXAttr.PrimaryKey> pks, List<StoredXAttr> results) {
        HashSet notFoundPks = Sets.newHashSet(pks);
        for (StoredXAttr attr : results) {
            this.gotFromDB(attr);
            if (!this.xAttrsByInodeId.containsKey(attr.getInodeId())) {
                this.xAttrsByInodeId.put(attr.getInodeId(), new ArrayList());
            }
            this.xAttrsByInodeId.get(attr.getInodeId()).add(attr);
            notFoundPks.remove(attr.getPrimaryKey());
        }
        for (StoredXAttr.PrimaryKey pk : notFoundPks) {
            this.gotFromDB(pk, null);
            if (this.xAttrsByInodeId.containsKey(pk.getInodeId())) continue;
            this.xAttrsByInodeId.put(pk.getInodeId(), null);
        }
    }

    private boolean containsAll(List<StoredXAttr.PrimaryKey> pks) {
        for (StoredXAttr.PrimaryKey pk : pks) {
            if (this.contains(pk)) continue;
            return false;
        }
        return true;
    }

    private List<StoredXAttr> getAll(List<StoredXAttr.PrimaryKey> pks) {
        ArrayList attrs = Lists.newArrayListWithExpectedSize((int)pks.size());
        for (StoredXAttr.PrimaryKey pk : pks) {
            attrs.add(this.get(pk));
        }
        return attrs;
    }

    public void snapshotMaintenance(TransactionContextMaintenanceCmds cmds, Object ... params) throws TransactionContextException {
        HdfsTransactionContextMaintenanceCmds hopCmds = (HdfsTransactionContextMaintenanceCmds)cmds;
        if (hopCmds == HdfsTransactionContextMaintenanceCmds.NoXAttrsAttached) {
            Long inodeId = (Long)params[0];
            this.xAttrsByInodeId.put(inodeId, null);
        }
    }

    public void clear() throws TransactionContextException {
        super.clear();
        this.xAttrsByInodeId.clear();
    }

    public void add(StoredXAttr attr) throws TransactionContextException {
        if (!this.xAttrsByInodeId.containsKey(attr.getInodeId()) || this.xAttrsByInodeId.get(attr.getInodeId()) == null) {
            this.xAttrsByInodeId.put(attr.getInodeId(), new ArrayList());
        }
        StoredXAttr toRemove = null;
        for (StoredXAttr sattr : this.xAttrsByInodeId.get(attr.getInodeId())) {
            if (!sattr.getPrimaryKey().equals((Object)attr.getPrimaryKey())) continue;
            toRemove = sattr;
            break;
        }
        if (toRemove != null) {
            this.xAttrsByInodeId.remove(attr);
        }
        this.xAttrsByInodeId.get(attr.getInodeId()).add(attr);
        super.add((Object)attr);
    }
}

