/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.OngoingSubTreeOpsDataAccess;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SubTreeOperationsContext
extends BaseEntityContext<String, SubTreeOperation> {
    private final OngoingSubTreeOpsDataAccess<SubTreeOperation> dataAccess;
    private final Map<String, Collection<SubTreeOperation>> prefixToSubTreeOperation = new HashMap<String, Collection<SubTreeOperation>>();
    private final Map<String, SubTreeOperation> pathToSubTreeOperation = new HashMap<String, SubTreeOperation>();

    public SubTreeOperationsContext(OngoingSubTreeOpsDataAccess<SubTreeOperation> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void update(SubTreeOperation hopSubTeeOperation) throws TransactionContextException {
        super.update((Object)hopSubTeeOperation);
        this.addInternal(hopSubTeeOperation);
        if (this.isLogTraceEnabled()) {
            this.log("updated-sub-tree-op", new Object[]{"path", hopSubTeeOperation.getPath(), "nnid", hopSubTeeOperation.getNameNodeId(), "op", hopSubTeeOperation.getOpType()});
        }
    }

    public void remove(SubTreeOperation hopSubTeeOperation) throws TransactionContextException {
        super.remove((Object)hopSubTeeOperation);
        if (this.isLogTraceEnabled()) {
            this.log("removed-sub-tree-op", new Object[]{"path", hopSubTeeOperation.getPath(), "nnid", hopSubTeeOperation.getNameNodeId(), "op", hopSubTeeOperation.getOpType()});
        }
    }

    public SubTreeOperation find(FinderType<SubTreeOperation> finder, Object ... params) throws TransactionContextException, StorageException {
        SubTreeOperation.Finder f = (SubTreeOperation.Finder)finder;
        switch (f) {
            case ByPath: {
                return this.findByPath(f, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<SubTreeOperation> findList(FinderType<SubTreeOperation> finder, Object ... params) throws TransactionContextException, StorageException {
        SubTreeOperation.Finder lFinder = (SubTreeOperation.Finder)finder;
        switch (lFinder) {
            case ByPathPrefix: {
                return this.findByPathPrefix(lFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    public void clear() throws TransactionContextException {
        super.clear();
        this.prefixToSubTreeOperation.clear();
    }

    String getKey(SubTreeOperation hopSubTeeOperation) {
        return hopSubTeeOperation.getPath();
    }

    private SubTreeOperation findByPath(SubTreeOperation.Finder finder, Object[] params) throws StorageCallPreventedException, StorageException {
        String path = (String)params[0];
        SubTreeOperation result = null;
        if (this.pathToSubTreeOperation.containsKey(path)) {
            result = this.pathToSubTreeOperation.get(path);
            this.hit((FinderType)finder, result, new Object[]{"Path ", path});
        } else {
            this.aboutToAccessStorage((FinderType)finder, params);
            result = (SubTreeOperation)this.dataAccess.findByPath(path);
            this.gotFromDBInternal(path, result);
            this.miss((FinderType)finder, result, new Object[]{"Path", path});
        }
        return result;
    }

    private Collection<SubTreeOperation> findByPathPrefix(SubTreeOperation.Finder lFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        String prefix = (String)params[0];
        Collection result = null;
        if (this.prefixToSubTreeOperation.containsKey(prefix)) {
            result = this.prefixToSubTreeOperation.get(prefix);
            this.hit((FinderType)lFinder, result, new Object[]{"Path Prefix", prefix, "numOfOps", result.size()});
        } else {
            this.aboutToAccessStorage((FinderType)lFinder, params);
            result = this.dataAccess.findByPathsByPrefix(prefix);
            this.gotFromDBInternal(prefix, result);
            this.miss((FinderType)lFinder, result, new Object[]{"Path Prefix", prefix, "numOfOps", result.size()});
        }
        return result;
    }

    void gotFromDB(Collection<SubTreeOperation> subTreeOps) {
        super.gotFromDB(subTreeOps);
    }

    private void gotFromDBInternal(String pathPrefix, Collection<SubTreeOperation> subTreeOps) {
        this.gotFromDB(subTreeOps);
        this.addInternal(pathPrefix, subTreeOps);
    }

    private void gotFromDBInternal(String path, SubTreeOperation subTreeOp) {
        this.gotFromDB(subTreeOp);
        this.addInternal(path, subTreeOp);
    }

    private void addInternal(String prefix, Collection<SubTreeOperation> subTreeOps) {
        Collection<SubTreeOperation> list = this.prefixToSubTreeOperation.get(prefix);
        if (list == null) {
            list = new ArrayList<SubTreeOperation>();
            this.prefixToSubTreeOperation.put(prefix, list);
        }
        if (subTreeOps != null) {
            list.addAll(subTreeOps);
            this.prefixToSubTreeOperation.put(prefix, list);
        }
    }

    private void addInternal(String path, SubTreeOperation subTreeOp) {
        this.pathToSubTreeOperation.put(path, subTreeOp);
    }

    private void addInternal(SubTreeOperation op) {
        ArrayList<SubTreeOperation> list = new ArrayList<SubTreeOperation>();
        list.add(op);
        this.addInternal(op.getPath(), list);
    }
}

