/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.ReplicaUnderConstructionDataAccess;
import io.hops.transaction.context.BaseReplicaContext;
import io.hops.transaction.context.BlockPK;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hdfs.server.blockmanagement.ReplicaUnderConstruction;

public class ReplicaUnderConstructionContext
extends BaseReplicaContext<BlockPK.ReplicaPK, ReplicaUnderConstruction> {
    ReplicaUnderConstructionDataAccess dataAccess;

    public ReplicaUnderConstructionContext(ReplicaUnderConstructionDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    @Override
    public void update(ReplicaUnderConstruction replica) throws TransactionContextException {
        super.update(replica);
        if (this.isLogTraceEnabled()) {
            this.log("added-replicauc", new Object[]{"bid", replica.getBlockId(), "sid", replica.getStorageId(), "state", replica.getState().name()});
        }
    }

    @Override
    public void remove(ReplicaUnderConstruction replica) throws TransactionContextException {
        super.remove(replica);
        if (this.isLogTraceEnabled()) {
            this.log("removed-replicauc", new Object[]{"bid", replica.getBlockId(), "sid", replica.getStorageId(), "state", replica.getState().name()});
        }
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    public Collection<ReplicaUnderConstruction> findList(FinderType<ReplicaUnderConstruction> finder, Object ... params) throws TransactionContextException, StorageException {
        ReplicaUnderConstruction.Finder rFinder = (ReplicaUnderConstruction.Finder)finder;
        switch (rFinder) {
            case ByBlockIdAndINodeId: {
                return this.findByBlockId(rFinder, params);
            }
            case ByINodeId: {
                return this.findByINodeId(rFinder, params);
            }
            case ByINodeIds: {
                return this.findByINodeIds(rFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    BlockPK.ReplicaPK getKey(ReplicaUnderConstruction replica) {
        return new BlockPK.ReplicaPK(replica.getBlockId(), replica.getInodeId(), replica.getStorageId());
    }

    @Override
    ReplicaUnderConstruction cloneEntity(ReplicaUnderConstruction replicaUnderConstruction) {
        return this.cloneEntity(replicaUnderConstruction, replicaUnderConstruction.getInodeId());
    }

    @Override
    ReplicaUnderConstruction cloneEntity(ReplicaUnderConstruction replicaUnderConstruction, long inodeId) {
        return new ReplicaUnderConstruction(replicaUnderConstruction.getState(), replicaUnderConstruction.getStorageId(), replicaUnderConstruction.getBlockId(), inodeId, replicaUnderConstruction.getBucketId(), replicaUnderConstruction.getGenerationStamp());
    }

    private List<ReplicaUnderConstruction> findByBlockId(ReplicaUnderConstruction.Finder rFinder, Object[] params) throws TransactionContextException, StorageException {
        long blockId = (Long)params[0];
        long inodeId = (Long)params[1];
        List result = null;
        if (this.containsByBlock(blockId) || this.containsByINode(inodeId)) {
            result = this.getByBlock(blockId);
            this.hit(rFinder, result, new Object[]{"bid", blockId, "inodeid", inodeId});
        } else {
            this.aboutToAccessStorage(rFinder, params);
            result = this.dataAccess.findReplicaUnderConstructionByBlockId(blockId, inodeId);
            this.gotFromDB(new BlockPK(blockId, inodeId), result);
            this.miss(rFinder, result, new Object[]{"bid", blockId, "inodeid", inodeId});
        }
        return result;
    }

    private List<ReplicaUnderConstruction> findByINodeId(ReplicaUnderConstruction.Finder rFinder, Object[] params) throws TransactionContextException, StorageException {
        long inodeId = (Long)params[0];
        List result = null;
        if (this.containsByINode(inodeId)) {
            result = this.getByINode(inodeId);
            this.hit(rFinder, result, new Object[]{"inodeid", inodeId});
        } else {
            this.aboutToAccessStorage(rFinder, params);
            result = this.dataAccess.findReplicaUnderConstructionByINodeId(inodeId);
            this.gotFromDB(new BlockPK(null, inodeId), result);
            this.miss(rFinder, result, new Object[]{"inodeid", inodeId});
        }
        return result;
    }

    private List<ReplicaUnderConstruction> findByINodeIds(ReplicaUnderConstruction.Finder rFinder, Object[] params) throws TransactionContextException, StorageException {
        long[] inodeIds = (long[])params[0];
        this.aboutToAccessStorage(rFinder, params);
        List result = this.dataAccess.findReplicaUnderConstructionByINodeIds(inodeIds);
        this.gotFromDB(BlockPK.ReplicaPK.getKeys(inodeIds), result);
        this.miss(rFinder, result, new Object[]{"inodeids", Arrays.toString(inodeIds)});
        return result;
    }
}

